/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.paintinggui.handler;

import com.mcf.davidee.paintinggui.mod.PaintingSelection;
import com.mcf.davidee.paintinggui.packet.CPacketPainting;
import com.mcf.davidee.paintinggui.packet.NetworkHandler;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlacePaintingEventHandler {
    public PlacePaintingEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPaintingPlaced(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b().equals(Items.field_151159_an)) {
            EntityPlayer player = event.getEntityPlayer();
            EnumFacing face = event.getFace();
            BlockPos blockpos = event.getPos().func_177972_a(face);
            boolean flag = false;
            for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
                if (!face.equals((Object)enumFacing)) continue;
                flag = true;
            }
            if (flag && player.func_175151_a(blockpos, face, stack)) {
                EntityPainting painting = new EntityPainting(event.getWorld(), blockpos, face);
                if (painting.func_70518_d()) {
                    event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
                    if (!event.getEntityPlayer().func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    if (!event.getWorld().field_72995_K) {
                        painting.func_184523_o();
                        event.getWorld().func_72838_d((Entity)painting);
                        EntityPainting.EnumArt originalArt = painting.field_70522_e;
                        ArrayList<EntityPainting.EnumArt> validArts = new ArrayList<EntityPainting.EnumArt>();
                        EntityPainting.EnumArt[] enumArtArray = EntityPainting.EnumArt.values();
                        int n = enumArtArray.length;
                        for (int i = 0; i < n; ++i) {
                            EntityPainting.EnumArt art;
                            painting.field_70522_e = art = enumArtArray[i];
                            this.updatePaintingBoundingBox(painting);
                            if (!painting.func_70518_d()) continue;
                            validArts.add(art);
                        }
                        painting.field_70522_e = originalArt;
                        this.updatePaintingBoundingBox(painting);
                        EntityPainting.EnumArt[] enumArtArray2 = validArts.toArray(new EntityPainting.EnumArt[0]);
                        Arrays.sort(enumArtArray2, PaintingSelection.ART_COMPARATOR);
                        String[] names = new String[enumArtArray2.length];
                        for (int i = 0; i < enumArtArray2.length; ++i) {
                            names[i] = enumArtArray2[i].field_75702_A;
                        }
                        EntityPlayerMP playerMP = (EntityPlayerMP)event.getEntityPlayer();
                        NetworkHandler.NETWORK.sendTo((IMessage)new CPacketPainting(painting.func_145782_y(), names), playerMP);
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    private void updatePaintingBoundingBox(EntityPainting painting) {
        if (painting.field_174860_b != null) {
            double hangX = (double)painting.func_174857_n().func_177958_n() + 0.5;
            double hangY = (double)painting.func_174857_n().func_177956_o() + 0.5;
            double hangZ = (double)painting.func_174857_n().func_177952_p() + 0.5;
            double offsetWidth = painting.func_82329_d() % 32 == 0 ? 0.5 : 0.0;
            double offsetHeight = painting.func_82330_g() % 32 == 0 ? 0.5 : 0.0;
            hangX -= (double)painting.field_174860_b.func_82601_c() * 0.46875;
            hangZ -= (double)painting.field_174860_b.func_82599_e() * 0.46875;
            EnumFacing enumfacing = painting.field_174860_b.func_176735_f();
            painting.field_70165_t = hangX += offsetWidth * (double)enumfacing.func_82601_c();
            painting.field_70163_u = hangY += offsetHeight;
            painting.field_70161_v = hangZ += offsetWidth * (double)enumfacing.func_82599_e();
            double widthX = painting.func_82329_d();
            double height = painting.func_82330_g();
            double widthZ = painting.func_82329_d();
            if (painting.field_174860_b.func_176740_k() == EnumFacing.Axis.Z) {
                widthZ = 1.0;
            } else {
                widthX = 1.0;
            }
            painting.func_174826_a(new AxisAlignedBB(hangX - (widthX /= 32.0), hangY - (height /= 32.0), hangZ - (widthZ /= 32.0), hangX + widthX, hangY + height, hangZ + widthZ));
        }
    }
}

