/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.guilib.basic;

import com.mcf.davidee.guilib.core.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class Label
extends Widget {
    private String str;
    private int color;
    private int hoverColor;
    private List<Widget> tooltips;
    private boolean hover;
    private boolean center;
    private boolean shadow;
    private long hoverStart;

    public Label(String text, int color, int hoverColor, Widget ... tooltips) {
        this(text, color, hoverColor, true, tooltips);
    }

    public Label(String text, Widget ... tooltips) {
        this(text, 0xFFFFFF, 0xFFFFFF, true, tooltips);
    }

    public Label(String text, int color, int hoverColor, boolean center, Widget ... tooltips) {
        super(Label.getStringWidth(text), 11);
        this.center = center;
        this.str = text;
        this.color = color;
        this.hoverColor = hoverColor;
        this.shadow = true;
        this.tooltips = new ArrayList<Widget>();
        for (Widget w : tooltips) {
            this.tooltips.add(w);
        }
    }

    public Label(String text, boolean center, Widget ... tooltips) {
        this(text, 0xFFFFFF, 0xFFFFFF, center, tooltips);
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverColor = hoverColor;
    }

    public void setShadowedText(boolean useShadow) {
        this.shadow = useShadow;
    }

    public String getText() {
        return this.str;
    }

    public void setText(String text) {
        if (this.center) {
            this.x += this.width / 2;
        }
        this.str = text;
        this.width = Label.getStringWidth(text);
        if (this.center) {
            this.x -= this.width / 2;
        }
    }

    @Override
    public void draw(int mx, int my) {
        boolean newHover = this.inBounds(mx, my);
        if (newHover && !this.hover) {
            this.hoverStart = System.currentTimeMillis();
            for (Widget w : this.tooltips) {
                w.setPosition(mx + 3, this.y + this.height);
            }
        }
        this.hover = newHover;
        if (this.shadow) {
            this.mc.field_71466_p.func_175063_a(this.str, (float)this.x, (float)(this.y + 2), this.hover ? this.hoverColor : this.color);
        } else {
            this.mc.field_71466_p.func_78276_b(this.str, this.x, this.y + 2, this.hover ? this.hoverColor : this.color);
        }
    }

    @Override
    public List<Widget> getTooltips() {
        return this.hover && System.currentTimeMillis() - this.hoverStart >= 500L ? this.tooltips : super.getTooltips();
    }

    @Override
    public boolean click(int mx, int my) {
        return false;
    }

    private static int getStringWidth(String text) {
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }

    @Override
    public void setPosition(int x, int y) {
        this.x = this.center ? x - this.width / 2 : x;
        this.y = y;
    }
}

