/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.procedural;

import com.fantasticsource.tools.Random;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import com.fantasticsource.tools.procedural.Noise;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class NoiseTest {
    public static void main(String ... args) {
        long seed;
        if (args.length == 0) {
            args = new String[]{"ruffled alien"};
        }
        int w = 0;
        int h = 0;
        try {
            Display.create();
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            w = Display.getWidth();
            h = Display.getHeight();
            GL11.glViewport((int)0, (int)0, (int)w, (int)h);
            GL11.glOrtho((double)0.0, (double)w, (double)h, (double)0.0, (double)-1.0, (double)1.0);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        try {
            seed = Long.parseLong(args[1]);
        }
        catch (Exception e) {
            seed = new Random().nextLong();
        }
        int[] permutations = Noise.genPermutations(seed);
        String computeMode = "raw";
        double amplitude = 1.0;
        double amplitudeGain = 1.0;
        double frequency = 1.0;
        double frequencyGain = 1.0;
        int octaves = 1;
        switch (args[0].toLowerCase()) {
            case "raw 1": {
                break;
            }
            case "raw 2": {
                frequency = 2.0;
                break;
            }
            case "raw 3": {
                frequency = 0.25;
                break;
            }
            case "raw 4": {
                frequency = 0.023;
                break;
            }
            case "raw 5": {
                octaves = 2;
                amplitudeGain = 0.6;
                frequency = 0.23;
                frequencyGain = 0.1;
                break;
            }
            case "raw clouds 1": {
                amplitude = 0.75;
                frequency = 0.002;
                amplitudeGain = 0.04;
                frequencyGain = 5.0;
                octaves = 5;
                break;
            }
            case "raw clouds 2": {
                amplitude = 0.75;
                frequency = 0.002;
                amplitudeGain = 0.04;
                frequencyGain = 5.0;
                octaves = 5;
                break;
            }
            case "islands 1": {
                octaves = 2;
                amplitudeGain = 1.1;
                frequency = 0.002;
                frequencyGain = 0.2;
                break;
            }
            case "fabric 1": {
                octaves = 2;
                amplitudeGain = 0.6;
                frequency = 1.69;
                frequencyGain = 1.3;
                break;
            }
            case "heightmap 1": {
                computeMode = "heightmap";
                octaves = 3;
                amplitudeGain = 15.0;
                frequency = 4.0;
                frequencyGain = 2.0;
                break;
            }
            case "mountains 1": {
                computeMode = "heightmap";
                amplitudeGain = 15.0;
                frequency = 0.005;
                break;
            }
            case "curves and points": {
                computeMode = "heightmap";
                amplitude = 15.0;
                frequency = 0.001;
                break;
            }
            case "mountains 2": {
                computeMode = "heightmap 2";
                amplitude = 2.0735999999;
                frequency = 0.0080375515;
                break;
            }
            case "thick spikes": {
                computeMode = "heightmap 2";
                frequency = 0.1238347294;
                break;
            }
            case "thin spikes": {
                computeMode = "heightmap 2";
                frequency = 0.8874444496;
                break;
            }
            case "tiny spikes": {
                computeMode = "heightmap 2";
                frequency = 0.6162808678;
                break;
            }
            case "volcano tunnels 1": {
                computeMode = "volcano tunnels";
                frequency = 0.01;
                amplitude = 100.0;
                break;
            }
            case "volcano tunnels 2": {
                computeMode = "volcano tunnels";
                amplitude = 110.0;
                frequency = 0.001;
                break;
            }
            case "volcano tunnels 3": {
                computeMode = "volcano tunnels";
                octaves = 2;
                amplitude = 110.0;
                amplitudeGain = 110.0;
                frequency = 0.02;
                frequencyGain = 2.0;
                break;
            }
            case "volcano tunnels 4": {
                computeMode = "volcano tunnels";
                octaves = 3;
                amplitude = 110.0;
                amplitudeGain = 110.0;
                frequency = 0.005;
                frequencyGain = 0.5;
                break;
            }
            case "volcano tunnels 5": {
                computeMode = "volcano tunnels";
                octaves = 3;
                amplitude = 110.0;
                amplitudeGain = 110.0;
                frequency = 0.01;
                frequencyGain = 0.1;
                break;
            }
            case "volcano tunnels 6": {
                computeMode = "volcano tunnels";
                octaves = 3;
                amplitude = 110.0;
                amplitudeGain = 110.0;
                frequency = 0.002;
                frequencyGain = 0.1;
                break;
            }
            case "volcano tunnels 7": {
                computeMode = "volcano tunnels";
                amplitude = 100.0;
                frequency = 0.002;
                break;
            }
            case "tunnels 1": {
                computeMode = "tunnels";
                amplitude = 10.0;
                frequency = 0.022;
                break;
            }
            case "tunnels 2": {
                computeMode = "tunnels";
                octaves = 2;
                amplitude = 2.5;
                amplitudeGain = 2.5;
                frequency = 0.011;
                frequencyGain = 1.1;
                break;
            }
            case "tunnels 3": {
                computeMode = "tunnels";
                octaves = 3;
                amplitude = 1.5;
                amplitudeGain = 1.5;
                frequency = 0.008;
                frequencyGain = 2.0;
                break;
            }
            case "warped 1": {
                computeMode = "warped";
                amplitude = 10.0;
                frequency = 0.022;
                break;
            }
            case "fan": {
                computeMode = "fan";
                amplitude = 2.0;
                frequency = 0.022;
                break;
            }
            case "circuit board 1": {
                computeMode = "circuit board";
                break;
            }
            case "random mesh 1": {
                computeMode = "random mesh";
                break;
            }
            case "edge stretch 1": {
                computeMode = "edge stretch";
                frequency = 1.0E-4;
                break;
            }
            case "cross hash 1a": {
                computeMode = "cross hash 1";
                frequency = 1.0E-5;
                break;
            }
            case "cross hash 1b": {
                computeMode = "cross hash 1";
                frequency = 10000.0;
                break;
            }
            case "cross hash 2": {
                computeMode = "cross hash 2";
                frequency = 1.0E-5;
                break;
            }
            case "clouds 1": {
                computeMode = "clouds";
                frequency = 0.001;
                octaves = 6;
                frequencyGain = 2.0;
                amplitudeGain = 0.5;
                break;
            }
            case "valleys 1": {
                computeMode = "valleys";
                frequency = 0.001;
                octaves = 6;
                frequencyGain = 2.0;
                amplitudeGain = 0.5;
                break;
            }
            case "ridges 1": {
                computeMode = "ridges";
                frequency = 0.001;
                octaves = 6;
                frequencyGain = 2.0;
                amplitudeGain = 0.5;
                break;
            }
            case "land and sea 1": {
                computeMode = "land and sea";
                amplitude = 0.5;
                frequency = 0.001;
                octaves = 6;
                frequencyGain = 2.0;
                amplitudeGain = 0.5;
                break;
            }
            case "water damage": {
                computeMode = "water damage";
                amplitude = 0.5;
                frequency = 0.001;
                octaves = 2;
                amplitudeGain = 0.5;
                frequencyGain = 2.0;
                break;
            }
            case "alien 1": {
                computeMode = "organic 1";
                amplitude = 0.5;
                frequency = 0.01;
                break;
            }
            case "alien 2": {
                computeMode = "organic 1";
                amplitude = 0.5;
                frequency = 0.01;
                octaves = 2;
                amplitudeGain = 0.5;
                frequencyGain = 2.0;
                break;
            }
            case "lichen": {
                computeMode = "organic 1";
                amplitude = 0.5;
                frequency = 0.01;
                octaves = 4;
                amplitudeGain = 0.5;
                frequencyGain = 2.0;
                break;
            }
            case "ruffled alien": {
                computeMode = "ruffled organic";
                amplitude = 0.5;
                frequency = 0.01;
            }
        }
        while (!Display.isCloseRequested()) {
            switch (computeMode.toLowerCase()) {
                case "raw": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "heightmap": {
                    int y;
                    int x;
                    GL11.glBegin((int)1);
                    for (x = 0; x < w; ++x) {
                        double terrainHeight = 0.0;
                        for (y = 0; y < h; ++y) {
                            double a = Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            if (!(a > 0.0)) continue;
                            terrainHeight += 1.0;
                        }
                        GL11.glVertex2d((double)x, (double)((double)h - terrainHeight));
                        GL11.glVertex2d((double)x, (double)h);
                    }
                    GL11.glEnd();
                    break;
                }
                case "heightmap 2": {
                    int y;
                    int x;
                    GL11.glBegin((int)1);
                    for (x = 0; x < w; ++x) {
                        double terrainHeight = 0.0;
                        for (y = 0; y < h; ++y) {
                            double a = (double)y / (double)h + Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            if (!(a > 0.0)) continue;
                            terrainHeight += 1.0;
                        }
                        GL11.glVertex2d((double)x, (double)((double)h - terrainHeight));
                        GL11.glVertex2d((double)x, (double)h);
                    }
                    GL11.glEnd();
                    break;
                }
                case "volcano tunnels": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    int xCenter = w >> 1;
                    int yCenter = h >> 1;
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            double a = 1.0 + Noise.brownian(x, y, amplitude * (double)(yCenter - y) / (double)h * (double)Math.abs(x - xCenter) / (double)w, amplitudeGain * (double)(yCenter - y) / (double)h * (double)Math.abs(x - xCenter) / (double)w, frequency, frequencyGain, octaves, permutations);
                            if (!((a = a * a / 2.0 - 1.0) > 0.0)) continue;
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "tunnels": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)(1.0 - Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations));
                            f = f * f / 2.0f - 1.0f;
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "warped": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)(1.0 - Noise.brownian(x, y, amplitude, amplitudeGain, frequency * (double)x / (double)y, frequencyGain, octaves, permutations));
                            f = f * f / 2.0f - 1.0f;
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "fan": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)(1.0 - Noise.brownian(x, y, amplitude * (double)x / (double)y, amplitudeGain * (double)x / (double)y, frequency, frequencyGain, octaves, permutations));
                            f = f * f / 2.0f - 1.0f;
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "circuit board": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(x ^ y, y ^ x, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "random mesh": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(TrigLookupTable.TRIG_TABLE_1048576.sin(x), TrigLookupTable.TRIG_TABLE_1048576.sin(y), amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "edge stretch": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(x * x, y * y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "cross hash 1": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(x * permutations[x % permutations.length], y * permutations[y % permutations.length], amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "cross hash 2": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(x * permutations[y % permutations.length], y * permutations[x % permutations.length], amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "clouds": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = 0.2f + 0.2f * (float)Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)(0.3f + f), (float)(0.3f + f), (float)1.0f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "valleys": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = 0.2f + 0.2f * (float)Math.abs(Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations));
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "ridges": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = 1.0f - (0.4f + 0.4f * (float)Math.abs(Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations)));
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "land and sea": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = 0.2f + 0.2f * (float)Tools.posMod(Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations), 1.0);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "water damage": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            f = (float)Noise.brownian(x, y, amplitude, amplitudeGain, frequency + (double)f, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "organic 1": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            f = (float)Noise.brownian(x, y, amplitude, amplitudeGain, frequency * (double)f, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                    break;
                }
                case "ruffled organic": {
                    int y;
                    int x;
                    GL11.glBegin((int)0);
                    for (x = 0; x < w; ++x) {
                        for (y = 0; y < h; ++y) {
                            float f = (float)Noise.brownian(x, y, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            f = (float)Noise.brownian((float)x + f * 900.0f, (float)y + f * 200.0f, amplitude, amplitudeGain, frequency, frequencyGain, octaves, permutations);
                            GL11.glColor4f((float)f, (float)f, (float)f, (float)1.0f);
                            GL11.glVertex2d((double)x, (double)y);
                        }
                    }
                    GL11.glEnd();
                }
            }
            Display.update();
        }
    }
}

