/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools;

import com.fantasticsource.tools.TrigLookupTable;
import net.minecraft.util.text.TextFormatting;

public class Smoothing {
    public static final int LINEAR = 0;
    public static final int SINUOUS = 1;

    public static double interpolate(double start, double end, double normalizedProgress, int type) {
        switch (type) {
            case 1: {
                return start + (end - start) * (1.0 - TrigLookupTable.TRIG_TABLE_1048576.cos(Math.PI * normalizedProgress)) / 2.0;
            }
        }
        return start + (end - start) * normalizedProgress;
    }

    public static double balanceAlpha(int layers, double alpha) {
        return 1.0 - Math.pow(1.0 - alpha, 1.0 / (double)layers);
    }

    public static void balanceAlphaTest() {
        for (double d : new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}) {
            for (int i = 1; i < 11; ++i) {
                double la = Smoothing.balanceAlpha(i, d);
                double da = 1.0 - Math.pow(1.0 - la, i);
                System.out.println(TextFormatting.AQUA + "" + i + ", " + d + ", " + la + ", " + da);
            }
        }
    }

    public static void interpolationTest(int type) {
        String result = "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        for (double d = 0.0; d <= 1.0; d += 0.01) {
            if (1.0 - d < 0.002) {
                d = 1.0;
            }
            System.out.println(result.substring((int)((double)result.length() - (double)result.length() * Smoothing.interpolate(0.0, 1.0, d, type))));
        }
    }
}

