/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools;

public class Random {
    public static final double ONE_THIRD = 0.3333333333333333;
    public static final double EPSILON = 1.0E-7;
    public long seed;
    public long rng_a;
    public long rng_b;
    public long rng_c;
    public long nextIteration;

    public Random() {
        this.randomize();
    }

    public Random(long seed) {
        this.setSeed(seed);
    }

    public Random(double seed) {
        this.setSeed(seed);
    }

    public Random(long seed, long rng_a, long rng_b, long rng_c, long nextIteration) {
        this.seed = seed;
        this.rng_a = rng_a;
        this.rng_b = rng_b;
        this.rng_c = rng_c;
        this.nextIteration = nextIteration;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(double seed) {
        this.setSeed(Double.doubleToRawLongBits(seed));
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.rng_a = seed;
        this.rng_b = seed;
        this.rng_c = seed;
        this.nextIteration = 1L;
        for (int i = 0; i < 12; ++i) {
            this.nextLong();
        }
    }

    public void randomize() {
        this.setSeed(System.nanoTime());
    }

    public long nextLong() {
        long tmp = this.rng_a + this.rng_b + this.nextIteration++;
        this.rng_a = this.rng_b ^ this.rng_b >> 12;
        this.rng_b = this.rng_c + (this.rng_c << 3);
        this.rng_c = (this.rng_c << 25 | this.rng_c >> 39) + tmp;
        return tmp & Long.MAX_VALUE;
    }

    public long nextLong(long limit) {
        return (long)this.nextDouble(limit);
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    public int nextInt(int limit) {
        return (int)this.nextDouble(limit);
    }

    public double nextDouble() {
        return (double)this.nextLong() / 9.223372036854776E18;
    }

    public double nextDouble(double limit) {
        return this.nextDouble() * limit;
    }

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public float nextFloat(float limit) {
        return (float)(this.nextDouble() * (double)limit);
    }

    public double nextGaussian() {
        double v2;
        double v1;
        double s;
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        return v1 * StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
    }

    public double getNextUniformRandZInFrustum(double nearW, double nearH, double farW, double farH, double depth) {
        double part3;
        double a = (farW - nearW) * (farH - nearH) / (depth * depth);
        double b = (nearH * (farW - nearW) + nearW * (farH - nearH)) / depth;
        if (Math.abs(a) < 1.0E-7) {
            if (Math.abs(b) < 1.0E-7) {
                return this.nextDouble(depth);
            }
            double c = nearW * nearH;
            double area = depth * (c + depth * 0.5 * b);
            double r = this.nextDouble(area);
            return (-c + Math.sqrt(c * c + 2.0 * b * r)) / b;
        }
        double c = nearW * nearH;
        double area = depth * (c + depth * (0.5 * b + depth * 0.3333333333333333 * a));
        double r = this.nextDouble(area);
        double det = b * b - 4.0 * a * c;
        double part1 = b * (b * b - 6.0 * a * c) - 12.0 * a * a * r;
        double part2 = Math.sqrt(part1 * part1 - det * det * det);
        if (part1 < 0.0) {
            part2 = -part2;
        }
        part3 = (part3 = part1 + part2) < 0.0 ? -Math.pow(-part3, 0.3333333333333333) : Math.pow(part3, 0.3333333333333333);
        return -(b + det / part3 + part3) / (2.0 * a);
    }
}

