/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.potions;

import com.fantasticsource.tools.Tools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class FantasticPotionEffect
extends PotionEffect {
    public static final int MAX_DURATION_THRESHOLD = Short.MAX_VALUE;
    public int interval = 0;

    public FantasticPotionEffect(Potion potionIn) {
        super(potionIn);
    }

    public FantasticPotionEffect(Potion potionIn, int durationIn) {
        super(potionIn, durationIn);
    }

    public FantasticPotionEffect(Potion potionIn, int durationIn, int amplifierIn) {
        super(potionIn, durationIn, amplifierIn);
    }

    public FantasticPotionEffect(Potion potionIn, int durationIn, int amplifierIn, boolean ambientIn, boolean showParticlesIn) {
        super(potionIn, durationIn, amplifierIn, ambientIn, showParticlesIn);
    }

    public FantasticPotionEffect(PotionEffect other) {
        super(other);
    }

    public FantasticPotionEffect setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public void func_76452_a(PotionEffect other) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && this.func_100011_g() && other.func_76458_c() > this.func_76458_c()) {
            this.func_100012_b(false);
            super.func_76452_a(other);
            if (this.func_76459_b() >= Short.MAX_VALUE) {
                this.func_100012_b(true);
            }
        } else {
            super.func_76452_a(other);
        }
    }

    public boolean func_76455_a(EntityLivingBase entityIn) {
        if (this.func_76459_b() >= Short.MAX_VALUE) {
            if (this.func_188419_a().func_76397_a(this.func_76459_b(), this.func_76458_c())) {
                this.func_76457_b(entityIn);
            }
            return true;
        }
        return super.func_76455_a(entityIn);
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.interval == ((FantasticPotionEffect)((Object)obj)).interval;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showDurationWhenNoInterval) {
        String result = I18n.func_74838_a((String)this.func_76453_d()) + " " + (this.func_76458_c() <= 9 ? I18n.func_74838_a((String)("potion.potency." + this.func_76458_c())) : Integer.valueOf(this.func_76458_c() + 1));
        if (showDurationWhenNoInterval || this.interval > 0) {
            int duration = this.func_76459_b();
            if (this.func_76459_b() > 0 && duration < Short.MAX_VALUE && (this.interval <= 0 || duration < this.interval)) {
                double seconds = (double)duration / 20.0;
                int minutes = (int)(seconds / 60.0);
                int hours = minutes / 60;
                result = result + " (" + hours + ":" + (minutes %= 60) + ":" + Tools.formatNicely(seconds %= 60.0);
                if (this.interval > 0) {
                    seconds = (double)this.interval / 20.0;
                    minutes = (int)(seconds / 60.0);
                    hours = minutes / 60;
                    result = result + " every " + hours + ":" + (minutes %= 60) + ":" + Tools.formatNicely(seconds %= 60.0);
                }
                result = result + ")";
            }
        }
        return result;
    }
}

