/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.particles;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class PathedParticleSharedRenderData {
    public static final ResourceLocation BLOCK_TEXTURE_ATLAS = TextureMap.field_110575_b;
    public final boolean useBlockLight;
    public final GlStateManager.SourceFactor sourceFactor;
    public final GlStateManager.DestFactor destFactor;
    public final String textureString;
    public final ResourceLocation texture;
    public final int hash;
    public final TextureAtlasSprite sprite;

    public PathedParticleSharedRenderData(boolean useBlockLight, GlStateManager.SourceFactor sourceFactor, GlStateManager.DestFactor destFactor, String texture) {
        this.useBlockLight = useBlockLight;
        this.sourceFactor = sourceFactor;
        this.destFactor = destFactor;
        this.textureString = texture;
        try {
            this.sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(texture);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Tried to create PathedParticleSharedRenderData too early!  Cannot be created before FMLInitializationEvent!");
        }
        this.texture = this.sprite != null ? BLOCK_TEXTURE_ATLAS : new ResourceLocation(texture);
        this.hash = (useBlockLight ? 1 : 0) << 31 | sourceFactor.ordinal() << 27 | destFactor.ordinal() << 23 | texture.hashCode() & 0x7FFFFF;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PathedParticleSharedRenderData)) {
            return false;
        }
        return ((PathedParticleSharedRenderData)obj).hash == this.hash && ((PathedParticleSharedRenderData)obj).texture.equals((Object)this.texture);
    }
}

