/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.particles;

import com.fantasticsource.mctools.particles.PathedParticle;
import com.fantasticsource.mctools.particles.PathedParticleSharedRenderData;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.component.path.CPath;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PathedParticleManager {
    protected static final Profiler PROFILER = Minecraft.func_71410_x().field_71424_I;
    protected static final TextureManager RENDERER = Minecraft.func_71410_x().field_71446_o;
    protected static final Method ENTITY_RENDERER_SETUP_FOG_METHOD = ReflectionTool.getMethod(EntityRenderer.class, "func_78468_a", "setupFog");
    protected static LinkedHashMap<PathedParticleSharedRenderData, ArrayList<PathedParticle>> particles = new LinkedHashMap();
    protected static boolean busy = false;
    protected static ArrayList<PathedParticle> queued = new ArrayList();

    public static void add(PathedParticle particle) {
        if (busy) {
            queued.add(particle);
        } else {
            particles.computeIfAbsent(particle.sharedRenderData, o -> new ArrayList()).add(particle);
        }
    }

    public static void remove(PathedParticle particle) {
        queued.remove(particle);
        ArrayList<PathedParticle> list = particles.get(particle.sharedRenderData);
        if (list != null && list.remove(particle) && list.size() == 0) {
            particles.remove(particle.sharedRenderData);
        }
    }

    public static void clear() {
        queued.clear();
        particles.clear();
    }

    public static void update() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            particles.clear();
            return;
        }
        busy = true;
        particles.entrySet().removeIf(entry -> {
            ArrayList list = (ArrayList)entry.getValue();
            list.removeIf(particle -> {
                particle.update();
                return particle.dead;
            });
            return list.size() == 0;
        });
        busy = false;
        for (PathedParticle particle : queued) {
            PathedParticleManager.add(particle);
        }
        queued.clear();
    }

    public static void render(float partialTick) {
        if (particles.size() == 0) {
            return;
        }
        Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Particle.field_70556_an = renderEntity.field_70142_S + (renderEntity.field_70165_t - renderEntity.field_70142_S) * (double)partialTick;
        Particle.field_70554_ao = renderEntity.field_70137_T + (renderEntity.field_70163_u - renderEntity.field_70137_T) * (double)partialTick;
        Particle.field_70555_ap = renderEntity.field_70136_U + (renderEntity.field_70161_v - renderEntity.field_70136_U) * (double)partialTick;
        Particle.field_190016_K = renderEntity.func_70676_i(partialTick);
        CPath.partialTickCached = partialTick;
        float yawRadians = renderEntity.field_70126_B;
        float pitchRadians = renderEntity.field_70127_C;
        yawRadians += (renderEntity.field_70177_z - yawRadians) * partialTick;
        pitchRadians += (renderEntity.field_70125_A - pitchRadians) * partialTick;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2) {
            if ((yawRadians += 180.0f) > 180.0f) {
                yawRadians -= 360.0f;
            }
            pitchRadians = -pitchRadians;
        }
        float xScaleXFactor = MathHelper.func_76134_b((float)(yawRadians *= (float)Math.PI / 180));
        float xScaleZFactor = MathHelper.func_76126_a((float)yawRadians);
        float yScaleYFactor = MathHelper.func_76134_b((float)(pitchRadians *= (float)Math.PI / 180));
        float yScaleXFactor = xScaleXFactor * MathHelper.func_76126_a((float)pitchRadians);
        float yScaleZFactor = -xScaleZFactor * MathHelper.func_76126_a((float)pitchRadians);
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        for (Map.Entry<PathedParticleSharedRenderData, ArrayList<PathedParticle>> entry : particles.entrySet()) {
            PathedParticleSharedRenderData data = entry.getKey();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)data.sourceFactor, (GlStateManager.DestFactor)data.destFactor);
            RENDERER.func_110577_a(data.texture);
            if (data.useBlockLight) {
                Minecraft.func_71410_x().field_71460_t.func_180436_i();
            } else {
                Minecraft.func_71410_x().field_71460_t.func_175072_h();
            }
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (PathedParticle particle : entry.getValue()) {
                particle.renderParticle(bufferbuilder, partialTick, xScaleXFactor, yScaleYFactor, xScaleZFactor, yScaleZFactor, yScaleXFactor);
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        GlStateManager.func_179084_k();
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!Minecraft.func_71410_x().func_147113_T()) {
            PROFILER.func_76320_a("FLib: Pathed Particles Update");
            PathedParticleManager.update();
            PROFILER.func_76319_b();
        }
    }

    @SubscribeEvent
    public static void renderLast(RenderWorldLastEvent event) {
        PROFILER.func_76320_a("FLib: Pathed Particles Render");
        ReflectionTool.invoke(ENTITY_RENDERER_SETUP_FOG_METHOD, Minecraft.func_71410_x().field_71460_t, 0, Float.valueOf(event.getPartialTicks()));
        PathedParticleManager.render(event.getPartialTicks());
        GlStateManager.func_179106_n();
        PROFILER.func_76319_b();
    }

    @SubscribeEvent
    public static void playerJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            PathedParticleManager.clear();
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(PathedParticleManager.class);
    }
}

