/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.particles;

import com.fantasticsource.mctools.ImprovedRayTracing;
import com.fantasticsource.mctools.particles.PathedParticleFactory;
import com.fantasticsource.mctools.particles.PathedParticleManager;
import com.fantasticsource.mctools.particles.PathedParticleSharedRenderData;
import com.fantasticsource.tools.SpriteMetaData;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.component.path.CPath;
import com.fantasticsource.tools.datastructures.Color;
import com.fantasticsource.tools.datastructures.VectorN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PathedParticle {
    public final PathedParticleSharedRenderData sharedRenderData;
    public final int maxAge;
    public int age = 0;
    public double cullDistanceSquared = 900.0;
    public Vec3d deathPos = null;
    public Object[] extraDeathArgs = null;
    public SpriteMetaData spriteMetaData = null;
    public CPath.CPathData positionData = new CPath.CPathData(0L, new CPath[0]);
    public CPath.CPathData rgbData = null;
    public CPath.CPathData hsvData = null;
    public CPath.CPathData alphaData = null;
    public CPath.CPathData scale2DData = null;
    public CPath.CPathData scale3DData = null;
    public CPath.CPathData rotationData = null;
    public CPath.CPathData animationData = null;
    protected boolean firstChecksDone = false;
    protected boolean dead = false;
    protected ArrayList<Predicate<PathedParticle>> deathConditions = new ArrayList();
    protected ArrayList<PathedParticleFactory> onDeathParticles = null;

    public PathedParticle(int maxAge, PathedParticleSharedRenderData sharedRenderData) {
        this.maxAge = maxAge;
        this.sharedRenderData = sharedRenderData;
        PathedParticleManager.add(this);
    }

    public PathedParticle die() {
        this.dead = true;
        if (this.onDeathParticles != null) {
            for (PathedParticleFactory particleFactory : this.onDeathParticles) {
                particleFactory.create(this, this.extraDeathArgs);
            }
        }
        return this;
    }

    public boolean isDead() {
        return this.dead;
    }

    public PathedParticle delete() {
        this.dead = true;
        return this;
    }

    public PathedParticle positionPath(CPath path) {
        this.positionData.paths.add(path);
        return this;
    }

    public PathedParticle rgbPath(CPath path) {
        if (this.rgbData == null) {
            this.rgbData = new CPath.CPathData(0L, new CPath[0]);
        }
        this.rgbData.paths.add(path);
        return this;
    }

    public PathedParticle hsvPath(CPath path) {
        if (this.hsvData == null) {
            this.hsvData = new CPath.CPathData(0L, new CPath[0]);
        }
        this.hsvData.paths.add(path);
        return this;
    }

    public PathedParticle alphaPath(CPath path) {
        if (this.alphaData == null) {
            this.alphaData = new CPath.CPathData(0L, new CPath[0]);
        }
        this.alphaData.paths.add(path);
        return this;
    }

    public PathedParticle scale2DPath(CPath path) {
        if (path.getRelativePosition((long)0L).values.length != 2) {
            throw new IllegalArgumentException("The 2D scale path must be 2D!");
        }
        if (this.scale2DData == null) {
            this.scale2DData = new CPath.CPathData(0L, new CPath[0]);
        }
        this.scale2DData.paths.add(path);
        return this;
    }

    public PathedParticle scale3DPath(CPath path) {
        if (path.getRelativePosition((long)0L).values.length != 3) {
            throw new IllegalArgumentException("The 3D scale path must be 3D!");
        }
        if (this.scale3DData == null) {
            this.scale3DData = new CPath.CPathData(0L, new CPath[0]);
        }
        this.scale3DData.paths.add(path);
        return this;
    }

    public PathedParticle rotationPath(CPath path) {
        int count = path.getRelativePosition((long)0L).values.length;
        if (count != 1 && count != 3) {
            throw new IllegalArgumentException("Rotation path must be 1D (rotation facing player) or 3D (manual rotation; yaw, pitch, roll)");
        }
        if (this.rotationData == null) {
            this.rotationData = new CPath.CPathData(0L, new CPath[0]);
        }
        this.rotationData.paths.add(path);
        return this;
    }

    public PathedParticle animationPath(CPath path) {
        if (this.animationData == null) {
            this.animationData = new CPath.CPathData(0L, new CPath[0]);
        }
        this.animationData.paths.add(path);
        return this;
    }

    public PathedParticle dieOnSolids() {
        this.deathConditions.add(particle -> {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return true;
            }
            double[] fromVals = this.currentPos((float)0.0f).values;
            double[] toVals = this.nextPosition((float)0.0f).values;
            Vec3d from = new Vec3d(fromVals[0], fromVals[1], fromVals[2]);
            Vec3d to = new Vec3d(toVals[0], toVals[1], toVals[2]);
            RayTraceResult result = ImprovedRayTracing.rayTraceBlocks((World)world, from, to, true);
            if (result.field_72313_a == RayTraceResult.Type.MISS) {
                return false;
            }
            this.deathPos = result.field_72307_f;
            return true;
        });
        return this;
    }

    public PathedParticle dieOnSolidsAndLiquids() {
        this.deathConditions.add(particle -> {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return true;
            }
            double[] fromVals = this.currentPos((float)0.0f).values;
            double[] toVals = this.nextPosition((float)0.0f).values;
            Vec3d from = new Vec3d(fromVals[0], fromVals[1], fromVals[2]);
            Vec3d to = new Vec3d(toVals[0], toVals[1], toVals[2]);
            RayTraceResult result = ImprovedRayTracing.rayTraceBlocks((World)world, from, to, true, true);
            if (result.field_72313_a == RayTraceResult.Type.MISS) {
                return false;
            }
            this.deathPos = result.field_72307_f;
            return true;
        });
        return this;
    }

    public PathedParticle addDeathConditions(Predicate<PathedParticle> ... conditions) {
        this.deathConditions.addAll(Arrays.asList(conditions));
        return this;
    }

    public PathedParticle addOnDeathParticles(PathedParticleFactory ... particleFactories) {
        if (this.onDeathParticles == null) {
            this.onDeathParticles = new ArrayList();
        }
        this.onDeathParticles.addAll(Arrays.asList(particleFactories));
        return this;
    }

    public void update() {
        VectorN pos;
        block8: {
            block7: {
                pos = this.currentPos(0.0f);
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player == null) break block7;
                double[] dArray = new double[]{player.field_70165_t, player.field_70163_u + (double)player.eyeHeight, player.field_70161_v};
                if (!(pos.squareDistanceTo(dArray) > this.cullDistanceSquared)) break block8;
            }
            this.delete();
            return;
        }
        if (this.maxAge != Integer.MAX_VALUE || this.age < this.maxAge - 1) {
            ++this.age;
        }
        for (Predicate<PathedParticle> predicate : this.deathConditions) {
            if (!predicate.test(this)) continue;
            if (this.deathPos == null) {
                this.deathPos = new Vec3d(pos.values[0], pos.values[1], pos.values[2]);
            }
            this.die();
            return;
        }
        if (this.age >= this.maxAge) {
            this.deathPos = new Vec3d(pos.values[0], pos.values[1], pos.values[2]);
            this.die();
        }
    }

    public long currentRenderMillis(float partialTick) {
        return (long)((partialTick + (float)this.age) * 50.0f);
    }

    public VectorN prevPosition(float partialTick) {
        return this.positionAtAge(this.age - 1, partialTick);
    }

    public VectorN nextPosition(float partialTick) {
        return this.positionAtAge(this.age + 1, partialTick);
    }

    public VectorN positionAtAge(int age, float partialTick) {
        int a = this.age;
        this.age = age;
        VectorN result = this.currentPos(partialTick);
        this.age = a;
        return result;
    }

    public VectorN currentPos(float partialTick) {
        return this.positionData.getRelativePosition(this.currentRenderMillis(partialTick));
    }

    public void renderParticle(BufferBuilder buffer, float partialTick, float xScaleXFactor, float yScaleYFactor, float xScaleZFactor, float yScaleZFactor, float yScaleXFactor) {
        VectorN vec;
        long renderMillisWithRate;
        BlockPos blockPos;
        VectorN[] posOffsets;
        double yOrigin;
        double xOrigin;
        double v2;
        double u2;
        double v1;
        double u1;
        WorldClient world;
        block28: {
            block29: {
                if (this.firstChecksDone) break block28;
                VectorN pos = this.currentPos(0.0f);
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player == null) break block29;
                double[] dArray = new double[]{player.field_70165_t, player.field_70163_u + (double)player.eyeHeight, player.field_70161_v};
                if (!(pos.squareDistanceTo(dArray) > this.cullDistanceSquared)) break block28;
            }
            this.delete();
            return;
        }
        if ((world = Minecraft.func_71410_x().field_71441_e) == null) {
            this.delete();
        }
        if (this.dead) {
            return;
        }
        long renderMillis = this.currentRenderMillis(partialTick);
        VectorN pos = this.currentPos(partialTick);
        if (pos == null) {
            this.delete();
            return;
        }
        double x = pos.values[0] - Particle.field_70556_an;
        double y = pos.values[1] - Particle.field_70554_ao;
        double z = pos.values[2] - Particle.field_70555_ap;
        if (this.spriteMetaData != null) {
            SpriteMetaData.FrameMetaData frame = this.animationData != null ? this.spriteMetaData.frames.get(Tools.posMod((int)((double)this.spriteMetaData.frames.size() * this.animationData.getRelativePosition((long)renderMillis).values[0]), this.spriteMetaData.frames.size())) : this.spriteMetaData.frames.get(this.spriteMetaData.frames.size() * this.age / this.maxAge);
            u1 = frame.u1;
            v1 = frame.v1;
            u2 = frame.u2;
            v2 = frame.v2;
            xOrigin = frame.relativeOriginX;
            yOrigin = frame.relativeOriginY;
        } else {
            TextureAtlasSprite sprite = this.sharedRenderData.sprite;
            if (sprite != null) {
                u1 = sprite.func_94209_e();
                v1 = sprite.func_94206_g();
                u2 = sprite.func_94212_f();
                v2 = sprite.func_94210_h();
            } else {
                u1 = 0.0;
                v1 = 0.0;
                u2 = 1.0;
                v2 = 1.0;
            }
            xOrigin = 0.5;
            yOrigin = 0.5;
        }
        double xScale3D = 0.1;
        double yScale3D = 0.1;
        double zScale3D = 0.1;
        if (this.scale3DData != null) {
            VectorN scalar = this.scale3DData.getRelativePosition(renderMillis);
            xScale3D *= scalar.values[0];
            yScale3D *= scalar.values[1];
            zScale3D *= scalar.values[2];
        }
        VectorN rotation = null;
        if (this.rotationData != null) {
            rotation = this.rotationData.getRelativePosition(renderMillis);
        }
        if (rotation == null || rotation.values.length == 1) {
            if (this.scale2DData != null) {
                VectorN vectorN = this.scale2DData.getRelativePosition(renderMillis);
                xScaleXFactor = (float)((double)xScaleXFactor * vectorN.values[0]);
                xScaleZFactor = (float)((double)xScaleZFactor * vectorN.values[0]);
                yScaleYFactor = (float)((double)yScaleYFactor * vectorN.values[1]);
                yScaleXFactor = (float)((double)yScaleXFactor * vectorN.values[1]);
                yScaleZFactor = (float)((double)yScaleZFactor * vectorN.values[1]);
            }
            posOffsets = xOrigin == 0.5 && yOrigin == 0.5 ? new VectorN[]{new VectorN(-xScaleXFactor - yScaleZFactor, -yScaleYFactor, -xScaleZFactor - yScaleXFactor).scale(0.5), new VectorN(-xScaleXFactor + yScaleZFactor, yScaleYFactor, -xScaleZFactor + yScaleXFactor).scale(0.5), new VectorN(xScaleXFactor + yScaleZFactor, yScaleYFactor, xScaleZFactor + yScaleXFactor).scale(0.5), new VectorN(xScaleXFactor - yScaleZFactor, -yScaleYFactor, xScaleZFactor - yScaleXFactor).scale(0.5)} : new VectorN[]{new VectorN((double)xScaleXFactor * (xOrigin - 1.0) + (double)yScaleZFactor * (yOrigin - 1.0), (double)yScaleYFactor * (yOrigin - 1.0), (double)xScaleZFactor * (xOrigin - 1.0) + (double)yScaleXFactor * (yOrigin - 1.0)), new VectorN((double)xScaleXFactor * (xOrigin - 1.0) + (double)yScaleZFactor * yOrigin, (double)yScaleYFactor * yOrigin, (double)xScaleZFactor * (xOrigin - 1.0) + (double)yScaleXFactor * yOrigin), new VectorN((double)xScaleXFactor * xOrigin + (double)yScaleZFactor * yOrigin, (double)yScaleYFactor * yOrigin, (double)xScaleZFactor * xOrigin + (double)yScaleXFactor * yOrigin), new VectorN((double)xScaleXFactor * xOrigin + (double)yScaleZFactor * (yOrigin - 1.0), (double)yScaleYFactor * (yOrigin - 1.0), (double)xScaleZFactor * xOrigin + (double)yScaleXFactor * (yOrigin - 1.0))};
            if (rotation != null) {
                float f = (float)(rotation.values[0] * 0.5);
                float sinTheta = MathHelper.func_76126_a((float)f);
                float cosTheta = MathHelper.func_76134_b((float)f);
                VectorN rotationScalars = new VectorN((double)sinTheta * Particle.field_190016_K.field_72450_a, (double)sinTheta * Particle.field_190016_K.field_72448_b, (double)sinTheta * Particle.field_190016_K.field_72449_c);
                double rotScalMagSqr = rotationScalars.getMagnitudeSquared();
                for (int i = 0; i < 4; ++i) {
                    posOffsets[i] = rotationScalars.copy().scale(2.0 * posOffsets[i].dotProduct(rotationScalars)).add(posOffsets[i].copy().scale((double)(cosTheta * cosTheta) - rotScalMagSqr)).add(rotationScalars.copy().crossProduct(posOffsets[i]).scale(2.0f * cosTheta));
                }
            }
        } else {
            posOffsets = new VectorN[]{new VectorN(xOrigin - 1.0, yOrigin - 1.0, 0.0), new VectorN(xOrigin - 1.0, yOrigin, 0.0), new VectorN(xOrigin, yOrigin, 0.0), new VectorN(xOrigin, yOrigin - 1.0, 0.0)};
            if (this.scale2DData != null) {
                VectorN vectorN = this.scale2DData.getRelativePosition(renderMillis);
                VectorN[] sinTheta = posOffsets;
                int cosTheta = sinTheta.length;
                for (int rotationScalars = 0; rotationScalars < cosTheta; ++rotationScalars) {
                    VectorN v = sinTheta[rotationScalars];
                    v.multiply(vectorN.values[0], vectorN.values[1], 0.0);
                }
            }
            for (VectorN v : posOffsets) {
                v.rotate(VectorN.Z_AXIS, rotation.values[2]);
                v.rotate(VectorN.X_AXIS, rotation.values[1]);
                v.rotate(VectorN.Y_AXIS, rotation.values[0]);
            }
        }
        int lightmapIndex = world.func_175667_e(blockPos = new BlockPos(pos.values[0], pos.values[1], pos.values[2])) ? world.func_175626_b(blockPos, 0) : 0;
        int skyLight = lightmapIndex >> 16 & 0xFFFF;
        int blockLight = lightmapIndex & 0xFFFF;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        if (this.rgbData != null) {
            renderMillisWithRate = (long)((double)renderMillis * this.rgbData.rate);
            for (CPath cPath : this.rgbData.paths) {
                vec = cPath.getRelativePosition(renderMillisWithRate);
                r *= (float)vec.values[0];
                g *= (float)vec.values[1];
                b *= (float)vec.values[2];
            }
        }
        if (this.hsvData != null) {
            renderMillisWithRate = (long)((double)renderMillis * this.hsvData.rate);
            Color c = new Color(0);
            for (CPath path : this.hsvData.paths) {
                vec = path.getRelativePosition(renderMillisWithRate);
                c.setColorHSV((float)vec.values[0], (float)vec.values[1], (float)vec.values[2]);
                r *= c.rf();
                g *= c.gf();
                b *= c.bf();
            }
        }
        if (this.alphaData != null) {
            renderMillisWithRate = (long)((double)renderMillis * this.alphaData.rate);
            for (CPath cPath : this.alphaData.paths) {
                a = (float)((double)a * cPath.getRelativePosition((long)renderMillisWithRate).values[0]);
            }
        }
        buffer.func_181662_b(x + posOffsets[0].values[0] * xScale3D, y + posOffsets[0].values[1] * yScale3D, z + posOffsets[0].values[2] * zScale3D).func_187315_a(u2, v2).func_181666_a(r, g, b, a).func_187314_a(skyLight, blockLight).func_181675_d();
        buffer.func_181662_b(x + posOffsets[1].values[0] * xScale3D, y + posOffsets[1].values[1] * yScale3D, z + posOffsets[1].values[2] * zScale3D).func_187315_a(u2, v1).func_181666_a(r, g, b, a).func_187314_a(skyLight, blockLight).func_181675_d();
        buffer.func_181662_b(x + posOffsets[2].values[0] * xScale3D, y + posOffsets[2].values[1] * yScale3D, z + posOffsets[2].values[2] * zScale3D).func_187315_a(u1, v1).func_181666_a(r, g, b, a).func_187314_a(skyLight, blockLight).func_181675_d();
        buffer.func_181662_b(x + posOffsets[3].values[0] * xScale3D, y + posOffsets[3].values[1] * yScale3D, z + posOffsets[3].values[2] * zScale3D).func_187315_a(u1, v2).func_181666_a(r, g, b, a).func_187314_a(skyLight, blockLight).func_181675_d();
    }
}

