/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.items;

import com.fantasticsource.tools.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

@Deprecated
public class RegistryRegexItemFilter {
    public String domainRegex;
    public String itemRegex;
    public String metaRegex;
    public LinkedHashMap<String, String> tagsRequired = new LinkedHashMap();
    public LinkedHashMap<String, String> tagsDisallowed = new LinkedHashMap();
    public int lastCacheOreDictSize = 0;
    public ArrayList<Integer> matchingOredictIDs = new ArrayList();

    public RegistryRegexItemFilter() {
    }

    public RegistryRegexItemFilter(String domainRegex, String itemRegex, String metaRegex, LinkedHashMap<String, String> tagsRequired, LinkedHashMap<String, String> tagsDisallowed) {
        this.domainRegex = domainRegex;
        this.itemRegex = itemRegex;
        this.metaRegex = metaRegex;
        this.tagsRequired = tagsRequired;
        this.tagsDisallowed = tagsDisallowed;
    }

    public static RegistryRegexItemFilter getInstance(String itemStackString) {
        RegistryRegexItemFilter result = new RegistryRegexItemFilter();
        String[] registryAndNBT = itemStackString.trim().split(Pattern.quote(">"));
        if (registryAndNBT.length == 0) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.notEnoughItemFilterArgs", (Object[])new Object[]{itemStackString}));
            return null;
        }
        if (registryAndNBT.length > 2) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.tooManyItemFilterArgs", (Object[])new Object[]{itemStackString}));
            return null;
        }
        String[] regexTokens = registryAndNBT[0].trim().split(":");
        if (regexTokens.length == 0 || regexTokens.length > 3) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.badItemName", (Object[])new Object[]{registryAndNBT[0].trim()}));
            return null;
        }
        if (regexTokens.length == 1) {
            result.domainRegex = ".*";
            result.itemRegex = regexTokens[0].trim();
            result.metaRegex = ".*";
        } else if (regexTokens.length == 2) {
            if (Tools.regexMatches(".*[a-zA-Z].*", regexTokens[1])) {
                result.domainRegex = regexTokens[0];
                result.itemRegex = regexTokens[1];
                result.metaRegex = ".*";
            } else if (Tools.regexMatches(".*[0-9].*", regexTokens[1])) {
                result.domainRegex = ".*";
                result.itemRegex = regexTokens[0];
                result.metaRegex = regexTokens[1];
            } else {
                result.domainRegex = regexTokens[0];
                result.itemRegex = regexTokens[1];
                result.metaRegex = ".*";
            }
        } else {
            result.domainRegex = regexTokens[0].trim();
            result.itemRegex = regexTokens[1].trim();
            result.metaRegex = regexTokens[2].trim();
        }
        if (result.domainRegex.equals("")) {
            result.domainRegex = ".*";
        }
        if (result.itemRegex.equals("")) {
            result.itemRegex = ".*";
        }
        if (result.metaRegex.equals("")) {
            result.metaRegex = ".*";
        }
        if (registryAndNBT.length > 1) {
            String[] tags;
            String nbt = registryAndNBT[1].trim();
            for (Map.Entry entry : ForgeRegistries.ENCHANTMENTS.getEntries()) {
                nbt = nbt.replaceAll(((ResourceLocation)entry.getKey()).toString(), "id:" + Enchantment.func_185258_b((Enchantment)((Enchantment)entry.getValue())) + "s");
            }
            for (String tag : tags = nbt.split(Pattern.quote("&"))) {
                LinkedHashMap<String, String> map;
                if ((tag = tag.trim()).equals("")) continue;
                String[] keyValue = tag.split(Pattern.quote("="));
                if (keyValue.length > 2) {
                    System.err.println(I18n.func_74837_a((String)"fantasticlib.error.tooManyNBTValues", (Object[])new Object[]{itemStackString}));
                    return null;
                }
                String key = keyValue[0].trim();
                if (key.equals("")) continue;
                if (key.charAt(0) == '!') {
                    key = key.substring(1);
                    map = result.tagsDisallowed;
                } else {
                    map = result.tagsRequired;
                }
                map.put(key, keyValue.length == 2 ? keyValue[1].trim() : null);
            }
        }
        return result;
    }

    public boolean matches(ItemStack stack) {
        Set<Map.Entry<String, String>> entrySet;
        NBTTagCompound compound;
        if (!Tools.regexMatches(this.metaRegex, "" + stack.func_77960_j())) {
            return false;
        }
        ResourceLocation resourceLocation = stack.func_77973_b().getRegistryName();
        if (!Tools.regexMatches(this.domainRegex, resourceLocation.func_110624_b()) || !Tools.regexMatches(this.itemRegex, resourceLocation.func_110623_a())) {
            if (!stack.func_190926_b() && Tools.regexMatches(this.domainRegex, "ore")) {
                String[] oreDictNames = OreDictionary.getOreNames();
                for (int i = this.lastCacheOreDictSize; i < oreDictNames.length; ++i) {
                    if (!Tools.regexMatches(this.itemRegex, oreDictNames[i])) continue;
                    this.matchingOredictIDs.add(i);
                }
                boolean found = false;
                for (int oreDictID : OreDictionary.getOreIDs((ItemStack)stack)) {
                    if (!this.matchingOredictIDs.contains(oreDictID)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((compound = stack.func_77978_p()) != null) {
            for (Map.Entry<String, String> entry : this.tagsDisallowed.entrySet()) {
                if (!this.checkNBT((NBTBase)compound, entry.getKey().split(":", -1), entry.getValue())) continue;
                return false;
            }
        }
        if ((entrySet = this.tagsRequired.entrySet()).size() > 0) {
            if (compound == null) {
                return false;
            }
            Object object = entrySet.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                if (this.checkNBT((NBTBase)compound, ((String)entry.getKey()).split(":", -1), (String)entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkNBT(NBTBase base, String[] keymap, String value) {
        if (keymap == null || keymap.length == 0) {
            return this.checkValue(base, value);
        }
        String key = keymap[0].trim();
        if (key.equals("")) {
            if (base instanceof NBTTagList) {
                for (NBTBase base1 : (NBTTagList)base) {
                    if (!this.checkNBT(base1, Arrays.copyOfRange(keymap, 1, keymap.length), value)) continue;
                    return true;
                }
            }
            return false;
        }
        if (base instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)base;
            if (!compound.func_74764_b(key)) {
                return false;
            }
            return this.checkNBT(compound.func_74781_a(key), Arrays.copyOfRange(keymap, 1, keymap.length), value);
        }
        return false;
    }

    private boolean checkValue(NBTBase base, String value) {
        if (value == null || value.trim().equals(base.toString())) {
            return true;
        }
        if ((value = value.replace(";", ",")).equals(base.toString())) {
            return true;
        }
        String[] newValues = value.split(",");
        if (newValues.length < 2 && !value.contains(":")) {
            return false;
        }
        for (String newValue : newValues) {
            String[] tokens = newValue.split(":");
            if (this.checkNBT(base, Arrays.copyOf(tokens, tokens.length - 1), tokens[tokens.length - 1])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RegistryRegexItemFilter)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return obj.equals(this);
        }
        RegistryRegexItemFilter other = (RegistryRegexItemFilter)obj;
        if (!(this.domainRegex.equals(other.domainRegex) && this.itemRegex.equals(other.itemRegex) && this.metaRegex.equals(other.metaRegex))) {
            return false;
        }
        if (this.tagsRequired.size() != other.tagsRequired.size()) {
            return false;
        }
        if (this.tagsDisallowed.size() != other.tagsDisallowed.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.tagsRequired.entrySet()) {
            if (entry.getValue().equals(other.tagsRequired.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<String, String> entry : this.tagsDisallowed.entrySet()) {
            if (entry.getValue().equals(other.tagsDisallowed.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public RegistryRegexItemFilter clone() {
        RegistryRegexItemFilter other = new RegistryRegexItemFilter();
        other.domainRegex = this.domainRegex;
        other.itemRegex = this.itemRegex;
        other.metaRegex = this.metaRegex;
        for (Map.Entry<String, String> entry : this.tagsRequired.entrySet()) {
            other.tagsRequired.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.tagsDisallowed.entrySet()) {
            other.tagsDisallowed.put(entry.getKey(), entry.getValue());
        }
        other.lastCacheOreDictSize = this.lastCacheOreDictSize;
        other.matchingOredictIDs.addAll(this.matchingOredictIDs);
        return other;
    }

    public String toString() {
        String result = this.domainRegex + ":" + this.itemRegex + ":" + this.metaRegex;
        int i = 0;
        for (Map.Entry<String, String> entry : this.tagsRequired.entrySet()) {
            result = result + (i++ == 0 ? " > " : " & ");
            result = result + entry.getKey();
            if (entry.getValue() == null) continue;
            result = result + " = " + entry.getValue();
        }
        for (Map.Entry<String, String> entry : this.tagsDisallowed.entrySet()) {
            result = result + (i++ == 0 ? " > " : " & ");
            result = result + "!" + entry.getKey();
            if (entry.getValue() == null) continue;
            result = result + " = " + entry.getValue();
        }
        return result;
    }
}

