/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.text.filter;

import com.fantasticsource.mctools.gui.element.text.filter.TextFilter;
import java.util.LinkedHashMap;

public class FilterRangedFloat
extends TextFilter<Float> {
    private static LinkedHashMap<String, FilterRangedFloat> instances = new LinkedHashMap();
    private final float min;
    private final float max;

    private FilterRangedFloat(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public static FilterRangedFloat get(float min, float max) {
        return instances.computeIfAbsent(min + "," + max, o -> new FilterRangedFloat(min, max));
    }

    @Override
    public String transformInput(String input) {
        return input.trim();
    }

    @Override
    public boolean acceptable(String input) {
        try {
            float f = Float.parseFloat(this.transformInput(input));
            return f >= this.min && f <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Float parse(String input) {
        return !this.acceptable(input) ? null : Float.valueOf(Float.parseFloat(this.transformInput(input)));
    }
}

