/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.text;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.text.GUIText;
import com.fantasticsource.mctools.gui.element.text.GUITextButton;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;

public class GUITextLabel
extends GUITextButton {
    public GUITextLabel(GUIScreen screen, double width) {
        this(screen, width, 1.0);
    }

    public GUITextLabel(GUIScreen screen, double width, double scale) {
        this(screen, width, (Color)Color.AQUA, scale);
    }

    public GUITextLabel(GUIScreen screen, double width, Color color) {
        this(screen, width, color, 1.0);
    }

    public GUITextLabel(GUIScreen screen, double width, Color color, double scale) {
        this(screen, width, color, GUIScreen.getIdleColor(color).setAF(color.af() * 0.4f), scale);
    }

    public GUITextLabel(GUIScreen screen, double width, Color border, Color center) {
        this(screen, width, border, center, 1.0);
    }

    public GUITextLabel(GUIScreen screen, double width, Color border, Color center, double scale) {
        super(screen, "", border, center, scale);
        this.setSubElementAutoplaceMethod((byte)8);
        this.width = width;
        this.setColor(border, center);
    }

    public GUITextLabel setText(String text) {
        ((GUIText)this.children.get(1)).setText(text);
        return this;
    }

    @Override
    public GUITextLabel recalc(int subIndexChanged) {
        this.height = 1.0;
        if (this.parent == null) {
            return this;
        }
        this.recalcAndRepositionSubElements(0);
        this.height = 0.0;
        for (GUIElement element : this.children) {
            if (element == this.background) continue;
            this.height = Tools.max(this.height, element.y + element.height);
        }
        this.recalcAndRepositionSubElements(0);
        double paddingPx = (double)Tools.min(this.absolutePxWidth(), this.absolutePxHeight()) * this.padding;
        double xPad = paddingPx / (double)this.parent.absolutePxWidth();
        double yPad = paddingPx / (double)this.parent.absolutePxHeight();
        this.height += yPad * 2.0;
        xPad /= this.width;
        yPad /= this.height;
        for (GUIElement element : this.children) {
            if (element == this.background) continue;
            element.x += (0.5 - element.x) * 2.0 * xPad;
            element.y += (0.5 - element.y) * 2.0 * yPad;
            element.recalc(0);
        }
        this.postRecalc();
        return this;
    }
}

