/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.event;

import com.fantasticsource.tools.Tools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class BlockTick {
    protected static ArrayList<Predicate<BlockTickData>> actions = new ArrayList();

    public static void addAction(Predicate<BlockTickData> action) {
        actions.add(action);
        if (actions.size() == 1) {
            MinecraftForge.EVENT_BUS.register(BlockTick.class);
        }
    }

    public static void removeAction(Predicate<BlockTickData> action) {
        actions.remove(action);
        if (actions.size() == 0) {
            MinecraftForge.EVENT_BUS.unregister(BlockTick.class);
        }
    }

    @SubscribeEvent
    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        WorldServer world = (WorldServer)event.world;
        if (world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return;
        }
        int i = world.func_82736_K().func_180263_c("randomTickSpeed");
        if (i <= 0) {
            return;
        }
        world.field_72984_F.func_76320_a("FLib BlockTick");
        Iterator iterator = world.getPersistentChunkIterable(world.func_184164_w().func_187300_b());
        while (iterator.hasNext()) {
            Chunk chunk = (Chunk)iterator.next();
            for (ExtendedBlockStorage extendedblockstorage : chunk.func_76587_i()) {
                if (extendedblockstorage == Chunk.field_186036_a || !extendedblockstorage.func_76675_b()) continue;
                for (int i1 = 0; i1 < i; ++i1) {
                    int r = Tools.random(Integer.MAX_VALUE);
                    int x = r & 0xF;
                    int z = r >> 8 & 0xF;
                    int y = r >> 16 & 0xF;
                    BlockTickData blockTickData = new BlockTickData((World)world, x + (chunk.field_76635_g << 4), y + extendedblockstorage.func_76662_d(), z + (chunk.field_76647_h << 4), extendedblockstorage.func_177485_a(x, y, z));
                    for (Predicate<BlockTickData> action : actions) {
                        action.test(blockTickData);
                    }
                }
            }
        }
        world.field_72984_F.func_76319_b();
    }

    public static class BlockTickData {
        public final World world;
        public final int x;
        public final int y;
        public final int z;
        public final IBlockState blockState;

        public BlockTickData(World world, int x, int y, int z, IBlockState blockState) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.blockState = blockState;
        }
    }
}

