/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.component.path;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.component.CInt;
import com.fantasticsource.tools.component.path.CPath;
import com.fantasticsource.tools.datastructures.VectorN;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;

public class CPathEntityLook
extends CPath {
    public Entity entity;

    public CPathEntityLook() {
    }

    public CPathEntityLook(Entity entity) {
        this.entity = entity;
    }

    @Override
    public VectorN getRelativePositionInternal(long time) {
        float yaw;
        if (this.entity == null) {
            return null;
        }
        if (this.entity instanceof EntityLivingBase && !(this.entity instanceof EntityPlayer)) {
            EntityLivingBase livingBase = (EntityLivingBase)this.entity;
            yaw = livingBase.field_70758_at;
            yaw += Tools.angleDifRad(livingBase.field_70759_as, yaw) * partialTickCached;
        } else {
            yaw = this.entity.field_70126_B;
            yaw += Tools.angleDifRad(this.entity.field_70177_z, yaw) * partialTickCached;
        }
        float pitch = this.entity.field_70127_C;
        pitch += (this.entity.field_70125_A - pitch) * partialTickCached;
        return MCTools.getVectorN(Vec3d.func_189986_a((float)pitch, (float)yaw));
    }

    @Override
    public CPathEntityLook write(ByteBuf buf) {
        super.write(buf);
        buf.writeInt(this.entity.func_145782_y());
        return this;
    }

    @Override
    public CPathEntityLook read(ByteBuf buf) {
        super.read(buf);
        this.entity = MCTools.getValidEntityByID(buf.readInt());
        return this;
    }

    @Override
    public CPathEntityLook save(OutputStream stream) {
        super.save(stream);
        new CInt().set(this.entity.func_145782_y()).save(stream);
        return this;
    }

    @Override
    public CPathEntityLook load(InputStream stream) {
        super.load(stream);
        this.entity = MCTools.getValidEntityByID(new CInt().load((InputStream)stream).value);
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("entity", this.entity.func_145782_y());
        return compound;
    }

    @Override
    public void deserializeNBT(NBTBase nbt) {
        super.deserializeNBT(nbt);
        this.entity = MCTools.getValidEntityByID(((NBTTagCompound)nbt).func_74762_e("entity"));
    }
}

