/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.blocks;

import com.fantasticsource.tools.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.oredict.OreDictionary;

public class AdvancedBlockFilter {
    protected String domainCheck;
    protected String blockCheck;
    protected String metaCheck;
    protected boolean domainIsRegex;
    protected boolean blockIsRegex;
    protected boolean metaIsRegex;
    protected int meta;
    protected int lastCacheOreDictSize = 0;
    protected ArrayList<Integer> matchingOredictIDs = new ArrayList();
    protected LinkedHashMap<Block, Boolean> cachedBlockResults = new LinkedHashMap();

    public AdvancedBlockFilter() {
        this(".*", ".*", ".*");
    }

    public AdvancedBlockFilter(@Nullable String domainRegex, @Nullable String blockRegex, @Nullable String metaRegex) {
        this.set(domainRegex, blockRegex, metaRegex);
    }

    public void set(String domainRegex, String blockRegex, String metaRegex) {
        if (this.domainCheck == null) {
            this.domainCheck = ".*";
        } else {
            this.domainCheck = domainRegex.trim();
            if (this.domainCheck.isEmpty()) {
                this.domainCheck = ".*";
            }
        }
        if (this.blockCheck == null) {
            this.blockCheck = ".*";
        } else {
            this.blockCheck = blockRegex.trim();
            if (this.blockCheck.isEmpty()) {
                this.blockCheck = ".*";
            }
        }
        if (this.metaCheck == null) {
            this.metaCheck = ".*";
        } else {
            this.metaCheck = metaRegex.trim();
            if (this.metaCheck.isEmpty()) {
                this.metaCheck = ".*";
            }
        }
        this.resetAllCaches();
    }

    public void resetAllCaches() {
        this.domainIsRegex = this.domainCheck == null || Tools.hasRegexSpecialCharacters(this.domainCheck);
        this.blockIsRegex = this.blockCheck == null || Tools.hasRegexSpecialCharacters(this.blockCheck);
        boolean bl = this.metaIsRegex = this.metaCheck == null || Tools.hasRegexSpecialCharacters(this.metaCheck);
        if (!this.metaIsRegex) {
            this.meta = Integer.parseInt(this.metaCheck);
        }
        this.cachedBlockResults.clear();
    }

    public String getDomainRegex() {
        return this.domainCheck;
    }

    public String getBlockRegex() {
        return this.blockCheck;
    }

    public String getMetaRegex() {
        return this.metaCheck;
    }

    public static AdvancedBlockFilter getInstance(String blockStateString) {
        AdvancedBlockFilter result = new AdvancedBlockFilter();
        String[] regexTokens = blockStateString.trim().split(":");
        if (regexTokens.length == 0 || regexTokens.length > 3) {
            System.err.println(I18n.func_74837_a((String)"fantasticlib.error.badBlockName", (Object[])new Object[]{blockStateString.trim()}));
            return null;
        }
        if (regexTokens.length == 1) {
            result.domainCheck = ".*";
            result.blockCheck = regexTokens[0].trim();
            result.metaCheck = ".*";
        } else if (regexTokens.length == 2) {
            if (Tools.regexMatches(".*[a-zA-Z].*", regexTokens[1])) {
                result.domainCheck = regexTokens[0];
                result.blockCheck = regexTokens[1];
                result.metaCheck = ".*";
            } else if (Tools.regexMatches(".*[0-9].*", regexTokens[1])) {
                result.domainCheck = ".*";
                result.blockCheck = regexTokens[0];
                result.metaCheck = regexTokens[1];
            } else {
                result.domainCheck = regexTokens[0];
                result.blockCheck = regexTokens[1];
                result.metaCheck = ".*";
            }
        } else {
            result.domainCheck = regexTokens[0].trim();
            result.blockCheck = regexTokens[1].trim();
            result.metaCheck = regexTokens[2].trim();
        }
        if (result.domainCheck.equals("")) {
            result.domainCheck = ".*";
        }
        if (result.blockCheck.equals("")) {
            result.blockCheck = ".*";
        }
        if (result.metaCheck.equals("")) {
            result.metaCheck = ".*";
        }
        result.set(result.domainCheck, result.blockCheck, result.metaCheck);
        return result;
    }

    public boolean matches(IBlockState state) {
        if (state == null) {
            return false;
        }
        Block block = state.func_177230_c();
        int stateMeta = block.func_176201_c(state);
        Boolean cachedBlockCheck = this.cachedBlockResults.get(block);
        if (cachedBlockCheck == null) {
            ResourceLocation resourceLocation = block.getRegistryName();
            if (resourceLocation == null) {
                this.cachedBlockResults.put(block, false);
                return false;
            }
            if (!this.checkDomain(resourceLocation.func_110624_b()) || !this.checkBlock(resourceLocation.func_110623_a())) {
                if (block == Blocks.field_150350_a || !this.checkDomain("ore")) {
                    this.cachedBlockResults.put(block, false);
                    return false;
                }
                String[] oreDictNames = OreDictionary.getOreNames();
                for (int i = this.lastCacheOreDictSize; i < oreDictNames.length; ++i) {
                    if (!this.checkBlock(oreDictNames[i])) continue;
                    this.matchingOredictIDs.add(i);
                }
                boolean found = false;
                ItemStack stack = new ItemStack(state.func_177230_c(), 1, stateMeta);
                if (!stack.func_190926_b()) {
                    for (int oreDictID : OreDictionary.getOreIDs((ItemStack)stack)) {
                        if (!this.matchingOredictIDs.contains(oreDictID)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    this.cachedBlockResults.put(block, false);
                    return false;
                }
            }
            this.cachedBlockResults.put(block, true);
        } else if (!cachedBlockCheck.booleanValue()) {
            return false;
        }
        return this.checkMeta(stateMeta);
    }

    protected boolean checkDomain(String domain) {
        if (this.domainIsRegex) {
            return Tools.regexMatches(this.domainCheck, domain);
        }
        return this.domainCheck.equals(domain);
    }

    protected boolean checkBlock(String block) {
        if (this.blockIsRegex) {
            return Tools.regexMatches(this.blockCheck, block);
        }
        return this.blockCheck.equals(block);
    }

    protected boolean checkMeta(int stackMeta) {
        if (this.metaIsRegex) {
            return Tools.regexMatches(this.metaCheck, "" + stackMeta);
        }
        return stackMeta == this.meta;
    }

    protected boolean checkNBT(NBTBase base, String[] keymap, String value) {
        if (keymap == null || keymap.length == 0) {
            return this.checkValue(base, value);
        }
        String key = keymap[0].trim();
        if (key.equals("")) {
            if (base instanceof NBTTagList) {
                for (NBTBase base1 : (NBTTagList)base) {
                    if (!this.checkNBT(base1, Arrays.copyOfRange(keymap, 1, keymap.length), value)) continue;
                    return true;
                }
            }
            return false;
        }
        if (base instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)base;
            if (!compound.func_74764_b(key)) {
                return false;
            }
            return this.checkNBT(compound.func_74781_a(key), Arrays.copyOfRange(keymap, 1, keymap.length), value);
        }
        return false;
    }

    protected boolean checkValue(NBTBase base, String value) {
        if (value == null || value.trim().equals(base.toString())) {
            return true;
        }
        if ((value = value.replace(";", ",")).equals(base.toString())) {
            return true;
        }
        String[] newValues = value.split(",");
        if (newValues.length < 2 && !value.contains(":")) {
            return false;
        }
        for (String newValue : newValues) {
            String[] tokens = newValue.split(":");
            if (this.checkNBT(base, Arrays.copyOf(tokens, tokens.length - 1), tokens[tokens.length - 1])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdvancedBlockFilter)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return obj.equals(this);
        }
        AdvancedBlockFilter other = (AdvancedBlockFilter)obj;
        return this.domainCheck.equals(other.domainCheck) && this.blockCheck.equals(other.blockCheck) && this.metaCheck.equals(other.metaCheck);
    }

    public AdvancedBlockFilter clone() {
        AdvancedBlockFilter other = new AdvancedBlockFilter();
        other.domainCheck = this.domainCheck;
        other.blockCheck = this.blockCheck;
        other.metaCheck = this.metaCheck;
        other.lastCacheOreDictSize = this.lastCacheOreDictSize;
        other.matchingOredictIDs.addAll(this.matchingOredictIDs);
        other.domainIsRegex = this.domainIsRegex;
        other.blockIsRegex = this.blockIsRegex;
        other.metaIsRegex = this.metaIsRegex;
        other.cachedBlockResults.putAll(this.cachedBlockResults);
        return other;
    }

    public String toString() {
        return this.domainCheck + ":" + this.blockCheck + ":" + this.metaCheck;
    }
}

