/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.blocks;

import com.fantasticsource.tools.datastructures.Color;
import com.fantasticsource.tools.datastructures.ColorImmutable;
import java.util.LinkedHashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class AdvancedBlockColors {
    protected static final LinkedHashMap<IBlockState, Color> TEXTURE_COLORS = new LinkedHashMap();

    public static Color getBlockColor(BlockPos blockPos, IBlockState state) {
        Color color = AdvancedBlockColors.getTextureColor(state);
        Minecraft minecraft = Minecraft.func_71410_x();
        int tint = minecraft.func_184125_al().func_186724_a(state, (IBlockAccess)minecraft.field_71441_e, blockPos, 0);
        if (tint != -1) {
            ColorImmutable texColor = color;
            color = new Color(tint, true);
            color.setRF(color.rf() * texColor.rf());
            color.setGF(color.gf() * texColor.gf());
            color.setBF(color.bf() * texColor.bf());
        }
        return color;
    }

    public static ColorImmutable getTextureColor(IBlockState state) {
        return (ColorImmutable)TEXTURE_COLORS.computeIfAbsent(state, o -> AdvancedBlockColors.getTextureColorInternal(state, true));
    }

    public static Color getTextureColorInternal(IBlockState state) {
        return AdvancedBlockColors.getTextureColorInternal(state, false);
    }

    public static Color getTextureColorInternal(IBlockState state, boolean makeImmutable) {
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureAtlasSprite sprite = minecraft.func_175602_ab().func_175023_a().func_178122_a(state);
        int w = sprite.func_94211_a();
        int h = sprite.func_94216_b();
        int frames = sprite.func_110970_k();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float divisor = 0.0f;
        BlockRenderLayer renderLayer = state.func_177230_c().func_180664_k();
        for (int i = 0; i < frames; ++i) {
            int[][] rgbaData = sprite.func_147965_a(i);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    float a;
                    int c = rgbaData[0][y * w + x];
                    float f = a = renderLayer == BlockRenderLayer.SOLID ? 1.0f : (float)(c >>> 24) / 255.0f;
                    if ((renderLayer == BlockRenderLayer.CUTOUT || renderLayer == BlockRenderLayer.CUTOUT_MIPPED) && (double)a <= 0.5) continue;
                    r += (float)(c >> 16 & 0xFF) * a;
                    g += (float)(c >> 8 & 0xFF) * a;
                    b += (float)(c & 0xFF) * a;
                    divisor += a;
                }
            }
        }
        return makeImmutable ? new ColorImmutable(r / divisor, g / divisor, b / divisor, 1.0f) : new Color(r / (divisor *= 255.0f), g / divisor, b / divisor, 1.0f);
    }
}

