/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.fantasticlib.Compat;
import com.fantasticsource.fantasticlib.config.FantasticConfig;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Tools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ImprovedRayTracing {
    public static final ArrayList<Predicate<IBlockState>> BLOCK_STATE_ENDS_RAYTRACE_FILTERS = new ArrayList();
    protected static HashSet<IBlockState> transparentBlockstates = new HashSet();
    protected static HashSet<IBlockState> nonTransparentBlockstates = new HashSet();
    protected static HashSet<Block> transparentBlocks = new HashSet();
    protected static HashSet<Block> nonTransparentBlocks = new HashSet();
    protected static HashSet<Class<? extends Block>> transparentBlockSuperclasses = new HashSet();
    protected static HashSet<Class<? extends Block>> nonTransparentBlockSuperclasses = new HashSet();
    protected static HashSet<Class<? extends Block>> transparentBlockClasses = new HashSet();
    protected static HashSet<Class<? extends Block>> nonTransparentBlockClasses = new HashSet();
    protected static HashSet<Class<? extends Block>> ignoredBlockClasses = new HashSet();
    protected static HashSet<Material> transparentMaterials = new HashSet();
    protected static HashSet<Material> nonTransparentMaterials = new HashSet();
    protected static final int ITERATION_WARNING_THRESHOLD = 200;
    protected static long lastWarning = -1L;
    protected static int errorCount = 0;

    public static void reloadConfigs() {
        Block block;
        String[] tokens2;
        String[] tokens;
        transparentBlockstates.clear();
        nonTransparentBlockstates.clear();
        transparentBlocks.clear();
        nonTransparentBlocks.clear();
        transparentBlockSuperclasses.clear();
        nonTransparentBlockSuperclasses.clear();
        transparentBlockClasses.clear();
        nonTransparentBlockClasses.clear();
        ignoredBlockClasses.clear();
        transparentMaterials.clear();
        nonTransparentMaterials.clear();
        for (String s : FantasticConfig.raytraceSettings.rayBlockstateFilter) {
            int meta;
            if (s.trim().equals("")) continue;
            tokens = Tools.fixedSplit(s, ",");
            if (tokens.length != 2) {
                System.err.println(TextFormatting.RED + "Invalid raytrace blockstate filter: " + s);
                continue;
            }
            tokens2 = Tools.fixedSplit(tokens[0].trim(), ":");
            if (tokens2.length != 3) {
                System.err.println(TextFormatting.RED + "Invalid raytrace blockstate filter: " + s);
                continue;
            }
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tokens2[0].trim(), tokens2[1].trim()));
            if (block == null) {
                System.err.println(TextFormatting.RED + "Invalid raytrace blockstate filter; block not found: " + s);
                continue;
            }
            try {
                meta = Integer.parseInt(tokens2[2].trim());
            }
            catch (NumberFormatException e) {
                System.err.println(TextFormatting.RED + "Invalid raytrace blockstate filter: " + s);
                continue;
            }
            IBlockState blockState = block.func_176203_a(meta);
            if (block.func_176201_c(blockState) != meta) {
                System.err.println(TextFormatting.RED + "Invalid raytrace blockstate filter; state not found for meta: " + s);
                continue;
            }
            if (Boolean.parseBoolean(tokens[1].trim())) {
                transparentBlockstates.add(blockState);
                continue;
            }
            nonTransparentBlockstates.add(blockState);
        }
        for (String s : FantasticConfig.raytraceSettings.rayBlockFilter) {
            if (s.trim().equals("")) continue;
            tokens = Tools.fixedSplit(s, ",");
            if (tokens.length != 2) {
                System.err.println(TextFormatting.RED + "Invalid raytrace block filter: " + s);
                continue;
            }
            tokens2 = Tools.fixedSplit(tokens[0].trim(), ":");
            if (tokens2.length != 2) {
                System.err.println(TextFormatting.RED + "Invalid raytrace block filter: " + s);
                continue;
            }
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tokens2[0].trim(), tokens2[1].trim()));
            if (block == null) {
                System.err.println(TextFormatting.RED + "Invalid raytrace block filter; block not found: " + s);
                continue;
            }
            if (Boolean.parseBoolean(tokens[1].trim())) {
                transparentBlocks.add(block);
                continue;
            }
            nonTransparentBlocks.add(block);
        }
        for (String s : FantasticConfig.raytraceSettings.rayBlockSuperclassFilter) {
            if (s.trim().equals("")) continue;
            tokens = Tools.fixedSplit(s, ",");
            if (tokens.length != 2) {
                System.err.println(TextFormatting.RED + "Invalid raytrace block superclass filter: " + s);
                continue;
            }
            Class cls = ReflectionTool.getClassByName(tokens[0].trim());
            if (cls == null) {
                System.err.println(TextFormatting.RED + "Invalid raytrace block superclass filter; class not found: " + s);
                continue;
            }
            if (Boolean.parseBoolean(tokens[1].trim())) {
                transparentBlockSuperclasses.add(cls);
                continue;
            }
            nonTransparentBlockSuperclasses.add(cls);
        }
        block81: for (String s : FantasticConfig.raytraceSettings.rayMaterialFilter) {
            Material material;
            if (s.trim().equals("")) continue;
            tokens = Tools.fixedSplit(s, ",");
            if (tokens.length != 2) {
                System.err.println(TextFormatting.RED + "Invalid raytrace material filter: " + s);
                continue;
            }
            switch (tokens[0].trim().toLowerCase()) {
                case "air": {
                    material = Material.field_151579_a;
                    break;
                }
                case "grass": {
                    material = Material.field_151577_b;
                    break;
                }
                case "ground": {
                    material = Material.field_151578_c;
                    break;
                }
                case "wood": {
                    material = Material.field_151575_d;
                    break;
                }
                case "rock": {
                    material = Material.field_151576_e;
                    break;
                }
                case "iron": {
                    material = Material.field_151573_f;
                    break;
                }
                case "anvil": {
                    material = Material.field_151574_g;
                    break;
                }
                case "water": {
                    material = Material.field_151586_h;
                    break;
                }
                case "lava": {
                    material = Material.field_151587_i;
                    break;
                }
                case "leaves": {
                    material = Material.field_151584_j;
                    break;
                }
                case "plants": {
                    material = Material.field_151585_k;
                    break;
                }
                case "vine": {
                    material = Material.field_151582_l;
                    break;
                }
                case "sponge": {
                    material = Material.field_151583_m;
                    break;
                }
                case "cloth": {
                    material = Material.field_151580_n;
                    break;
                }
                case "fire": {
                    material = Material.field_151581_o;
                    break;
                }
                case "sand": {
                    material = Material.field_151595_p;
                    break;
                }
                case "circuits": {
                    material = Material.field_151594_q;
                    break;
                }
                case "carpet": {
                    material = Material.field_151593_r;
                    break;
                }
                case "glass": {
                    material = Material.field_151592_s;
                    break;
                }
                case "redstone_light": {
                    material = Material.field_151591_t;
                    break;
                }
                case "tnt": {
                    material = Material.field_151590_u;
                    break;
                }
                case "coral": {
                    material = Material.field_151589_v;
                    break;
                }
                case "ice": {
                    material = Material.field_151588_w;
                    break;
                }
                case "packed_ice": {
                    material = Material.field_151598_x;
                    break;
                }
                case "snow": {
                    material = Material.field_151597_y;
                    break;
                }
                case "crafted_snow": {
                    material = Material.field_151596_z;
                    break;
                }
                case "cactus": {
                    material = Material.field_151570_A;
                    break;
                }
                case "clay": {
                    material = Material.field_151571_B;
                    break;
                }
                case "gourd": {
                    material = Material.field_151572_C;
                    break;
                }
                case "dragon_egg": {
                    material = Material.field_151566_D;
                    break;
                }
                case "portal": {
                    material = Material.field_151567_E;
                    break;
                }
                case "cake": {
                    material = Material.field_151568_F;
                    break;
                }
                case "web": {
                    material = Material.field_151569_G;
                    break;
                }
                case "piston": {
                    material = Material.field_76233_E;
                    break;
                }
                case "barrier": {
                    material = Material.field_175972_I;
                    break;
                }
                case "structure_void": {
                    material = Material.field_189963_J;
                    break;
                }
                default: {
                    System.err.println(TextFormatting.RED + "Invalid raytrace material filter; material not found: " + s);
                    continue block81;
                }
            }
            if (Boolean.parseBoolean(tokens[1].trim())) {
                transparentMaterials.add(material);
                continue;
            }
            nonTransparentMaterials.add(material);
        }
    }

    public static double entityPenetration(Entity fromEyesOf, double maxDistance, Entity target, boolean isPhysicsCheck) {
        if (fromEyesOf.field_70170_p != target.field_70170_p) {
            return Double.NaN;
        }
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.entityPenetration(target, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)), isPhysicsCheck);
    }

    public static double entityPenetration(Entity target, Vec3d vecStart, Vec3d vecEnd, double maxDistance, boolean isPhysicsCheck) {
        return ImprovedRayTracing.entityPenetration(target, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)), isPhysicsCheck);
    }

    public static double entityPenetration(Entity target, Vec3d vecStart, Vec3d vecEnd, boolean isPhysicsCheck) {
        RayTraceResult entityEnd = ImprovedRayTracing.rayTraceEntity(target, vecEnd, vecStart);
        if (entityEnd == null || entityEnd.field_72313_a == RayTraceResult.Type.MISS) {
            return Double.NaN;
        }
        RayTraceResult entityStart = ImprovedRayTracing.rayTraceEntity(target, vecStart, vecEnd);
        RayTraceResult blockHit = ImprovedRayTracing.rayTraceBlocks(target.field_70170_p, vecStart, entityEnd.field_72307_f, isPhysicsCheck);
        if (blockHit.field_72313_a == RayTraceResult.Type.MISS) {
            return entityStart.field_72307_f.func_72438_d(entityEnd.field_72307_f);
        }
        if (blockHit.field_72307_f == null) {
            return -vecStart.func_72438_d(entityStart.field_72307_f);
        }
        return vecStart.func_72438_d(blockHit.field_72307_f) - vecStart.func_72438_d(entityStart.field_72307_f);
    }

    public static RayTraceResult rayTraceEntity(Entity fromEyesOf, double maxDistance, Entity target) {
        if (fromEyesOf.field_70170_p != target.field_70170_p) {
            return null;
        }
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.rayTraceEntity(target, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)));
    }

    public static RayTraceResult rayTraceEntity(Entity target, Vec3d vecStart, Vec3d vecEnd, double maxDistance) {
        return ImprovedRayTracing.rayTraceEntity(target, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)));
    }

    public static RayTraceResult rayTraceEntity(Entity target, Vec3d vecStart, Vec3d vecEnd) {
        return target.func_174813_aQ().func_72327_a(vecStart, vecEnd);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(Entity fromEyesOf, double maxDistance, boolean isPhysicsCheck) {
        return ImprovedRayTracing.blocksInRay(fromEyesOf, maxDistance, 200, isPhysicsCheck);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(Entity fromEyesOf, double maxDistance, int maxBlocks, boolean isPhysicsCheck) {
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.blocksInRay(fromEyesOf.field_70170_p, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)), maxBlocks, isPhysicsCheck);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, boolean isPhysicsCheck) {
        return ImprovedRayTracing.blocksInRay(world, vecStart, vecEnd, maxDistance, 200, isPhysicsCheck);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, int maxBlocks, boolean isPhysicsCheck) {
        return ImprovedRayTracing.blocksInRay(world, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)), maxBlocks, isPhysicsCheck);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(World world, Vec3d vecStart, Vec3d vecEnd, boolean isPhysicsCheck) {
        return ImprovedRayTracing.blocksInRay(world, vecStart, vecEnd, 200, isPhysicsCheck);
    }

    @Nonnull
    public static BlockPos[] blocksInRay(World world, Vec3d vecStart, Vec3d vecEnd, int maxBlocks, boolean isPhysicsCheck) {
        int nextZStop;
        int nextYStop;
        int nextXStop;
        int yDir;
        int xDir;
        RayTraceResult result;
        world.field_72984_F.func_76320_a("Fantastic Lib: Blocks In Ray");
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        BlockPos pos = new BlockPos(vecStart);
        BlockPos endPos = new BlockPos(vecEnd);
        if (vecEnd.field_72450_a > vecStart.field_72450_a && vecEnd.field_72450_a == (double)((int)vecEnd.field_72450_a)) {
            endPos = new BlockPos(endPos.func_177958_n() - 1, endPos.func_177956_o(), endPos.func_177952_p());
        }
        if (vecEnd.field_72448_b > vecStart.field_72448_b && vecEnd.field_72448_b == (double)((int)vecEnd.field_72448_b)) {
            endPos = new BlockPos(endPos.func_177958_n(), endPos.func_177956_o() - 1, endPos.func_177952_p());
        }
        if (vecEnd.field_72449_c > vecStart.field_72449_c && vecEnd.field_72449_c == (double)((int)vecEnd.field_72449_c)) {
            endPos = new BlockPos(endPos.func_177958_n(), endPos.func_177956_o(), endPos.func_177952_p() - 1);
        }
        if (!world.func_175667_e(pos)) {
            world.field_72984_F.func_76319_b();
            return new BlockPos[0];
        }
        IBlockState state = world.func_180495_p(pos);
        if ((isPhysicsCheck || !ImprovedRayTracing.canSeeThrough(state)) && state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k && (result = state.func_185910_a(world, pos, vecStart, vecEnd)) != null) {
            world.field_72984_F.func_76319_b();
            return new BlockPos[]{pos};
        }
        blocks.add(pos);
        if (pos.func_177958_n() == endPos.func_177958_n() && pos.func_177956_o() == endPos.func_177956_o() && pos.func_177952_p() == endPos.func_177952_p()) {
            world.field_72984_F.func_76319_b();
            return blocks.toArray(new BlockPos[0]);
        }
        double xStart = vecStart.field_72450_a;
        double yStart = vecStart.field_72448_b;
        double zStart = vecStart.field_72449_c;
        double xRange = vecEnd.field_72450_a - xStart;
        double yRange = vecEnd.field_72448_b - yStart;
        double zRange = vecEnd.field_72449_c - zStart;
        int n = xRange > 0.0 ? 1 : (xDir = xRange < 0.0 ? -1 : 0);
        int n2 = yRange > 0.0 ? 1 : (yDir = yRange < 0.0 ? -1 : 0);
        int zDir = zRange > 0.0 ? 1 : (zRange < 0.0 ? -1 : 0);
        double xInverseRange = xDir == 0 ? Double.NaN : 1.0 / xRange;
        double yInverseRange = yDir == 0 ? Double.NaN : 1.0 / yRange;
        double zInverseRange = zDir == 0 ? Double.NaN : 1.0 / zRange;
        int n3 = nextXStop = xDir == 0 ? Integer.MAX_VALUE : pos.func_177958_n();
        if (xDir == 1) {
            ++nextXStop;
        }
        int n4 = nextYStop = yDir == 0 ? Integer.MAX_VALUE : pos.func_177956_o();
        if (yDir == 1) {
            ++nextYStop;
        }
        int n5 = nextZStop = zDir == 0 ? Integer.MAX_VALUE : pos.func_177952_p();
        if (zDir == 1) {
            ++nextZStop;
        }
        double normalizedXDistToStop = 7777777.0;
        double normalizedYDistToStop = 7777777.0;
        for (int i = 1; i <= maxBlocks; ++i) {
            double zDistToStop;
            double normalizedZDistToStop;
            double yDistToStop;
            int mininumNormalizedDistance = 0;
            if (xDir != 0) {
                double xDistToStop = (double)nextXStop - xStart;
                normalizedXDistToStop = xDistToStop * xInverseRange;
                mininumNormalizedDistance = 1;
            }
            if (yDir != 0 && (normalizedYDistToStop = (yDistToStop = (double)nextYStop - yStart) * yInverseRange) < normalizedXDistToStop) {
                mininumNormalizedDistance = 2;
            }
            if (zDir != 0 && (normalizedZDistToStop = (zDistToStop = (double)nextZStop - zStart) * zInverseRange) < normalizedXDistToStop && normalizedZDistToStop < normalizedYDistToStop) {
                mininumNormalizedDistance = 3;
            }
            if (mininumNormalizedDistance == 1) {
                pos = pos.func_177965_g(xDir);
                nextXStop += xDir;
            } else if (mininumNormalizedDistance == 2) {
                pos = pos.func_177981_b(yDir);
                nextYStop += yDir;
            } else {
                pos = pos.func_177970_e(zDir);
                nextZStop += zDir;
            }
            blocks.add(pos);
            if (!world.func_175667_e(pos)) {
                world.field_72984_F.func_76319_b();
                return blocks.toArray(new BlockPos[0]);
            }
            state = world.func_180495_p(pos);
            if ((isPhysicsCheck || !ImprovedRayTracing.canSeeThrough(state)) && state.func_185890_d((IBlockAccess)world, pos) != Block.field_185506_k && (result = state.func_185910_a(world, pos, vecStart, vecEnd)) != null) {
                world.field_72984_F.func_76319_b();
                return blocks.toArray(new BlockPos[0]);
            }
            if (pos.func_177958_n() != endPos.func_177958_n() || pos.func_177956_o() != endPos.func_177956_o() || pos.func_177952_p() != endPos.func_177952_p()) continue;
            world.field_72984_F.func_76319_b();
            return blocks.toArray(new BlockPos[0]);
        }
        if (maxBlocks >= 200 && (lastWarning == -1L || System.currentTimeMillis() - lastWarning > 300000L)) {
            System.err.println("WARNING: BEYOND-LIMIT RAYTRACING DETECTED!  This warning will not show more than once every 5 minutes.  This is usually due to inefficient raytrace calls from another mod");
            System.err.println("This type of error has occurred " + errorCount + " additional times since the last time this message was shown");
            System.err.println("From " + vecStart + " to " + vecEnd + " (distance: " + vecStart.func_72438_d(vecEnd) + ")");
            System.err.println("Limit: " + maxBlocks + " iterations (not synonymous to distance, but longer distances are generally more iterations)");
            System.err.println();
            Tools.printStackTrace();
            lastWarning = System.currentTimeMillis();
        } else {
            ++errorCount;
        }
        world.field_72984_F.func_76319_b();
        return blocks.toArray(new BlockPos[0]);
    }

    public static boolean isUnobstructed(Entity fromEyesOf, double maxDistance, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks((Entity)fromEyesOf, (double)maxDistance, (boolean)isPhysicsCheck).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(Entity fromEyesOf, double maxDistance, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        return ImprovedRayTracing.rayTraceBlocks((Entity)fromEyesOf, (double)maxDistance, (boolean)isPhysicsCheck, (boolean)alsoCheckFluids).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(Entity fromEyesOf, double maxDistance, int maxBlocks, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks((Entity)fromEyesOf, (double)maxDistance, (int)maxBlocks, (boolean)isPhysicsCheck).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(Entity fromEyesOf, double maxDistance, int maxBlocks, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        return ImprovedRayTracing.rayTraceBlocks((Entity)fromEyesOf, (double)maxDistance, (int)maxBlocks, (boolean)isPhysicsCheck, (boolean)alsoCheckFluids).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)vecStart, (Vec3d)vecEnd, (double)maxDistance, (boolean)isPhysicsCheck).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, int maxBlocks, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)vecStart, (Vec3d)vecEnd, (double)maxDistance, (int)maxBlocks, (boolean)isPhysicsCheck).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(World world, Vec3d vecStart, Vec3d vecEnd, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)vecStart, (Vec3d)vecEnd, (boolean)isPhysicsCheck).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(World world, Vec3d vecStart, Vec3d vecEnd, int maxBlocks, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)vecStart, (Vec3d)vecEnd, (int)maxBlocks, (boolean)isPhysicsCheck).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(World world, Vec3d vecStart, Vec3d vecEnd, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        return ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)vecStart, (Vec3d)vecEnd, (boolean)isPhysicsCheck, (boolean)alsoCheckFluids).field_72313_a == RayTraceResult.Type.MISS;
    }

    public static boolean isUnobstructed(World world, Vec3d vecStart, Vec3d vecEnd, int maxBlocks, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        return ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)vecStart, (Vec3d)vecEnd, (int)maxBlocks, (boolean)isPhysicsCheck, (boolean)alsoCheckFluids).field_72313_a == RayTraceResult.Type.MISS;
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(Entity fromEyesOf, double maxDistance, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks(fromEyesOf, maxDistance, 200, isPhysicsCheck);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(Entity fromEyesOf, double maxDistance, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        return ImprovedRayTracing.rayTraceBlocks(fromEyesOf, maxDistance, 200, isPhysicsCheck, alsoCheckFluids);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(Entity fromEyesOf, double maxDistance, int maxBlocks, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks(fromEyesOf, maxDistance, maxBlocks, isPhysicsCheck, false);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(Entity fromEyesOf, double maxDistance, int maxBlocks, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        Vec3d eyes = fromEyesOf.func_174791_d().func_72441_c(0.0, (double)fromEyesOf.func_70047_e(), 0.0);
        return ImprovedRayTracing.rayTraceBlocks(fromEyesOf.field_70170_p, eyes, eyes.func_178787_e(fromEyesOf.func_70040_Z().func_186678_a(maxDistance)), maxBlocks, isPhysicsCheck, alsoCheckFluids);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks(world, vecStart, vecEnd, maxDistance, 200, isPhysicsCheck);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, double maxDistance, int maxBlocks, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks(world, vecStart, vecStart.func_178787_e(vecEnd.func_178788_d(vecStart).func_72432_b().func_186678_a(maxDistance)), maxBlocks, isPhysicsCheck);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks(world, vecStart, vecEnd, 200, isPhysicsCheck);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, int maxBlocks, boolean isPhysicsCheck) {
        return ImprovedRayTracing.rayTraceBlocks(world, vecStart, vecEnd, maxBlocks, isPhysicsCheck, false);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        return ImprovedRayTracing.rayTraceBlocks(world, vecStart, vecEnd, 200, isPhysicsCheck, alsoCheckFluids);
    }

    @Nonnull
    public static RayTraceResult rayTraceBlocks(World world, Vec3d vecStart, Vec3d vecEnd, int maxBlocks, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        int nextZStop;
        int nextYStop;
        int nextXStop;
        int yDir;
        int xDir;
        world.field_72984_F.func_76320_a("Fantastic Lib: Improved Raytrace");
        BlockPos pos = new BlockPos(vecStart);
        BlockPos endPos = new BlockPos(vecEnd);
        if (vecEnd.field_72450_a > vecStart.field_72450_a && vecEnd.field_72450_a == (double)((int)vecEnd.field_72450_a)) {
            endPos = new BlockPos(endPos.func_177958_n() - 1, endPos.func_177956_o(), endPos.func_177952_p());
        }
        if (vecEnd.field_72448_b > vecStart.field_72448_b && vecEnd.field_72448_b == (double)((int)vecEnd.field_72448_b)) {
            endPos = new BlockPos(endPos.func_177958_n(), endPos.func_177956_o() - 1, endPos.func_177952_p());
        }
        if (vecEnd.field_72449_c > vecStart.field_72449_c && vecEnd.field_72449_c == (double)((int)vecEnd.field_72449_c)) {
            endPos = new BlockPos(endPos.func_177958_n(), endPos.func_177956_o(), endPos.func_177952_p() - 1);
        }
        if (!world.func_175667_e(pos)) {
            world.field_72984_F.func_76319_b();
            return new FixedRayTraceResult(null, null, null, pos);
        }
        IBlockState state = world.func_180495_p(pos);
        RayTraceResult result = ImprovedRayTracing.checkState(world, pos, state, vecStart, vecEnd, isPhysicsCheck, alsoCheckFluids);
        if (result != null) {
            world.field_72984_F.func_76319_b();
            return result;
        }
        if (pos.func_177958_n() == endPos.func_177958_n() && pos.func_177956_o() == endPos.func_177956_o() && pos.func_177952_p() == endPos.func_177952_p()) {
            world.field_72984_F.func_76319_b();
            return new FixedRayTraceResult(RayTraceResult.Type.MISS, vecEnd, null, pos);
        }
        double xStart = vecStart.field_72450_a;
        double yStart = vecStart.field_72448_b;
        double zStart = vecStart.field_72449_c;
        double xRange = vecEnd.field_72450_a - xStart;
        double yRange = vecEnd.field_72448_b - yStart;
        double zRange = vecEnd.field_72449_c - zStart;
        int n = xRange > 0.0 ? 1 : (xDir = xRange < 0.0 ? -1 : 0);
        int n2 = yRange > 0.0 ? 1 : (yDir = yRange < 0.0 ? -1 : 0);
        int zDir = zRange > 0.0 ? 1 : (zRange < 0.0 ? -1 : 0);
        double xInverseRange = xDir == 0 ? Double.NaN : 1.0 / xRange;
        double yInverseRange = yDir == 0 ? Double.NaN : 1.0 / yRange;
        double zInverseRange = zDir == 0 ? Double.NaN : 1.0 / zRange;
        int n3 = nextXStop = xDir == 0 ? Integer.MAX_VALUE : pos.func_177958_n();
        if (xDir == 1) {
            ++nextXStop;
        }
        int n4 = nextYStop = yDir == 0 ? Integer.MAX_VALUE : pos.func_177956_o();
        if (yDir == 1) {
            ++nextYStop;
        }
        int n5 = nextZStop = zDir == 0 ? Integer.MAX_VALUE : pos.func_177952_p();
        if (zDir == 1) {
            ++nextZStop;
        }
        double normalizedXDistToStop = 7777777.0;
        double normalizedYDistToStop = 7777777.0;
        for (int i = 1; i <= maxBlocks; ++i) {
            double zDistToStop;
            double normalizedZDistToStop;
            double yDistToStop;
            int mininumNormalizedDistance = 0;
            if (xDir != 0) {
                double xDistToStop = (double)nextXStop - xStart;
                normalizedXDistToStop = xDistToStop * xInverseRange;
                mininumNormalizedDistance = 1;
            }
            if (yDir != 0 && (normalizedYDistToStop = (yDistToStop = (double)nextYStop - yStart) * yInverseRange) < normalizedXDistToStop) {
                mininumNormalizedDistance = 2;
            }
            if (zDir != 0 && (normalizedZDistToStop = (zDistToStop = (double)nextZStop - zStart) * zInverseRange) < normalizedXDistToStop && normalizedZDistToStop < normalizedYDistToStop) {
                mininumNormalizedDistance = 3;
            }
            if (mininumNormalizedDistance == 1) {
                pos = pos.func_177965_g(xDir);
                nextXStop += xDir;
            } else if (mininumNormalizedDistance == 2) {
                pos = pos.func_177981_b(yDir);
                nextYStop += yDir;
            } else {
                pos = pos.func_177970_e(zDir);
                nextZStop += zDir;
            }
            if (!world.func_175667_e(pos)) {
                world.field_72984_F.func_76319_b();
                return new FixedRayTraceResult(null, null, null, pos);
            }
            state = world.func_180495_p(pos);
            result = ImprovedRayTracing.checkState(world, pos, state, vecStart, vecEnd, isPhysicsCheck, alsoCheckFluids);
            if (result != null) {
                world.field_72984_F.func_76319_b();
                return result;
            }
            if (pos.func_177958_n() != endPos.func_177958_n() || pos.func_177956_o() != endPos.func_177956_o() || pos.func_177952_p() != endPos.func_177952_p()) continue;
            world.field_72984_F.func_76319_b();
            return new FixedRayTraceResult(RayTraceResult.Type.MISS, vecEnd, null, pos);
        }
        if (maxBlocks >= 200 && (lastWarning == -1L || System.currentTimeMillis() - lastWarning > 300000L)) {
            System.err.println("WARNING: BEYOND-LIMIT RAYTRACING DETECTED!  This warning will not show more than once every 5 minutes.  This is usually due to inefficient raytrace calls from another mod");
            System.err.println("This type of error has occurred " + errorCount + " additional times since the last time this message was shown");
            System.err.println("From " + vecStart + " to " + vecEnd + " (distance: " + vecStart.func_72438_d(vecEnd) + ")");
            System.err.println("Limit: " + maxBlocks + " iterations (not synonymous to distance, but longer distances are generally more iterations)");
            System.err.println();
            Tools.printStackTrace();
            lastWarning = System.currentTimeMillis();
        } else {
            ++errorCount;
        }
        world.field_72984_F.func_76319_b();
        return new FixedRayTraceResult(null, null, null, null);
    }

    public static RayTraceResult checkState(World world, BlockPos pos, IBlockState state, Vec3d vecStart, Vec3d vecEnd, boolean isPhysicsCheck, boolean alsoCheckFluids) {
        RayTraceResult result = null;
        Block block = state.func_177230_c();
        if (block instanceof BlockFluidBase || block instanceof BlockLiquid) {
            if (alsoCheckFluids || !isPhysicsCheck && !ImprovedRayTracing.canSeeThrough(state)) {
                result = ImprovedRayTracing.rayTraceWithinFluid(ImprovedRayTracing.getActualFluidHeights(world, pos, state.func_185904_a()), pos, vecStart, vecEnd);
            }
        } else if (isPhysicsCheck || !ImprovedRayTracing.canSeeThrough(state)) {
            ArrayList boxes = new ArrayList();
            state.func_185908_a(world, pos, Block.field_185505_j.func_186670_a(pos), boxes, null, false);
            ArrayList<RayTraceResult> results = new ArrayList<RayTraceResult>();
            for (AxisAlignedBB collisionBox : boxes) {
                if (collisionBox == Block.field_185506_k || (result = ImprovedRayTracing.rayTraceWithinNonFluid(pos, vecStart, vecEnd, collisionBox)) == null) continue;
                results.add(result);
            }
            if (results.size() > 0) {
                result = (RayTraceResult)results.get(0);
                double minDistSqr = vecStart.func_72436_e(result.field_72307_f);
                for (int i = results.size() - 1; i >= 1; --i) {
                    RayTraceResult r = (RayTraceResult)results.get(i);
                    double distSqr = vecStart.func_72436_e(r.field_72307_f);
                    if (!(distSqr < minDistSqr)) continue;
                    minDistSqr = distSqr;
                    result = r;
                }
            }
        }
        return result;
    }

    public static boolean canSeeThrough(IBlockState blockState) {
        Material material;
        for (Predicate<IBlockState> predicate : BLOCK_STATE_ENDS_RAYTRACE_FILTERS) {
            if (predicate.test(blockState)) continue;
            return false;
        }
        if (transparentBlockstates.contains(blockState)) {
            return true;
        }
        if (nonTransparentBlockstates.contains(blockState)) {
            return false;
        }
        Block block = blockState.func_177230_c();
        if (transparentBlocks.contains(block)) {
            return true;
        }
        if (nonTransparentBlocks.contains(block)) {
            return false;
        }
        Class<?> cls = block.getClass();
        if (transparentBlockClasses.contains(cls)) {
            return true;
        }
        if (nonTransparentBlockClasses.contains(cls)) {
            return false;
        }
        if (!ignoredBlockClasses.contains(cls)) {
            for (Class<? extends Block> superClass : transparentBlockSuperclasses) {
                if (!superClass.isAssignableFrom(cls)) continue;
                transparentBlockClasses.add(cls);
                return true;
            }
            for (Class<? extends Block> superClass : nonTransparentBlockSuperclasses) {
                if (!superClass.isAssignableFrom(cls)) continue;
                nonTransparentBlockClasses.add(cls);
                return false;
            }
            ignoredBlockClasses.add(cls);
        }
        if (transparentMaterials.contains(material = blockState.func_185904_a())) {
            return true;
        }
        if (nonTransparentMaterials.contains(material)) {
            return false;
        }
        if (material == Material.field_151584_j) {
            return true;
        }
        if (material == Material.field_151592_s) {
            return true;
        }
        if (material == Material.field_151588_w) {
            return true;
        }
        if (material == Material.field_151579_a) {
            return true;
        }
        if (material == Material.field_151586_h) {
            return true;
        }
        if (material == Material.field_151581_o) {
            return true;
        }
        if (material == Material.field_151567_E) {
            return !Compat.betterportals;
        }
        if (material == Material.field_175972_I) {
            return true;
        }
        if (material == Material.field_151585_k) {
            return true;
        }
        if (material == Material.field_151569_G) {
            return true;
        }
        if (material == Material.field_151582_l) {
            return true;
        }
        if (block instanceof BlockSlime) {
            return true;
        }
        if (block instanceof BlockTrapDoor) {
            return true;
        }
        if (block instanceof BlockFence) {
            return true;
        }
        if (block instanceof BlockFenceGate) {
            return true;
        }
        if (block == Blocks.field_180410_as) {
            return true;
        }
        if (block == Blocks.field_180411_ar) {
            return true;
        }
        if (block == Blocks.field_150411_aY) {
            return true;
        }
        if (block == Blocks.field_180413_ao || block == Blocks.field_150454_av) {
            return (block.func_176201_c(blockState) & 8) != 0;
        }
        return false;
    }

    public static RayTraceResult rayTraceWithinNonFluid(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        if (boundingBox.func_72318_a(start)) {
            return new RayTraceResult(start, null, pos);
        }
        RayTraceResult raytraceresult = boundingBox.func_72327_a(start, end);
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.field_72307_f, raytraceresult.field_178784_b, pos);
    }

    public static RayTraceResult rayTraceWithinFluid(float[] actualFluidHeights, BlockPos pos, Vec3d start, Vec3d end) {
        if (ImprovedRayTracing.fluidContains(actualFluidHeights, start.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) {
            return new RayTraceResult(start, null, pos);
        }
        if (start.equals((Object)end)) {
            return null;
        }
        if (ImprovedRayTracing.fluidContains(actualFluidHeights, end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) {
            return new RayTraceResult(end, null, pos);
        }
        RayTraceResult result = Block.field_185505_j.func_186670_a(pos).func_72327_a(end, start);
        if (result == null) {
            return null;
        }
        end = result.field_72307_f;
        if (ImprovedRayTracing.fluidContains(actualFluidHeights, end.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) {
            return new RayTraceResult(end, null, pos);
        }
        return null;
    }

    public static boolean fluidContains(float[] actualFluidHeights, Vec3d relativeVec) {
        double ne;
        double sw;
        double nw = actualFluidHeights[0];
        double se = actualFluidHeights[3];
        double c = (nw + se) * 0.5;
        if (relativeVec.field_72449_c >= relativeVec.field_72450_a) {
            sw = actualFluidHeights[2];
            ne = c + (c - sw);
        } else {
            ne = actualFluidHeights[1];
            sw = c + (c - ne);
        }
        double n = nw + (ne - nw) * relativeVec.field_72450_a;
        double s = sw + (se - sw) * relativeVec.field_72450_a;
        return n + (s - n) * relativeVec.field_72449_c > relativeVec.field_72448_b;
    }

    public static float[] getActualFluidHeights(World world, BlockPos pos, Material material) {
        float nw = ImprovedRayTracing.getFluidHeight(world, pos, material);
        float ne = ImprovedRayTracing.getFluidHeight(world, pos.func_177974_f(), material);
        float sw = ImprovedRayTracing.getFluidHeight(world, pos.func_177968_d(), material);
        float se = ImprovedRayTracing.getFluidHeight(world, pos.func_177974_f().func_177968_d(), material);
        return new float[]{nw, ne, sw, se};
    }

    public static float getFluidHeight(World world, BlockPos pos, Material material) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = pos.func_177982_a(-(j & 1), 0, -(j >> 1 & 1));
            if (world.func_180495_p(blockpos.func_177984_a()).func_185904_a() == material) {
                return 1.0f;
            }
            IBlockState other = world.func_180495_p(blockpos);
            Material otherMaterial = other.func_185904_a();
            if (otherMaterial != material) {
                if (otherMaterial.func_76220_a()) continue;
                f += 1.0f;
                ++i;
                continue;
            }
            int k = (Integer)other.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (k >= 8 || k == 0) {
                f += BlockLiquid.func_149801_b((int)k) * 10.0f;
                i += 10;
            }
            f += BlockLiquid.func_149801_b((int)k);
            ++i;
        }
        return 1.0f - f / (float)i;
    }

    public static class FixedRayTraceResult
    extends RayTraceResult {
        public FixedRayTraceResult(RayTraceResult.Type typeIn, Vec3d hitVecIn, EnumFacing sideHitIn, BlockPos blockPosIn) {
            super(typeIn, new Vec3d(0.0, 0.0, 0.0), sideHitIn, blockPosIn);
            this.field_72307_f = hitVecIn == null ? null : new Vec3d(hitVecIn.field_72450_a, hitVecIn.field_72448_b, hitVecIn.field_72449_c);
        }
    }
}

