/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Destination {
    public Integer dimension;
    public double x;
    public double y;
    public double z;
    public Float yaw;
    public Float pitch;

    public Destination(Entity entity) {
        this(entity.field_70170_p.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Float.valueOf(entity.func_70079_am()), Float.valueOf(entity.field_70125_A));
    }

    public Destination(BlockPos pos) {
        this((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public Destination(World world, float yaw, float pitch) {
        this(world.field_73011_w.getDimension(), (double)world.func_72912_H().func_76079_c() + 0.5, world.func_72912_H().func_76075_d(), (double)world.func_72912_H().func_76074_e() + 0.5, Float.valueOf(yaw), Float.valueOf(pitch));
    }

    public Destination(double x, double y, double z) {
        this(x, y, z, null, null);
    }

    public Destination(double x, double y, double z, Float yaw, Float pitch) {
        this(null, x, y, z, yaw, pitch);
    }

    public Destination(Integer dimension, double x, double y, double z, Float yaw, Float pitch) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public Destination(NBTTagCompound compound) {
        this(compound.func_74769_h("x"), compound.func_74769_h("y"), compound.func_74769_h("z"));
        if (compound.func_74764_b("dim")) {
            this.setDimension(compound.func_74762_e("dim"));
        }
        if (compound.func_74764_b("yaw")) {
            this.setRotation(Float.valueOf(compound.func_74760_g("yaw")), Float.valueOf(compound.func_74760_g("pitch")));
        }
    }

    public void addNBTTo(NBTTagCompound compound) {
        if (this.dimension != null) {
            compound.func_74782_a("dim", (NBTBase)new NBTTagInt(this.dimension.intValue()));
        }
        compound.func_74782_a("x", (NBTBase)new NBTTagDouble(this.x));
        compound.func_74782_a("y", (NBTBase)new NBTTagDouble(this.y));
        compound.func_74782_a("z", (NBTBase)new NBTTagDouble(this.z));
        if (this.yaw != null) {
            compound.func_74782_a("yaw", (NBTBase)new NBTTagDouble((double)this.yaw.floatValue()));
        }
        if (this.pitch != null) {
            compound.func_74782_a("pitch", (NBTBase)new NBTTagDouble((double)this.pitch.floatValue()));
        }
    }

    public Destination setDimension(Integer dimension) {
        this.dimension = dimension;
        return this;
    }

    public Destination setPosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Destination setPosition(BlockPos pos) {
        return this.setPosition(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Destination setRotation(Float yaw, Float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
        return this;
    }

    public String toString() {
        return this.dimension + ", (" + this.x + ", " + this.y + ", " + this.z + "), (" + this.yaw + ", " + this.pitch + ")";
    }
}

