/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.teleport;

import eaglemixins.network.PacketHandler;
import eaglemixins.network.PacketStartTeleportOverlay;
import eaglemixins.network.PacketStopTeleportOverlay;
import eaglemixins.potion.PotionTeleportationSickness;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TeleportUnderneath {
    private static final Logger LOGGER = LogManager.getLogger((String)"EagleMixins");
    public static final int GLITCH_DIM = 3;
    public static final int OVERWORLD_DIM = 0;

    private TeleportUnderneath() {
    }

    public static void triggerGlitch(EntityPlayer player) {
        WorldServer overworld;
        if (!DimensionManager.isDimensionRegistered((int)3) || !DimensionManager.isDimensionRegistered((int)0)) {
            LOGGER.error("[EagleMixins] Glitch or Overworld dimension not registered.");
            return;
        }
        WorldServer glitchWorld = DimensionManager.getWorld((int)3);
        if (glitchWorld == null) {
            DimensionManager.initDimension((int)3);
            glitchWorld = DimensionManager.getWorld((int)3);
        }
        if ((overworld = DimensionManager.getWorld((int)0)) == null) {
            DimensionManager.initDimension((int)0);
            overworld = DimensionManager.getWorld((int)0);
        }
        if (glitchWorld == null || overworld == null) {
            LOGGER.error("[EagleMixins] Could not access glitch or overworld dimension after init.");
            return;
        }
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            PacketHandler.sendTo(new PacketStartTeleportOverlay(true), mp);
            Objects.requireNonNull(mp.func_184102_h()).func_184103_al().transferPlayerToDimension(mp, 3, (Teleporter)new NullPortalTeleporter(glitchWorld));
            boolean firstTime = !TeleportUnderneath.getPersist((EntityPlayer)mp).func_74767_n("glitchDone");
            TeleportUnderneath.getPersist((EntityPlayer)mp).func_74757_a("glitchDone", true);
            long stayTicks = firstTime ? 140L : (long)(140 + player.field_70170_p.field_73012_v.nextInt(260));
            TeleportUnderneath.getPersist((EntityPlayer)mp).func_74772_a("glitchEndTime", player.field_70170_p.func_82737_E() + stayTicks);
            mp.field_71075_bZ.field_75102_a = true;
            mp.func_71016_p();
        }
    }

    public static void tryReturn(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP mp = (EntityPlayerMP)player;
        NBTTagCompound p = TeleportUnderneath.getPersist((EntityPlayer)mp);
        if (!p.func_74764_b("glitchEndTime")) {
            return;
        }
        if (player.field_70170_p.func_82737_E() < p.func_74763_f("glitchEndTime")) {
            return;
        }
        int originDim = p.func_74762_e("glitchOriginDim");
        if (!DimensionManager.isDimensionRegistered((int)originDim)) {
            LOGGER.error("[EagleMixins] Glitch return failed: dimension {} not registered.", (Object)originDim);
            return;
        }
        double x = p.func_74769_h("glitchReturnX");
        double y = p.func_74769_h("glitchReturnY");
        double z = p.func_74769_h("glitchReturnZ");
        WorldServer target = DimensionManager.getWorld((int)originDim);
        if (target == null) {
            return;
        }
        mp.field_71075_bZ.field_75102_a = false;
        mp.func_71016_p();
        PacketHandler.sendTo(new PacketStartTeleportOverlay(true), mp);
        Objects.requireNonNull(mp.func_184102_h()).func_184103_al().transferPlayerToDimension(mp, originDim, (Teleporter)new NullPortalTeleporter(target));
        MinecraftServer server = mp.func_184102_h();
        if (server != null) {
            server.func_152344_a(() -> {
                mp.func_70634_a(x + 0.5, y, z + 0.5);
                mp.func_70690_d(new PotionEffect((Potion)PotionTeleportationSickness.INSTANCE, 200, 0));
            });
        }
        PacketHandler.sendTo(new PacketStopTeleportOverlay(), mp);
        p.func_82580_o("glitchEndTime");
        p.func_82580_o("glitchOriginDim");
        p.func_82580_o("glitchReturnX");
        p.func_82580_o("glitchReturnY");
        p.func_82580_o("glitchReturnZ");
        TeleportUnderneath.setPersist((EntityPlayer)mp, p);
    }

    public static BlockPos findSafeGlitchPosition(WorldServer world) {
        Random rand = new Random();
        for (int attempt = 0; attempt < 100; ++attempt) {
            int x = (rand.nextBoolean() ? 1 : -1) * (5000 + rand.nextInt(10000));
            int z = (rand.nextBoolean() ? 1 : -1) * (5000 + rand.nextInt(10000));
            for (int y = 150; y > 10; --y) {
                BlockPos floor = new BlockPos(x, y, z);
                BlockPos a1 = floor.func_177984_a();
                BlockPos a2 = floor.func_177981_b(2);
                if (!world.func_180495_p(floor).func_185914_p() || !world.func_175623_d(a1) && !world.func_180495_p(a1).func_185904_a().func_76224_d() || !world.func_175623_d(a2) && !world.func_180495_p(a2).func_185904_a().func_76224_d()) continue;
                return a1;
            }
            BlockPos top = world.func_175672_r(new BlockPos(x, 0, z));
            if (top == null) continue;
            return top.func_177984_a();
        }
        return new BlockPos(0, 250, 0);
    }

    private static NBTTagCompound getPersist(EntityPlayer player) {
        return player.getEntityData().func_74775_l("PlayerPersisted");
    }

    private static void setPersist(EntityPlayer player, NBTTagCompound tag) {
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    public static final class NullPortalTeleporter
    extends Teleporter {
        public NullPortalTeleporter(WorldServer worldIn) {
            super(worldIn);
        }

        public void func_180266_a(Entity entity, float rotationYaw) {
            BlockPos pos = TeleportUnderneath.findSafeGlitchPosition(this.field_85192_a);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
        }

        public boolean func_180620_b(Entity entity, float rotationYaw) {
            return true;
        }

        public boolean func_85188_a(Entity entity) {
            return true;
        }

        public void func_85189_a(long worldTime) {
        }
    }
}

