/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.teleport;

import eaglemixins.config.ForgeConfigHandler;
import eaglemixins.network.PacketHandler;
import eaglemixins.network.PacketStopTeleportOverlay;
import eaglemixins.potion.PotionTeleportationSickness;
import eaglemixins.teleport.TeleportData;
import eaglemixins.teleport.TeleportRegistry;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class TeleportService {
    private static final Queue<EntityPlayer> TELEPORT_QUEUE = new ConcurrentLinkedQueue<EntityPlayer>();

    private TeleportService() {
    }

    public static void enqueue(EntityPlayer player) {
        TELEPORT_QUEUE.add(player);
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        while (!TELEPORT_QUEUE.isEmpty()) {
            NBTTagCompound tag;
            int linkId;
            TeleportData data;
            EntityPlayer player = TELEPORT_QUEUE.poll();
            if (player == null || player.field_70170_p == null || (data = TeleportRegistry.get(linkId = (tag = player.getEntityData().func_74775_l("PlayerPersisted")).func_74762_e("linkId"))) == null || data.receiver == null) continue;
            BlockPos finalPos = data.receiver.func_177982_a(0, 3, 3);
            MinecraftServer server = player.func_184102_h();
            if (server != null) {
                server.func_152344_a(() -> {
                    player.func_70634_a((double)finalPos.func_177958_n() + 0.5, (double)finalPos.func_177956_o(), (double)finalPos.func_177952_p() + 0.5);
                    player.func_70690_d(new PotionEffect((Potion)PotionTeleportationSickness.INSTANCE, 200, 0));
                });
            }
            if (player instanceof EntityPlayerMP) {
                PacketHandler.sendTo(new PacketStopTeleportOverlay(), (EntityPlayerMP)player);
            }
            tag.func_82580_o("justTeleported");
            tag.func_82580_o("linkId");
            player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
        }
    }

    public static boolean onePercent(Random rand) {
        return rand.nextInt(100) < ForgeConfigHandler.server.teleportation_chance;
    }
}

