/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.teleport;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import eaglemixins.teleport.TeleportData;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TeleportRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"EagleMixins");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<Integer, TeleportData> REGISTRY = new HashMap<Integer, TeleportData>();
    private static File configFile;
    private static boolean initialized;

    private TeleportRegistry() {
    }

    public static synchronized void ensureInit() {
        if (initialized) {
            return;
        }
        TeleportRegistry.reloadConfigFile();
        TeleportRegistry.loadFromDisk();
        TeleportRegistry.seedMissingFromDefaults();
        TeleportRegistry.saveToDisk();
        initialized = true;
    }

    public static synchronized TeleportData getOrCreate(int linkId) {
        TeleportRegistry.ensureInit();
        return REGISTRY.computeIfAbsent(linkId, id -> {
            TeleportData d = new TeleportData();
            d.sender = TeleportData.senderApprox(id);
            d.tempReceiver = TeleportData.receiverApprox(id);
            return d;
        });
    }

    public static synchronized TeleportData get(int linkId) {
        TeleportRegistry.ensureInit();
        return REGISTRY.get(linkId);
    }

    public static synchronized void put(int linkId, TeleportData data) {
        TeleportRegistry.ensureInit();
        REGISTRY.put(linkId, data);
        TeleportRegistry.saveToDisk();
    }

    public static synchronized void updateSender(int linkId, BlockPos sender) {
        TeleportData d = TeleportRegistry.getOrCreate(linkId);
        d.sender = sender;
        TeleportRegistry.put(linkId, d);
    }

    public static synchronized void updateReceiver(int linkId, BlockPos receiver) {
        TeleportData d = TeleportRegistry.getOrCreate(linkId);
        d.receiver = receiver;
        TeleportRegistry.put(linkId, d);
    }

    public static synchronized void markTempReceiverIfEmpty(int linkId) {
        TeleportData d = TeleportRegistry.getOrCreate(linkId);
        if (d.tempReceiver == null) {
            d.tempReceiver = TeleportData.receiverApprox(linkId);
        }
        TeleportRegistry.put(linkId, d);
    }

    public static synchronized void reloadConfigFile() {
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (overworld != null) {
            File saveFolder = overworld.func_72860_G().func_75765_b();
            configFile = new File(saveFolder, "eaglemixins_teleports.json");
        } else {
            LOGGER.warn("[EagleMixins] World not loaded yet \u2014 defaulting to root.");
            configFile = new File("eaglemixins_teleports.json");
        }
    }

    private static synchronized void loadFromDisk() {
        if (configFile == null || !configFile.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            Type type = new TypeToken<Map<Integer, TeleportData>>(){}.getType();
            Map loaded = (Map)GSON.fromJson((Reader)reader, type);
            if (loaded != null) {
                REGISTRY.clear();
                REGISTRY.putAll(loaded);
            }
        }
        catch (IOException e) {
            LOGGER.error("[EagleMixins] Failed to load teleport destinations: {}", (Object)e.getMessage());
        }
    }

    public static synchronized void saveToDisk() {
        if (configFile == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson(REGISTRY, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("[EagleMixins] Failed to save teleport destinations: {}", (Object)e.getMessage());
        }
    }

    private static synchronized void seedMissingFromDefaults() {
        for (int linkId : TeleportData.ALL_IDS) {
            if (REGISTRY.containsKey(linkId)) continue;
            TeleportData d = new TeleportData();
            d.sender = TeleportData.senderApprox(linkId);
            d.tempReceiver = TeleportData.receiverApprox(linkId);
            REGISTRY.put(linkId, d);
        }
    }

    static {
        initialized = false;
    }
}

