/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.network;

import eaglemixins.capability.ChunkRadiationSource;
import eaglemixins.config.ForgeConfigHandler;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ShortMap;
import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import nc.capability.radiation.source.IRadiationSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncHighRadiation
implements IMessage {
    private final Long2ShortMap data = new Long2ShortOpenHashMap();

    public PacketSyncHighRadiation() {
    }

    public PacketSyncHighRadiation(EntityPlayer player) {
        int chunkX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
        int chunkZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
        int r = 5;
        for (int x = -r; x <= r; ++x) {
            for (int z = -r; z <= r; ++z) {
                IRadiationSource radiation;
                Chunk chunk;
                if (x * x + z * z > r * r || (chunk = player.field_70170_p.func_72863_F().func_186026_b(chunkX + x, chunkZ + z)) == null || !((radiation = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) instanceof ChunkRadiationSource)) continue;
                short highRadiation = 0;
                for (int y = 0; y < 16; ++y) {
                    if (!((double)((ChunkRadiationSource)radiation).getSubchunkRadiationLevel(y) > ForgeConfigHandler.nuclear.rad_particle_threshold)) continue;
                    highRadiation = (short)(highRadiation | 1 << y);
                }
                this.data.put(ChunkPos.func_77272_a((int)(chunkX + x), (int)(chunkZ + z)), highRadiation);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        for (int i = buf.readByte(); i > 0; --i) {
            this.data.put(buf.readLong(), buf.readShort());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.data.size());
        for (Long2ShortMap.Entry e : this.data.long2ShortEntrySet()) {
            buf.writeLong(e.getLongKey());
            buf.writeShort((int)e.getShortValue());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSyncHighRadiation, IMessage> {
        public IMessage onMessage(PacketSyncHighRadiation message, MessageContext ctx) {
            if (ctx.side.isClient()) {
                FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> PacketProcessor.onMessage(message));
            }
            return null;
        }

        private static class PacketProcessor {
            private PacketProcessor() {
            }

            public static void onMessage(PacketSyncHighRadiation message) {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                for (Long2ShortMap.Entry e : message.data.long2ShortEntrySet()) {
                    Chunk chunk = world.func_72964_e((int)e.getLongKey(), (int)(e.getLongKey() >> 32));
                    IRadiationSource radiation = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
                    if (!(radiation instanceof ChunkRadiationSource)) {
                        return;
                    }
                    ((ChunkRadiationSource)radiation).setHighRadiation(e.getShortValue());
                }
            }
        }
    }
}

