/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.mixin.vanilla;

import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import eaglemixins.config.ForgeConfigHandler;
import java.util.Collection;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Shadow
    private NBTTagCompound field_77990_d;

    @Shadow
    public abstract boolean func_77942_o();

    @Shadow
    public abstract Item func_77973_b();

    @ModifyReturnValue(method={"getAttributeModifiers"}, at={@At(value="RETURN")})
    private Multimap<String, AttributeModifier> eagleMixins_itemStack_getAttributeModifiers(Multimap<String, AttributeModifier> map, @Local(argsOnly=true) EntityEquipmentSlot equipmentSlot) {
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            map.putAll(this.func_77973_b().getAttributeModifiers(equipmentSlot, (ItemStack)this));
        }
        return map;
    }

    @WrapOperation(method={"writeToNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;setTag(Ljava/lang/String;Lnet/minecraft/nbt/NBTBase;)V", ordinal=0)})
    private void eagleMixins_itemStack_writeToNBT(NBTTagCompound tagCompound, String key, NBTBase value, Operation<Void> original) {
        original.call(new Object[]{tagCompound, key, value});
        if (!ForgeConfigHandler.server.removeOldAttributes) {
            return;
        }
        if (!key.equals("tag")) {
            return;
        }
        NBTTagCompound stackCompound = (NBTTagCompound)value;
        if (!stackCompound.func_150297_b("AttributeModifiers", 9)) {
            return;
        }
        Multimap attributeModifiers = this.func_77973_b().func_111205_h(EntityEquipmentSlot.MAINHAND);
        Double vanillaAtkDmg = this.eagleMixins$getVanillaValue((Multimap<String, AttributeModifier>)attributeModifiers, "generic.attackDamage");
        Double vanillaAtkSpd = this.eagleMixins$getVanillaValue((Multimap<String, AttributeModifier>)attributeModifiers, "generic.attackSpeed");
        NBTTagList attrModNBTList = stackCompound.func_150295_c("AttributeModifiers", 10);
        if (vanillaAtkDmg != null) {
            attrModNBTList = this.eagleMixins$removeOldAttribute(attrModNBTList, "generic.attackDamage", "attackDamage", vanillaAtkDmg + 1.0);
        }
        if (vanillaAtkSpd != null) {
            attrModNBTList = this.eagleMixins$removeOldAttribute(attrModNBTList, "generic.attackSpeed", "attackSpeed", vanillaAtkSpd + 4.0);
        }
        stackCompound.func_74782_a("AttributeModifiers", (NBTBase)attrModNBTList);
        original.call(new Object[]{tagCompound, key, stackCompound});
        this.field_77990_d = stackCompound;
    }

    @Unique
    private Double eagleMixins$getVanillaValue(Multimap<String, AttributeModifier> attributeModifiers, String attributeName) {
        Collection vanillaAtkDmgMods = attributeModifiers.get((Object)attributeName);
        for (AttributeModifier mod : vanillaAtkDmgMods) {
            if (!mod.func_111166_b().equals("Weapon modifier") && !mod.func_111166_b().equals("Tool modifier")) continue;
            return mod.func_111164_d();
        }
        return null;
    }

    @Unique
    private NBTTagList eagleMixins$removeOldAttribute(NBTTagList attrModNBTList, String attributeName, String oldModName, double vanillaValue) {
        int indexToRemove = -1;
        for (int i = 0; i < attrModNBTList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = attrModNBTList.func_150305_b(i);
            AttributeModifier modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)nbttagcompound);
            if (modifier == null || modifier.func_111167_a().getLeastSignificantBits() == 0L || modifier.func_111167_a().getMostSignificantBits() == 0L || !nbttagcompound.func_74779_i("AttributeName").equals(attributeName) || !modifier.func_111166_b().equals(oldModName) || modifier.func_111169_c() != 0 || !(Math.abs(modifier.func_111164_d() - vanillaValue) < 0.01)) continue;
            indexToRemove = i;
            break;
        }
        if (indexToRemove != -1) {
            attrModNBTList.func_74744_a(indexToRemove);
        }
        return attrModNBTList;
    }
}

