/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.mixin.nuclearcraft.subchunkradiation;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import eaglemixins.EagleMixins;
import eaglemixins.capability.ChunkRadiationSource;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={RadiationHelper.class})
public abstract class RadiationHelperMixin {
    @Shadow(remap=false)
    public static IRadiationSource getRadiationSource(ICapabilityProvider provider) {
        return null;
    }

    @WrapOperation(method={"transferRadsToPlayer"}, at={@At(value="INVOKE", target="Lnc/capability/radiation/source/IRadiationSource;getRadiationLevel()D")}, remap=false)
    private static double eaglemixins_useSubchunkRadiation_transferRadsToPlayer(IRadiationSource instance, Operation<Double> original, @Local(argsOnly=true) EntityPlayer player) {
        if (instance instanceof ChunkRadiationSource) {
            return ((ChunkRadiationSource)instance).getSubchunkRadiationLevel(MathHelper.func_76125_a((int)(player.func_180425_c().func_177956_o() >> 4), (int)0, (int)15));
        }
        EagleMixins.LOGGER.error("EagleMixins RadiationHelper.transferRadsToPlayer called for non ChunkRadiationSource. Notify nischhelm!");
        return (Double)original.call(new Object[]{instance});
    }

    @Overwrite(remap=false)
    public static void spreadRadiationFromChunk(Chunk chunk, Chunk targetChunk) {
        IRadiationSource targetChunkSource;
        if (chunk == null || !chunk.func_177410_o()) {
            return;
        }
        IRadiationSource chunkSource = RadiationHelperMixin.getRadiationSource((ICapabilityProvider)chunk);
        if (!(chunkSource instanceof ChunkRadiationSource)) {
            return;
        }
        ChunkRadiationSource chunkRadSource = (ChunkRadiationSource)chunkSource;
        if (targetChunk != null && targetChunk.func_177410_o() && (targetChunkSource = RadiationHelperMixin.getRadiationSource((ICapabilityProvider)targetChunk)) instanceof ChunkRadiationSource) {
            ChunkRadiationSource targetChunkRadSource = (ChunkRadiationSource)targetChunkSource;
            for (int subchunk = 0; subchunk < 16; ++subchunk) {
                chunkRadSource.setSubchunk(subchunk);
                targetChunkRadSource.setSubchunk(subchunk);
                if (chunkSource.isRadiationNegligible() || targetChunkSource.getRadiationLevel() != 0.0 && !(chunkSource.getRadiationLevel() / targetChunkSource.getRadiationLevel() > 1.0 + NCConfig.radiation_spread_gradient)) continue;
                double radiationSpread = (chunkSource.getRadiationLevel() - targetChunkSource.getRadiationLevel()) * NCConfig.radiation_spread_rate;
                chunkSource.setRadiationLevel(chunkSource.getRadiationLevel() - radiationSpread);
                targetChunkSource.setRadiationLevel(targetChunkSource.getRadiationLevel() + radiationSpread * (1.0 - targetChunkSource.getScrubbingFraction()));
            }
            chunkRadSource.resetSubchunk();
            targetChunkRadSource.resetSubchunk();
        }
        for (int subchunk = 0; subchunk < 16; ++subchunk) {
            chunkRadSource.setSubchunk(subchunk);
            chunkSource.setRadiationBuffer(0.0);
            if (!chunkSource.isRadiationNegligible()) continue;
            chunkSource.setRadiationLevel(0.0);
        }
        chunkRadSource.resetSubchunk();
    }
}

