/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.mixin.nuclearcraft.subchunkradiation;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import eaglemixins.capability.ChunkRadiationSource;
import eaglemixins.config.ForgeConfigHandler;
import eaglemixins.network.PacketHandler;
import eaglemixins.network.PacketSyncHighRadiation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import nc.ModCheck;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadBiomes;
import nc.radiation.RadPotionEffects;
import nc.radiation.RadSources;
import nc.radiation.RadStructures;
import nc.radiation.RadWorlds;
import nc.radiation.RadiationHandler;
import nc.radiation.RadiationHelper;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.DamageSources;
import nc.util.ItemStackHelper;
import nc.util.StructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={RadiationHandler.class})
public abstract class RadiationHandlerMixin {
    @Shadow(remap=false)
    @Final
    private static Random RAND;
    @Shadow(remap=false)
    private static EnumFacing tile_side;
    @Unique
    private static int eaglemixins$currSubchunk;

    @Shadow(remap=false)
    private static BlockPos newRandomOffsetPos() {
        return new BlockPos(0, 0, 0);
    }

    @Shadow(remap=false)
    private static void spawnFeralGhoul(World world, EntityLiving entityLiving) {
    }

    @Shadow(remap=false)
    private static BlockPos newRandomPosInChunk(Chunk chunk) {
        return new BlockPos(0, 0, 0);
    }

    @Shadow(remap=false)
    private static void mutateTerrain(World world, Chunk chunk, double radiation) {
    }

    @Shadow(remap=false)
    private static Chunk getRandomAdjacentChunk(ChunkProviderServer chunkProvider, Chunk chunk) {
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    @SubscribeEvent
    @Overwrite(remap=false)
    public void updateWorldRadiation(TickEvent.WorldTickEvent event) {
        Chunk chunk;
        int i;
        String randomStructure;
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.phase != TickEvent.Phase.START || event.side == Side.CLIENT || !(event.world instanceof WorldServer)) {
            return;
        }
        WorldServer world = (WorldServer)event.world;
        ChunkProviderServer chunkProvider = world.func_72863_F();
        Collection loadedChunks = chunkProvider.func_189548_a();
        int chunkArrSize = loadedChunks.size();
        Chunk[] chunkArray = loadedChunks.toArray(new Chunk[chunkArrSize]);
        int chunkStart = RAND.nextInt(chunkArrSize + 1);
        int chunksPerTick = Math.min(NCConfig.radiation_world_chunks_per_tick, chunkArrSize);
        int tickMult = chunkArrSize > 0 ? Math.max(1, chunkArrSize / chunksPerTick) : 1;
        BiomeProvider biomeProvider = world.func_72959_q();
        int dimension = world.field_73011_w.getDimension();
        BlockPos randomOffsetPos = RadiationHandlerMixin.newRandomOffsetPos();
        String string = randomStructure = ModCheck.cubicChunksLoaded() || RadStructures.STRUCTURE_LIST.isEmpty() ? null : (String)RadStructures.STRUCTURE_LIST.get(RAND.nextInt(RadStructures.STRUCTURE_LIST.size()));
        if (chunkArrSize > 0) {
            for (i = chunkStart; i < chunkStart + chunksPerTick; ++i) {
                int packed;
                Double structureRadiation;
                Double biomeRadiation;
                int subchunk;
                chunk = chunkArray[i % chunkArrSize];
                Biome biomeAtOffset = chunk.func_177411_a(randomOffsetPos, biomeProvider);
                if (!chunk.func_177410_o()) continue;
                IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk);
                if (!(chunkSource instanceof ChunkRadiationSource)) {
                    return;
                }
                ChunkRadiationSource chunkRadSource = (ChunkRadiationSource)chunkSource;
                for (subchunk = 0; subchunk < chunk.func_177429_s().length; ++subchunk) {
                    ClassInheritanceMultiMap entitySubset = chunk.func_177429_s()[subchunk];
                    Entity[] entityArray = (Entity[])entitySubset.toArray((Object[])new Entity[0]);
                    chunkRadSource.setSubchunk(subchunk);
                    Entity[] entityArray2 = entityArray;
                    int n = entityArray2.length;
                    for (int j = 0; j < n; ++j) {
                        EntityLiving entityLiving;
                        IEntityRads entityRads;
                        Entity entity = entityArray2[j];
                        if (entity instanceof EntityPlayer) {
                            RadiationHelper.transferRadsFromInventoryToChunkBuffer((InventoryPlayer)((EntityPlayer)entity).field_71071_by, (IRadiationSource)chunkSource);
                            continue;
                        }
                        if (NCConfig.radiation_dropped_items && entity instanceof EntityItem) {
                            RadiationHelper.transferRadiationFromStackToChunkBuffer((ItemStack)((EntityItem)entity).func_92059_d(), (IRadiationSource)chunkSource, (double)1.0);
                            continue;
                        }
                        if (!(entity instanceof EntityLiving) || (entityRads = RadiationHelper.getEntityRadiation((EntityLivingBase)(entityLiving = (EntityLiving)entity))) == null) continue;
                        entityRads.setExternalRadiationResistance(RadiationHelper.getEntityArmorRadResistance((EntityLivingBase)entityLiving));
                        if (NCConfig.radiation_entity_decay_rate > 0.0) {
                            entityRads.setTotalRads(entityRads.getTotalRads() * Math.pow(1.0 - NCConfig.radiation_entity_decay_rate, tickMult), false);
                        }
                        RadiationHelper.transferRadsFromSourceToEntity((IRadiationSource)chunkSource, (IEntityRads)entityRads, (EntityLivingBase)entityLiving, (int)tickMult);
                        if (entityRads.getPoisonBuffer() > 0.0) {
                            double poisonRads = Math.min(entityRads.getPoisonBuffer(), entityRads.getRecentPoisonAddition() * (double)tickMult / NCConfig.radiation_poison_time);
                            entityRads.setTotalRads(entityRads.getTotalRads() + poisonRads, false);
                            entityRads.setPoisonBuffer(entityRads.getPoisonBuffer() - poisonRads);
                            if (entityRads.getPoisonBuffer() == 0.0) {
                                entityRads.resetRecentPoisonAddition();
                            }
                        } else {
                            entityRads.resetRecentPoisonAddition();
                        }
                        if (entityLiving instanceof IMob) {
                            RadiationHelper.applyPotionEffects((EntityLivingBase)entityLiving, (IEntityRads)entityRads, (List)RadPotionEffects.MOB_RAD_LEVEL_LIST, (List)RadPotionEffects.MOB_EFFECTS_LIST);
                        } else if (entityRads.isFatal()) {
                            if (NCConfig.entity_register[0] && entityLiving instanceof INpc) {
                                RadiationHandlerMixin.spawnFeralGhoul((World)world, entityLiving);
                            } else {
                                entityLiving.func_70097_a(DamageSources.FATAL_RADS, Float.MAX_VALUE);
                            }
                        } else {
                            RadiationHelper.applyPotionEffects((EntityLivingBase)entityLiving, (IEntityRads)entityRads, (List)RadPotionEffects.ENTITY_RAD_LEVEL_LIST, (List)RadPotionEffects.ENTITY_DEBUFF_LIST);
                        }
                        entityRads.setRadiationLevel(entityRads.getRadiationLevel() * Math.pow(1.0 - NCConfig.radiation_decay_rate, tickMult));
                    }
                }
                chunkRadSource.resetSubchunk();
                for (subchunk = 0; subchunk < 16; ++subchunk) {
                    chunkRadSource.setSubchunkScrubbingFraction(subchunk, 0.0f);
                    chunkRadSource.setSubchunkEffectiveScrubberCount(subchunk, 0.0f);
                }
                Collection tileCollection = chunk.func_177434_r().values();
                TileEntity[] tileArray = tileCollection.toArray(new TileEntity[0]);
                for (Entity tile : tileArray) {
                    chunkRadSource.setSubchunk(tile.func_174877_v());
                    RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)tile, (EnumFacing)tile_side, (IRadiationSource)chunkSource);
                }
                chunkRadSource.resetSubchunk();
                if (RadWorlds.RAD_MAP.containsKey(dimension)) {
                    for (int subchunk2 = 0; subchunk2 < 16; ++subchunk2) {
                        chunkRadSource.setSubchunk(subchunk2);
                        RadiationHelper.addToSourceBuffer((IRadiationSource)chunkSource, (double)((Double)RadWorlds.RAD_MAP.get(dimension)));
                    }
                }
                chunkRadSource.resetSubchunk();
                if (!RadBiomes.DIM_BLACKLIST.contains(dimension) && (biomeRadiation = (Double)RadBiomes.RAD_MAP.get(biomeAtOffset)) != null) {
                    for (int subchunk3 = 0; subchunk3 < 16; ++subchunk3) {
                        ExtendedBlockStorage storage = chunk.func_76587_i()[subchunk3];
                        if (storage == null || storage.func_76663_a()) continue;
                        chunkRadSource.setSubchunk(subchunk3);
                        RadiationHelper.addToSourceBuffer((IRadiationSource)chunkSource, (double)biomeRadiation);
                    }
                }
                chunkRadSource.resetSubchunk();
                BlockPos randomChunkPos = RadiationHandlerMixin.newRandomPosInChunk(chunk);
                eaglemixins$currSubchunk = randomChunkPos.func_177956_o() >> 4;
                chunkRadSource.setSubchunk(randomChunkPos);
                if (randomStructure != null && StructureHelper.CACHE.isInStructure((World)world, randomStructure, randomChunkPos) && (structureRadiation = (Double)RadStructures.RAD_MAP.get(randomStructure)) != null) {
                    RadiationHelper.addToSourceBuffer((IRadiationSource)chunkSource, (double)structureRadiation);
                }
                if (NCConfig.radiation_check_blocks && i == chunkStart && RadSources.STACK_MAP.containsKey(packed = RecipeItemHelper.func_194113_b((ItemStack)ItemStackHelper.blockStateToStack((IBlockState)world.func_180495_p(randomChunkPos))))) {
                    RadiationHelper.addToSourceBuffer((IRadiationSource)chunkSource, (double)RadSources.STACK_MAP.get(packed));
                }
                chunkRadSource.resetSubchunk();
                for (TileEntity tile : tileCollection) {
                    if (!(tile instanceof ITileRadiationEnvironment)) continue;
                    ITileRadiationEnvironment tileRad = (ITileRadiationEnvironment)tile;
                    int subchunkIndex = MathHelper.func_76125_a((int)(tile.func_174877_v().func_177956_o() >> 4), (int)0, (int)15);
                    tileRad.setCurrentChunkRadiationLevel((double)chunkRadSource.getSubchunkRadiationLevel(subchunkIndex));
                    tileRad.setCurrentChunkRadiationBuffer((double)chunkRadSource.getSubchunkRadiationBuffer(subchunkIndex));
                    chunkRadSource.setSubchunk(subchunkIndex);
                    RadiationHelper.addScrubbingFractionToChunk((IRadiationSource)chunkSource, (ITileRadiationEnvironment)tileRad);
                    chunkRadSource.resetSubchunk();
                }
                for (int subchunk4 = 0; subchunk4 < 16; ++subchunk4) {
                    ExtendedBlockStorage storage;
                    chunkRadSource.setSubchunk(subchunk4);
                    if (NCConfig.radiation_scrubber_alt) {
                        double scrubbers = chunkSource.getEffectiveScrubberCount();
                        double scrubbingFraction = RadiationHelper.getAltScrubbingFraction((double)scrubbers);
                        RadiationHelper.addToSourceBuffer((IRadiationSource)chunkSource, (double)(-scrubbingFraction * chunkSource.getRadiationBuffer()));
                        chunkSource.setScrubbingFraction(scrubbingFraction);
                    }
                    double changeRate = chunkSource.getRadiationLevel() < chunkSource.getRadiationBuffer() ? NCConfig.radiation_spread_rate : NCConfig.radiation_decay_rate * (1.0 - chunkSource.getScrubbingFraction()) + NCConfig.radiation_spread_rate * chunkSource.getScrubbingFraction();
                    double newLevel = Math.max(0.0, chunkSource.getRadiationLevel() + (chunkSource.getRadiationBuffer() - chunkSource.getRadiationLevel()) * changeRate);
                    if (NCConfig.radiation_chunk_limit >= 0.0) {
                        newLevel = Math.min(newLevel, NCConfig.radiation_chunk_limit);
                    }
                    if (!RadBiomes.LIMIT_MAP.isEmpty() && RadBiomes.LIMIT_MAP.containsKey(biomeAtOffset) && (storage = chunk.func_76587_i()[subchunk4]) != null && !storage.func_76663_a()) {
                        newLevel = Math.min(newLevel, (Double)RadBiomes.LIMIT_MAP.get(biomeAtOffset));
                    }
                    if (!RadWorlds.LIMIT_MAP.isEmpty() && RadWorlds.LIMIT_MAP.containsKey(dimension)) {
                        newLevel = Math.min(newLevel, (Double)RadWorlds.LIMIT_MAP.get(dimension));
                    }
                    chunkSource.setRadiationLevel(newLevel);
                    if (eaglemixins$currSubchunk == subchunk4) {
                        RadiationHandlerMixin.mutateTerrain((World)world, chunk, newLevel);
                    }
                    chunkRadSource.resetSubchunk();
                }
            }
        }
        if (chunkArrSize > 0) {
            for (i = chunkStart; i < chunkStart + chunksPerTick; ++i) {
                chunk = chunkArray[i % chunkArrSize];
                RadiationHandlerMixin.eaglemixins$spreadRadiationInSubchunks(chunk);
                RadiationHelper.spreadRadiationFromChunk((Chunk)chunk, (Chunk)RadiationHandlerMixin.getRandomAdjacentChunk(chunkProvider, chunk));
            }
        }
        tile_side = EnumFacing.func_82600_a((int)(tile_side.func_176745_a() + 1));
        for (EntityPlayer player : world.field_73010_i) {
            if (player.field_70173_aa % 60 != 0) continue;
            PacketHandler.sendTo(new PacketSyncHighRadiation(player), (EntityPlayerMP)player);
        }
    }

    @Unique
    private static void eaglemixins$spreadRadiationInSubchunks(Chunk chunk) {
        int subchunk;
        if (chunk == null || !chunk.func_177410_o()) {
            return;
        }
        IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk);
        if (!(chunkSource instanceof ChunkRadiationSource)) {
            return;
        }
        ChunkRadiationSource chunkRadSource = (ChunkRadiationSource)chunkSource;
        float[] dRad = new float[16];
        Arrays.fill(dRad, 0.0f);
        for (subchunk = 0; subchunk < 16; ++subchunk) {
            chunkRadSource.setSubchunk(subchunk);
            if (chunkSource.isRadiationNegligible()) continue;
            float radLvlCurr = chunkRadSource.getSubchunkRadiationLevel(subchunk);
            for (int dSubchunk = -1; dSubchunk <= 1; dSubchunk += 2) {
                float radLvlNext;
                int nextsubchunk = subchunk + dSubchunk;
                if (nextsubchunk < 0 || nextsubchunk > 15 || (radLvlNext = chunkRadSource.getSubchunkRadiationLevel(nextsubchunk)) != 0.0f && !(radLvlCurr / radLvlNext > 1.0f + ForgeConfigHandler.nuclear.radiation_spread_gradient_vertical)) continue;
                float radiationSpread = (radLvlCurr - radLvlNext) * (float)NCConfig.radiation_spread_rate;
                int n = subchunk;
                dRad[n] = dRad[n] - radiationSpread;
                int n2 = nextsubchunk;
                dRad[n2] = dRad[n2] + radiationSpread * (1.0f - chunkRadSource.getSubchunkScrubbingFraction(nextsubchunk));
            }
        }
        for (subchunk = 0; subchunk < 16; ++subchunk) {
            chunkRadSource.setSubchunkRadiationLevel(subchunk, chunkRadSource.getSubchunkRadiationLevel(subchunk) + dRad[subchunk]);
        }
        chunkRadSource.resetSubchunk();
    }

    @Unique
    private static BlockPos eaglemixins$newRandomPosInSubChunk(Chunk chunk, int subchunk) {
        return chunk.func_76632_l().func_180331_a(RAND.nextInt(16), (subchunk << 4) + RAND.nextInt(16), RAND.nextInt(16));
    }

    @WrapOperation(method={"mutateTerrain"}, at={@At(value="INVOKE", target="Lnc/radiation/RadiationHandler;newRandomPosInChunk(Lnet/minecraft/world/chunk/Chunk;)Lnet/minecraft/util/math/BlockPos;")}, remap=false)
    private static BlockPos eaglemixins_setRandomPosInChunk(Chunk chunk, Operation<BlockPos> original) {
        return RadiationHandlerMixin.eaglemixins$newRandomPosInSubChunk(chunk, eaglemixins$currSubchunk);
    }

    static {
        eaglemixins$currSubchunk = 0;
    }
}

