/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.mixin.nuclearcraft;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import eaglemixins.EagleMixins;
import eaglemixins.config.ForgeConfigHandler;
import java.util.function.Function;
import nc.capability.radiation.entity.IEntityRads;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import net.mcft.copy.backpacks.api.BackpackHelper;
import net.mcft.copy.backpacks.api.IBackpack;
import net.mcft.copy.backpacks.api.IBackpackData;
import net.mcft.copy.backpacks.misc.BackpackDataItems;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import svenhjol.charm.crafting.feature.Crate;
import svenhjol.charm.crafting.tile.TileCrate;

@Mixin(value={RadiationHelper.class})
public abstract class RadiationHelper_IrradiatedSubInventories {
    @Unique
    private static Item eaglemixins$crateItem = null;
    @Unique
    private static Item eaglemixins$sealedCrateItem = null;

    @Shadow(remap=false)
    private static double transferRadsFromStackToPlayer(ItemStack stack, IEntityRads playerRads, EntityPlayer player, int updateRate) {
        EagleMixins.LOGGER.warn("EagleMixins shadowing RadiationHelper.transferRadsFromStackToPlayer failed!");
        return 0.0;
    }

    @Unique
    private static double eagleMixins$applyOperationOnIInventory(IInventory inv, Function<ItemStack, Double> radsFunction, boolean alsoCheckSubInventories) {
        double addedRads = 0.0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack innerStack = inv.func_70301_a(i);
            if (innerStack.func_190926_b()) continue;
            addedRads += radsFunction.apply(innerStack).doubleValue();
            if (!alsoCheckSubInventories) continue;
            addedRads += RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnSubInventory(innerStack, radsFunction);
        }
        return addedRads;
    }

    @Unique
    private static double eagleMixins$applyOperationOnSubInventory(ItemStack stack, Function<ItemStack, Double> radsFunction) {
        TileEntity containedTile;
        Item item;
        boolean isShulker;
        if (eaglemixins$crateItem == null) {
            eaglemixins$crateItem = ItemShulkerBox.func_150898_a((Block)Crate.crate);
        }
        if (eaglemixins$sealedCrateItem == null) {
            eaglemixins$sealedCrateItem = ItemShulkerBox.func_150898_a((Block)Crate.crateSealed);
        }
        if (!(isShulker = (item = stack.func_77973_b()) instanceof ItemShulkerBox) && item != eaglemixins$crateItem && item != eaglemixins$sealedCrateItem) {
            return 0.0;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null || !tags.func_150297_b("BlockEntityTag", 10)) {
            return 0.0;
        }
        NBTTagCompound inventoryTags = tags.func_74775_l("BlockEntityTag");
        if (!inventoryTags.func_150297_b("id", 8)) {
            inventoryTags = inventoryTags.func_74737_b();
            inventoryTags.func_74778_a("id", isShulker ? "minecraft:shulker_box" : "charm:crate");
        }
        try {
            containedTile = TileEntity.func_190200_a(null, (NBTTagCompound)inventoryTags);
            if (containedTile == null) {
                return 0.0;
            }
        }
        catch (Exception e) {
            return 0.0;
        }
        double addedRads = 0.0;
        if (containedTile instanceof IInventory) {
            addedRads = RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnIInventory((IInventory)containedTile, radsFunction, false);
        } else if (containedTile instanceof TileCrate) {
            for (int i = 0; i < ((TileCrate)containedTile).getInventorySize(); ++i) {
                ItemStack innerStack = ((TileCrate)containedTile).getInventory().getStackInSlot(i);
                if (innerStack.func_190926_b()) continue;
                addedRads += radsFunction.apply(innerStack).doubleValue();
            }
        }
        return addedRads;
    }

    @Unique
    private static double eagleMixins$applyOperationOnBackpack(EntityPlayer player, Function<ItemStack, Double> radsFunction, boolean alsoCheckSubInventories) {
        IBackpack cap = BackpackHelper.getBackpack((Entity)player);
        if (cap == null) {
            return 0.0;
        }
        IBackpackData data = cap.getData();
        if (!(data instanceof BackpackDataItems)) {
            return 0.0;
        }
        ItemStackHandler handler = ((BackpackDataItems)data).getItems();
        if (handler == null) {
            return 0.0;
        }
        double addedRads = 0.0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            addedRads += radsFunction.apply(stack).doubleValue();
            if (!alsoCheckSubInventories) continue;
            addedRads += RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnSubInventory(stack, radsFunction);
        }
        return addedRads;
    }

    @Unique
    private static double eagleMixins$applyOperationOnEnderChest(EntityPlayer player, Function<ItemStack, Double> radsFunction, boolean alsoCheckSubInventories) {
        if (!(player.field_71070_bA instanceof ContainerChest)) {
            return 0.0;
        }
        ContainerChest chest = (ContainerChest)player.field_71070_bA;
        if (!(chest.func_85151_d() instanceof InventoryEnderChest)) {
            return 0.0;
        }
        InventoryEnderChest enderInventory = (InventoryEnderChest)chest.func_85151_d();
        return RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnIInventory((IInventory)enderInventory, radsFunction, alsoCheckSubInventories);
    }

    @Unique
    private static double eagleMixins$applyOperationOnCraftingInventory(EntityPlayer player, Function<ItemStack, Double> radsFunction, boolean alsoCheckSubInventories) {
        if (!(player.field_71070_bA instanceof ContainerPlayer)) {
            return 0.0;
        }
        InventoryCrafting invCrafting = ((ContainerPlayer)player.field_71070_bA).field_75181_e;
        return RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnIInventory((IInventory)invCrafting, radsFunction, alsoCheckSubInventories);
    }

    @WrapOperation(method={"transferRadsFromInventoryToChunkBuffer"}, at={@At(value="INVOKE", target="Lnc/radiation/RadiationHelper;transferRadiationFromProviderToChunkBuffer(Lnet/minecraftforge/common/capabilities/ICapabilityProvider;Lnet/minecraft/util/EnumFacing;Lnc/capability/radiation/source/IRadiationSource;)V")}, remap=false)
    private static void eagleMixins_useRadiationInShulkers_toChunk(ICapabilityProvider provider, EnumFacing side, IRadiationSource chunkSource, Operation<Void> original, InventoryPlayer inventory) {
        original.call(new Object[]{provider, side, chunkSource});
        RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnSubInventory((ItemStack)provider, subStack -> {
            original.call(new Object[]{subStack, side, chunkSource});
            return 0.0;
        });
    }

    @Inject(method={"transferRadsFromInventoryToChunkBuffer"}, at={@At(value="TAIL")}, remap=false)
    private static void eagleMixins_useRadiationInBackpack_toChunk(InventoryPlayer inventory, IRadiationSource chunkSource, CallbackInfo ci) {
        if (!NCConfig.radiation_hardcore_stacks) {
            return;
        }
        Function<ItemStack, Double> transferRadsToChunkFunction = subStack -> {
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)subStack, null, (IRadiationSource)chunkSource);
            return 0.0;
        };
        if (ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("backpack")) {
            RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnBackpack(inventory.field_70458_d, transferRadsToChunkFunction, ForgeConfigHandler.nuclear.inventoryRadiation.get("backpack"));
        }
        if (!inventory.func_70445_o().func_190926_b() && ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("mouseItem")) {
            RadiationHelper.transferRadiationFromProviderToChunkBuffer((ICapabilityProvider)inventory.func_70445_o(), null, (IRadiationSource)chunkSource);
            if (ForgeConfigHandler.nuclear.inventoryRadiation.get("mouseItem").booleanValue()) {
                RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnSubInventory(inventory.func_70445_o(), transferRadsToChunkFunction);
            }
        }
        if (ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("enderChest")) {
            RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnEnderChest(inventory.field_70458_d, transferRadsToChunkFunction, ForgeConfigHandler.nuclear.inventoryRadiation.get("enderChest"));
        }
        if (ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("inventoryCrafting")) {
            RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnCraftingInventory(inventory.field_70458_d, transferRadsToChunkFunction, ForgeConfigHandler.nuclear.inventoryRadiation.get("inventoryCrafting"));
        }
    }

    @WrapOperation(method={"transferRadiationFromStackToChunkBuffer"}, at={@At(value="INVOKE", target="Lnc/radiation/RadiationHelper;addToSourceBuffer(Lnc/capability/radiation/source/IRadiationSource;D)V")}, remap=false)
    private static void eagleMixins_useRadiationInShulkers_fromEntityItemToChunk(IRadiationSource chunkSource, double addedRadiation, Operation<Void> original, ItemStack stack, IRadiationSource unused, double multiplier) {
        original.call(new Object[]{chunkSource, addedRadiation});
        if (!ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("itemEntity")) {
            return;
        }
        if (!ForgeConfigHandler.nuclear.inventoryRadiation.get("itemEntity").booleanValue()) {
            return;
        }
        RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnSubInventory(stack, subStack -> {
            original.call(new Object[]{chunkSource, RadiationHelper.getRadiationFromStack((ItemStack)subStack, (double)multiplier)});
            return 0.0;
        });
    }

    @WrapOperation(method={"transferRadsFromInventoryToPlayer"}, at={@At(value="INVOKE", target="Lnc/radiation/RadiationHelper;transferRadsFromStackToPlayer(Lnet/minecraft/item/ItemStack;Lnc/capability/radiation/entity/IEntityRads;Lnet/minecraft/entity/player/EntityPlayer;I)D")}, remap=false)
    private static double eagleMixins_useRadiationInShulkers_toPlayer(ItemStack checkedStack, IEntityRads playerRads, EntityPlayer player, int updateRate, Operation<Double> original) {
        double originalRads = (Double)original.call(new Object[]{checkedStack, playerRads, player, updateRate});
        double addedRads = RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnSubInventory(checkedStack, subStack -> (Double)original.call(new Object[]{subStack, playerRads, player, updateRate}));
        return originalRads + addedRads;
    }

    @ModifyReturnValue(method={"transferRadsFromInventoryToPlayer"}, at={@At(value="TAIL")}, remap=false)
    private static double eagleMixins_useRadiationInBackpack_toPlayer(double original, IEntityRads playerRads, EntityPlayer player, int updateRate) {
        Function<ItemStack, Double> transferRadsToPlayerFunction = subStack -> RadiationHelper_IrradiatedSubInventories.transferRadsFromStackToPlayer(subStack, playerRads, player, updateRate);
        if (ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("backpack")) {
            original += RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnBackpack(player, transferRadsToPlayerFunction, ForgeConfigHandler.nuclear.inventoryRadiation.get("backpack"));
        }
        if (!player.field_71071_by.func_70445_o().func_190926_b() && ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("mouseItem")) {
            original += RadiationHelper_IrradiatedSubInventories.transferRadsFromStackToPlayer(player.field_71071_by.func_70445_o(), playerRads, player, updateRate);
            if (ForgeConfigHandler.nuclear.inventoryRadiation.get("mouseItem").booleanValue()) {
                original += RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnSubInventory(player.field_71071_by.func_70445_o(), transferRadsToPlayerFunction);
            }
        }
        if (ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("enderChest")) {
            original += RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnEnderChest(player, transferRadsToPlayerFunction, ForgeConfigHandler.nuclear.inventoryRadiation.get("enderChest"));
        }
        if (ForgeConfigHandler.nuclear.inventoryRadiation.containsKey("inventoryCrafting")) {
            original += RadiationHelper_IrradiatedSubInventories.eagleMixins$applyOperationOnCraftingInventory(player, transferRadsToPlayerFunction, ForgeConfigHandler.nuclear.inventoryRadiation.get("inventoryCrafting"));
        }
        return original;
    }
}

