/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.mixin.nuclearcraft;

import nc.config.NCConfig;
import nc.recipe.vanilla.recipe.ShapelessArmorRadShieldingRecipe;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShapelessArmorRadShieldingRecipe.class})
public abstract class MixinRadShielding {
    @Inject(method={"matches"}, at={@At(value="HEAD")}, cancellable=true)
    public void eaglemixins_allowDamagedArmorUpgradeOnly(InventoryCrafting inv, World worldIn, CallbackInfoReturnable<Boolean> cir) {
        ItemStack armor = ItemStack.field_190927_a;
        ItemStack shielding = ItemStack.field_190927_a;
        int nonEmptyCount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (++nonEmptyCount > 2) {
                cir.setReturnValue((Object)false);
                return;
            }
            Item item = stack.func_77973_b();
            if (item instanceof ItemArmor) {
                armor = stack;
                continue;
            }
            if (item.getRegistryName() == null || !item.getRegistryName().func_110623_a().equals("rad_shielding")) continue;
            shielding = stack;
        }
        if (!armor.func_190926_b() && !shielding.func_190926_b()) {
            double newResistance = NCConfig.radiation_shielding_level[shielding.func_77960_j() > 2 ? 0 : shielding.func_77960_j()];
            double currentResistance = 0.0;
            NBTTagCompound tags = armor.func_77978_p();
            if (tags != null) {
                currentResistance = tags.func_74769_h("ncRadiationResistance");
            }
            cir.setReturnValue((Object)(newResistance > currentResistance ? 1 : 0));
        }
    }

    @Inject(method={"getCraftingResult"}, at={@At(value="HEAD")}, cancellable=true)
    public void eaglemixins_preserveNBT(InventoryCrafting inv, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack armor = ItemStack.field_190927_a;
        ItemStack shielding = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (item instanceof ItemArmor) {
                armor = stack;
                continue;
            }
            if (item.getRegistryName() == null || !item.getRegistryName().func_110623_a().equals("rad_shielding")) continue;
            shielding = stack;
        }
        if (!armor.func_190926_b() && !shielding.func_190926_b()) {
            double resistance = NCConfig.radiation_shielding_level[shielding.func_77960_j() > 2 ? 0 : shielding.func_77960_j()];
            ItemStack result = armor.func_77946_l();
            result.func_190920_e(1);
            result.func_77964_b(armor.func_77952_i());
            NBTTagCompound tag = result.func_77942_o() ? result.func_77978_p().func_74737_b() : new NBTTagCompound();
            tag.func_74780_a("ncRadiationResistance", resistance);
            result.func_77982_d(tag);
            cir.setReturnValue((Object)result);
        }
    }
}

