/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.mixin.nuclearcraft;

import com.llamalad7.mixinextras.sugar.Local;
import eaglemixins.capability.ChunkRadiationSource;
import eaglemixins.config.ForgeConfigHandler;
import java.util.Random;
import nc.capability.radiation.source.IRadiationSource;
import nc.radiation.RadSources;
import nc.radiation.RadiationHelper;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockFluidClassic.class})
public abstract class MixinBlockFluidClassicRadiation
extends BlockFluidBase {
    public MixinBlockFluidClassicRadiation(Fluid fluid, Material material, MapColor mapColor) {
        super(fluid, material, mapColor);
    }

    @Inject(method={"updateTick"}, at={@At(value="TAIL")})
    private void eagleMixins$radiateConfiguredFluids(World world, BlockPos pos, IBlockState state, Random rand, CallbackInfo ci, @Local(name={"quantaRemaining"}) int quantaRemaining) {
        String fluidName;
        if (world.field_72995_K) {
            return;
        }
        Fluid fluid = this.getFluid();
        String string = fluidName = fluid != null ? fluid.getName() : null;
        if (fluidName == null || fluidName.equals("corium")) {
            return;
        }
        double basePerTick = RadSources.FLUID_MAP.getDouble((Object)fluidName) / 6.944444444444445;
        if (basePerTick <= 0.0) {
            return;
        }
        double radsPerTick = basePerTick * (double)quantaRemaining;
        if (radsPerTick <= 0.0) {
            return;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (!chunk.func_177410_o()) {
            return;
        }
        IRadiationSource src = RadiationHelper.getRadiationSource((ICapabilityProvider)chunk);
        if (ForgeConfigHandler.mixintoggles.subchunkRadiation && src instanceof ChunkRadiationSource) {
            ChunkRadiationSource chunkRadSource = (ChunkRadiationSource)src;
            chunkRadSource.setSubchunk(pos);
            RadiationHelper.addToSourceRadiation((IRadiationSource)src, (double)radsPerTick);
            chunkRadSource.resetSubchunk();
        } else {
            RadiationHelper.addToSourceRadiation((IRadiationSource)src, (double)radsPerTick);
        }
    }
}

