/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.mixin.loadingscreens;

import com.bloodnbonesgaming.loadingscreens.client.LoadingScreenHandler;
import com.bloodnbonesgaming.loadingscreens.client.gui.GuiElementBase;
import eaglemixins.EagleMixins;
import eaglemixins.config.ForgeConfigHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LoadingScreenHandler.class})
public class LoadingScreenHandlerMixin {
    @Shadow(remap=false)
    private boolean setup;
    @Shadow(remap=false)
    private List<GuiElementBase> elements;
    @Unique
    long lastTime = 0L;
    @Unique
    long currentTime = 0L;
    @Unique
    int currentScreenId = 0;
    @Unique
    List<Integer> screenIdOrder = null;

    @Shadow(remap=false)
    public void setup(Minecraft minecraft) {
        EagleMixins.LOGGER.info("EagleMixins LoadingScreens Mixin: Failed to apply shadow setup()");
    }

    @Overwrite(remap=false)
    public void renderScreen(Minecraft minecraft, int width, int height) {
        if (!this.setup) {
            this.setup(minecraft);
            this.setup = true;
        }
        long sysTime = System.currentTimeMillis();
        if (this.screenIdOrder == null || sysTime - this.lastTime > 120000L) {
            this.screenIdOrder = new ArrayList<Integer>();
            for (int i = 0; i < this.elements.size(); ++i) {
                this.screenIdOrder.add(i);
            }
            if (ForgeConfigHandler.client.randomOrder) {
                Collections.shuffle(this.screenIdOrder);
            }
        }
        this.currentTime = sysTime - this.lastTime;
        this.lastTime = sysTime;
        if (this.currentTime > (long)ForgeConfigHandler.client.frequency * 1000L) {
            this.currentTime -= (long)ForgeConfigHandler.client.frequency * 1000L;
            ++this.currentScreenId;
        }
        if (this.currentScreenId >= this.elements.size()) {
            this.currentScreenId = 0;
        }
        int randomisedIndex = ForgeConfigHandler.client.disableCycling ? this.screenIdOrder.get(0).intValue() : this.screenIdOrder.get(this.currentScreenId).intValue();
        GuiElementBase element = this.elements.get(randomisedIndex);
        GlStateManager.func_179141_d();
        element.render(Minecraft.func_71410_x(), width, height);
        GlStateManager.func_179118_c();
    }
}

