/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.init;

import eaglemixins.EagleMixins;
import eaglemixins.config.ForgeConfigHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public final class RadiationResistanceRegistry {
    private static final Map<ResourceLocation, Double> MAP = new HashMap<ResourceLocation, Double>();

    public static void reloadFromConfig() {
        MAP.clear();
        if (ForgeConfigHandler.nuclear.radiationResistanceList == null) {
            EagleMixins.LOGGER.info("[EagleMixins] Radiation Immunity list empty, nothing loaded");
            return;
        }
        for (String raw : ForgeConfigHandler.nuclear.radiationResistanceList) {
            String s;
            if (raw == null || (s = raw.trim()).isEmpty()) continue;
            int sep = s.lastIndexOf(61);
            if (sep < 0) {
                sep = s.lastIndexOf(95);
            }
            if (sep <= 0 || sep >= s.length() - 1) {
                EagleMixins.LOGGER.error("[EagleMixins] RadRes Invalid entry '{}', expected <id>=<val> or <id>_<val>", (Object)s);
                continue;
            }
            String idStr = s.substring(0, sep).trim();
            String valStr = s.substring(sep + 1).trim();
            try {
                ResourceLocation id = new ResourceLocation(idStr);
                double val = Double.parseDouble(valStr);
                MAP.put(id, val);
            }
            catch (Exception e) {
                EagleMixins.LOGGER.error("[EagleMixins] RadRes Failed to parse '{}': {}", (Object)s, (Object)e.toString());
            }
        }
        EagleMixins.LOGGER.info("[EagleMixins] RadRes Loaded {} entity resistance override(s)", (Object)MAP.size());
    }

    public static double get(ResourceLocation id) {
        return MAP.getOrDefault(id, 0.0);
    }
}

