/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import com.google.common.collect.Lists;
import eaglemixins.util.LootTableSetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.blay09.mods.cookingforblockheads.tile.TileCounter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TileCounterHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getUseBlock() == Event.Result.DENY || event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_175149_v()) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCounter) {
            TileCounterHandler.fillCounterWithLoot(world, (TileCounter)tile, player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player.func_175149_v()) {
            return;
        }
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCounter) {
            TileCounterHandler.fillCounterWithLoot(world, (TileCounter)tile, player);
        }
    }

    private static void fillCounterWithLoot(World world, TileCounter counter, EntityPlayer player) {
        ResourceLocation lootTable = ((ILootContainer)counter).func_184276_b();
        if (lootTable != null) {
            LootTable loottable = world.func_184146_ak().func_186521_a(lootTable);
            Random random = new Random();
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)world);
            if (player != null) {
                lootcontext$builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            List stacks = loottable.func_186462_a(random, lootcontext$builder.func_186471_a());
            List<Integer> emptySlots = TileCounterHandler.getEmptySlotsRandomized(counter, random);
            for (ItemStack stack : stacks) {
                if (emptySlots.isEmpty()) break;
                if (stack.func_190926_b()) {
                    counter.getItemHandler().insertItem(emptySlots.remove(emptySlots.size() - 1).intValue(), ItemStack.field_190927_a, false);
                    continue;
                }
                counter.getItemHandler().insertItem(emptySlots.remove(emptySlots.size() - 1).intValue(), stack, false);
            }
            ((LootTableSetter)counter).eaglemixins$setLootTable(null);
            counter.func_70296_d();
            BlockPos p = counter.func_174877_v();
            world.func_184138_a(p, world.func_180495_p(p), world.func_180495_p(p), 3);
        }
    }

    private static List<Integer> getEmptySlotsRandomized(TileCounter counter, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < counter.getItemHandler().getSlots(); ++i) {
            if (!counter.getItemHandler().getStackInSlot(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }
}

