/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.init.ModStats;
import eaglemixins.network.PacketHandler;
import eaglemixins.network.PacketStartTeleportOverlay;
import eaglemixins.potion.PotionTeleportationSickness;
import eaglemixins.teleport.TeleportData;
import eaglemixins.teleport.TeleportRegistry;
import eaglemixins.teleport.TeleportService;
import eaglemixins.teleport.TeleportUnderneath;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TeleportEvents {
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        TeleportService.onServerTick(e);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.side.isClient() || e.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)e.player;
        NBTTagCompound tag = player.getEntityData().func_74775_l("PlayerPersisted");
        World world = player.field_70170_p;
        TeleportRegistry.ensureInit();
        if (player.field_71093_bK == 3 && tag.func_74764_b("glitchEndTime")) {
            TeleportUnderneath.tryReturn((EntityPlayer)player);
        }
        if (player.func_70660_b((Potion)PotionTeleportationSickness.INSTANCE) != null) {
            return;
        }
        if (!TeleportEvents.isOnEndPortal(world, player.func_180425_c().func_177977_b())) {
            return;
        }
        for (Map.Entry<Integer, TeleportData> entry : TeleportRegistrySnapshot.view().entrySet()) {
            BlockPos returnPos;
            int linkId = entry.getKey();
            TeleportData data = entry.getValue();
            if (data.sender != null && player.func_174818_b(data.sender) <= 36.0) {
                BlockPos blockPos = returnPos = data.receiver != null ? data.receiver : TeleportData.senderApprox(linkId);
                if (TeleportService.onePercent(world.field_73012_v) && data.receiver != null) {
                    TeleportEvents.rememberGlitchReturn((EntityPlayer)player, returnPos);
                    PacketHandler.sendTo(new PacketStartTeleportOverlay(true), player);
                    player.func_71029_a(ModStats.GLITCH_COUNT);
                    TeleportUnderneath.triggerGlitch((EntityPlayer)player);
                    return;
                }
                if (data.receiver != null) {
                    TeleportEvents.teleportLater(player, (double)data.receiver.func_177958_n() + 0.5, data.receiver.func_177956_o() + 2, (double)data.receiver.func_177952_p() + 3.5, true);
                } else {
                    if (data.tempReceiver == null) continue;
                    PacketHandler.sendTo(new PacketStartTeleportOverlay(false), player);
                    BlockPos safe = world.func_175672_r(new BlockPos(data.tempReceiver.func_177958_n(), 0, data.tempReceiver.func_177952_p()));
                    TeleportEvents.teleportLater(player, (double)safe.func_177958_n() + 0.5, safe.func_177956_o(), (double)safe.func_177952_p() + 0.5, false);
                }
                TeleportEvents.markJustTeleported((EntityPlayer)player, linkId);
                return;
            }
            if (data.receiver == null || !(player.func_174818_b(data.receiver) <= 36.0)) continue;
            BlockPos blockPos = returnPos = data.sender != null ? data.sender : TeleportData.receiverApprox(linkId);
            if (TeleportService.onePercent(world.field_73012_v) && data.sender != null) {
                TeleportEvents.rememberGlitchReturn((EntityPlayer)player, returnPos);
                PacketHandler.sendTo(new PacketStartTeleportOverlay(true), player);
                player.func_71029_a(ModStats.GLITCH_COUNT);
                TeleportUnderneath.triggerGlitch((EntityPlayer)player);
                return;
            }
            if (data.sender != null) {
                TeleportEvents.teleportLater(player, (double)data.sender.func_177958_n() + 0.5, data.sender.func_177956_o() + 2, (double)data.sender.func_177952_p() + 3.5, true);
            } else {
                PacketHandler.sendTo(new PacketStartTeleportOverlay(false), player);
                BlockPos approx = TeleportData.senderApprox(linkId);
                BlockPos safe = world.func_175672_r(new BlockPos(approx.func_177958_n(), 0, approx.func_177952_p()));
                TeleportEvents.teleportLater(player, (double)safe.func_177958_n() + 0.5, (double)safe.func_177956_o() + 0.5, (double)safe.func_177952_p() + 0.5, false);
            }
            TeleportEvents.markJustTeleported((EntityPlayer)player, linkId);
            return;
        }
    }

    private static boolean isOnEndPortal(World world, BlockPos basePos) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos checkPos = basePos.func_177982_a(dx, 0, dz);
                Block block = world.func_180495_p(checkPos).func_177230_c();
                if (!(block instanceof BlockEndPortal)) continue;
                return true;
            }
        }
        Block block = world.func_180495_p(basePos.func_177977_b()).func_177230_c();
        return block instanceof BlockEndPortal;
    }

    private static void teleportLater(EntityPlayerMP p, double x, double y, double z, boolean giveSickness) {
        MinecraftServer server = p.func_184102_h();
        if (server != null) {
            server.func_152344_a(() -> {
                p.func_70634_a(x, y, z);
                if (giveSickness) {
                    p.func_70690_d(new PotionEffect((Potion)PotionTeleportationSickness.INSTANCE, 200, 0));
                }
            });
        }
    }

    private static void markJustTeleported(EntityPlayer p, int linkId) {
        NBTTagCompound tag = p.getEntityData().func_74775_l("PlayerPersisted");
        tag.func_74757_a("justTeleported", true);
        tag.func_74768_a("linkId", linkId);
        p.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    private static void rememberGlitchReturn(EntityPlayer p, BlockPos returnPos) {
        NBTTagCompound t = p.getEntityData().func_74775_l("PlayerPersisted");
        t.func_74780_a("glitchReturnX", (double)returnPos.func_177958_n() + 0.5);
        t.func_74780_a("glitchReturnY", (double)(returnPos.func_177956_o() + 2));
        t.func_74780_a("glitchReturnZ", (double)returnPos.func_177952_p() + 3.5);
        t.func_74768_a("glitchOriginDim", p.field_71093_bK);
        p.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)t);
    }

    private static final class TeleportRegistrySnapshot {
        private TeleportRegistrySnapshot() {
        }

        static Map<Integer, TeleportData> view() {
            HashMap<Integer, TeleportData> copy = new HashMap<Integer, TeleportData>();
            for (int id : TeleportData.ALL_IDS) {
                TeleportData d = TeleportRegistry.get(id);
                if (d == null) continue;
                copy.put(id, d);
            }
            return copy;
        }
    }
}

