/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolArmorBase;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolMeleeBase;
import com.dhanantry.scapeandrunparasites.item.tool.WeaponToolRangeBase;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import srpmixins.capability.adaptation.CapabilityAdaptationHandler;
import srpmixins.capability.adaptation.ICapabilityAdaptation;
import srpmixins.config.SRPMixinsConfigHandler;
import svenhjol.charm.world.entity.EntityChargedEmerald;

public class SentientWeaponEvolutionHandler {
    private static final String srpkillsKey = "srpkills";
    private static final Enchantment smeCoP = Enchantment.func_180305_b((String)"somanyenchantments:curseofpossession");
    private static final Random rand = new Random();

    private static boolean isSRPLivingGear(Item item) {
        if (!(item instanceof WeaponToolMeleeBase || item instanceof WeaponToolArmorBase || item instanceof WeaponToolRangeBase)) {
            return false;
        }
        ResourceLocation itemReg = item.getRegistryName();
        return itemReg != null && !itemReg.func_110623_a().contains("sentient");
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null || victim.field_70170_p.field_72995_K) {
            return;
        }
        if (!(victim instanceof EntityParasiteBase)) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
        if (player == null) {
            return;
        }
        int srpGearEquipped = 0;
        for (ItemStack stack : player.func_184209_aF()) {
            if (!SentientWeaponEvolutionHandler.isSRPLivingGear(stack.func_77973_b())) continue;
            ++srpGearEquipped;
        }
        int dividedHealth = (int)(Math.floor(victim.func_110138_aP()) / (double)srpGearEquipped);
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            boolean hasCurseOfPossession;
            ItemStack stack = player.func_184582_a(slot);
            if (!SentientWeaponEvolutionHandler.isSRPLivingGear(stack.func_77973_b())) continue;
            boolean isMeleeWeapon = stack.func_77973_b() instanceof WeaponToolMeleeBase;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            int currentKills = stack.func_77978_p().func_74762_e(srpkillsKey) + dividedHealth;
            stack.func_77978_p().func_74768_a(srpkillsKey, currentKills);
            if (!isMeleeWeapon) {
                ArrayList<String> loreTags = new ArrayList<String>();
                loreTags.add("" + TextFormatting.RESET + TextFormatting.BLUE + "---> " + currentKills);
                loreTags.add(stack.func_77973_b() instanceof WeaponToolRangeBase ? "eaglemixins.srptooltip.bow" : "eaglemixins.srptooltip.armor");
                SentientWeaponEvolutionHandler.setLocLore(stack, loreTags);
            } else {
                String loreTag = "eaglemixins.srptooltip.weapon";
                SentientWeaponEvolutionHandler.setLocLore(stack, Collections.singletonList(loreTag));
            }
            if (currentKills <= SRPConfig.weapon_livingSentient_HP_needed) continue;
            boolean isArmor = stack.func_77973_b() instanceof ItemArmor;
            for (int i = 0; i < (isArmor ? 10 : 1); ++i) {
                EntityChargedEmerald lightningBolt = new EntityChargedEmerald(player.field_70170_p, (EntityLivingBase)player);
                BlockPos randPos = player.func_180425_c();
                if (isArmor) {
                    randPos = randPos.func_177963_a(rand.nextGaussian() * 2.0, 0.0, rand.nextGaussian() * 2.0);
                }
                lightningBolt.func_70107_b((double)randPos.func_177958_n(), (double)randPos.func_177956_o(), (double)randPos.func_177952_p());
                player.field_70170_p.func_72838_d((Entity)lightningBolt);
            }
            String itemId = stack.func_77973_b().getRegistryName().func_110623_a();
            Item newItem = Item.func_111206_d((String)("srparasites:" + itemId + "_sentient"));
            if (newItem == null) continue;
            ItemStack newStack = new ItemStack(newItem);
            NBTTagCompound savedTags = stack.func_77978_p();
            newStack.func_77982_d(savedTags);
            if (isArmor && SRPMixinsConfigHandler.adaptation.overhaulAdaptation) {
                ICapabilityAdaptation adaCap = (ICapabilityAdaptation)stack.getCapability(CapabilityAdaptationHandler.CAP_ADAPTATION, null);
                ICapabilityAdaptation adaCapNew = (ICapabilityAdaptation)newStack.getCapability(CapabilityAdaptationHandler.CAP_ADAPTATION, null);
                if (adaCap != null && adaCapNew != null) {
                    adaCapNew.copyAdaptationsFrom(adaCap);
                }
            }
            if (!isMeleeWeapon) {
                newStack.func_77978_p().func_74775_l("display").func_82580_o("LocLore");
            }
            boolean bl = hasCurseOfPossession = EnchantmentHelper.func_82781_a((ItemStack)newStack).get(smeCoP) != null;
            if (hasCurseOfPossession || isArmor) {
                stack.func_190918_g(1);
                player.func_184201_a(slot, newStack);
                continue;
            }
            stack.func_190918_g(1);
            player.func_70099_a(newStack, 0.5f);
        }
    }

    private static void setLocLore(ItemStack stack, List<String> srpkillsToolTip) {
        NBTTagCompound displayCompound;
        NBTTagList lore = new NBTTagList();
        for (String s : srpkillsToolTip) {
            lore.func_74742_a((NBTBase)new NBTTagString(s));
        }
        if (stack.func_77978_p().func_74764_b("display")) {
            displayCompound = stack.func_77978_p().func_74775_l("display");
            displayCompound.func_74782_a("LocLore", (NBTBase)lore);
        } else {
            displayCompound = new NBTTagCompound();
            displayCompound.func_74782_a("LocLore", (NBTBase)lore);
            stack.func_77978_p().func_74782_a("display", (NBTBase)displayCompound);
        }
    }
}

