/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import biomesoplenty.api.item.BOPItems;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPStationaryArchitect;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.nexus.EntityVenkrol;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.nexus.EntityVenkrolSII;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.nexus.EntityVenkrolSIII;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.nexus.EntityVenkrolSIV;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.nexus.EntityVenkrolSV;
import eaglemixins.config.ForgeConfigHandler;
import eaglemixins.util.Ref;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SRParasitesHandler {
    private static ItemStack corruptedAshes = null;

    public static boolean isBiomeAllowed(ResourceLocation biomeId) {
        String id = biomeId.toString();
        String modid = biomeId.func_110624_b() + ":*";
        boolean isInList = ForgeConfigHandler.srparasites.getAllowedBiomeList().contains(modid) || ForgeConfigHandler.srparasites.getAllowedBiomeList().stream().anyMatch(listedBiome -> listedBiome.equalsIgnoreCase(id));
        return isInList == ForgeConfigHandler.srparasites.biomeListIsWhitelist;
    }

    private static ItemStack getCorruptedAshes() {
        if (corruptedAshes == null) {
            corruptedAshes = new ItemStack(BOPItems.ash, 1);
            corruptedAshes.func_190924_f("eaglemixins.tooltip.corruptedashes");
        }
        return corruptedAshes.func_77946_l();
    }

    private static boolean isBeckon(Entity entity) {
        if (!(entity instanceof EntityPStationaryArchitect)) {
            return false;
        }
        return entity instanceof EntityVenkrol || entity instanceof EntityVenkrolSII || entity instanceof EntityVenkrolSIII || entity instanceof EntityVenkrolSIV || entity instanceof EntityVenkrolSV;
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (world.field_72995_K || world.func_82737_E() % 50L != 23L) {
            return;
        }
        if (entity.field_71093_bK != 0 && entity.field_71093_bK != 3) {
            return;
        }
        if (!(entity instanceof EntityParasiteBase)) {
            return;
        }
        if (ForgeConfigHandler.abyssal.killAbyssalNexus && Ref.entityIsInAbyssalRift((Entity)entity)) {
            if (entity instanceof EntityPStationaryArchitect) {
                entity.func_70106_y();
            }
        } else if (ForgeConfigHandler.srparasites.killNearbyBeckon && SRParasitesHandler.isBeckon((Entity)entity)) {
            for (Entity entityNearby : entity.field_70170_p.func_72872_a(EntityPStationaryArchitect.class, new AxisAlignedBB(entity.func_180425_c()).func_186662_g((double)ForgeConfigHandler.srparasites.killNearbyBeckonRange))) {
                if (entityNearby == entity || !SRParasitesHandler.isBeckon(entityNearby)) continue;
                entityNearby.func_70106_y();
            }
        }
        if (entity.field_71093_bK == 3) {
            return;
        }
        if (!ForgeConfigHandler.srparasites.killEscapedParasites) {
            return;
        }
        ResourceLocation biomeReg = entity.field_70170_p.func_180494_b(entity.func_180425_c()).getRegistryName();
        if (biomeReg != null && SRParasitesHandler.isBiomeAllowed(biomeReg)) {
            return;
        }
        float health = entity.func_110143_aJ();
        if (health > 1000.0f) {
            entity.func_70606_j(health / 50.0f);
        } else if (health > 100.0f) {
            entity.func_70606_j(health / 10.0f);
        } else {
            entity.func_70606_j(health - 10.0f);
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!event.isSpawner()) {
            return;
        }
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof EntityParasiteBase)) {
            return;
        }
        ResourceLocation biomeReg = event.getWorld().func_180494_b(entity.func_180425_c()).getRegistryName();
        if (biomeReg != null && !SRParasitesHandler.isBiomeAllowed(biomeReg)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        ResourceLocation biomeReg;
        if (event.getDrops().isEmpty()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_71093_bK != 0) {
            return;
        }
        if (!(entity instanceof EntityParasiteBase)) {
            return;
        }
        if (entity.func_145818_k_()) {
            if (ForgeConfigHandler.srparasites.getAllowedParasiteNamesLoot().stream().anyMatch(entity.func_70005_c_()::contains)) {
                return;
            }
        }
        if ((biomeReg = entity.field_70170_p.func_180494_b(entity.func_180425_c()).getRegistryName()) != null && !SRParasitesHandler.isBiomeAllowed(biomeReg)) {
            ArrayList<EntityItem> itemsToRemove = new ArrayList<EntityItem>();
            ArrayList<EntityItem> itemsToAdd = new ArrayList<EntityItem>();
            for (EntityItem drop : event.getDrops()) {
                ResourceLocation itemId = drop.func_92059_d().func_77973_b().getRegistryName();
                if (itemId == null || !itemId.func_110624_b().equals("srparasites") || !(entity.func_70681_au().nextFloat() < ForgeConfigHandler.srparasites.chanceCorruptedAshes)) continue;
                itemsToRemove.add(drop);
                itemsToAdd.add(new EntityItem(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SRParasitesHandler.getCorruptedAshes()));
            }
            event.getDrops().removeAll(itemsToRemove);
            event.getDrops().addAll(itemsToAdd);
        } else {
            event.getDrops().clear();
            event.setCanceled(true);
        }
    }
}

