/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.config.ForgeConfigHandler;
import eaglemixins.util.Ref;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemChorusFruit;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RandomTpCancelHandler {
    private static Set<Potion> tpPotions = null;
    public static Set<String> tpMethods = null;
    private static List<Potion> tpCooldownPotions = null;
    private static final List<String> tpCooldownPotionStrings = new ArrayList<String>(Arrays.asList("potioncore:potion_sickness", "potioncore:teleport_surface"));
    private static final String tpCooldownKey = "TeleportCooldown";

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onLivingHurt(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        if (event.getSource() != DamageSource.field_76368_d) {
            return;
        }
        if (!RandomTpCancelHandler.isTpMethodEnabled("wallDmg")) {
            return;
        }
        if (!Ref.entityIsInAbyssalRift((Entity)entity) && !Ref.entityIsInAbyssalGate((Entity)entity)) {
            return;
        }
        RandomTpCancelHandler.applyTpCooldownDebuffs((EntityPlayer)entity);
    }

    @SubscribeEvent
    public static void onEnderPearlImpact(ProjectileImpactEvent.Throwable event) {
        if (!(event.getThrowable() instanceof EntityEnderPearl)) {
            return;
        }
        if (event.getThrowable().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entity = event.getThrowable().func_85052_h();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        if (!RandomTpCancelHandler.isTpMethodEnabled("enderPearl")) {
            return;
        }
        if (!Ref.entityIsInAbyssalRift((Entity)entity) && !Ref.entityIsInAbyssalGate((Entity)entity)) {
            return;
        }
        RandomTpCancelHandler.applyTpCooldownDebuffs((EntityPlayer)entity);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        if (!(event.getItem().func_77973_b() instanceof ItemChorusFruit)) {
            return;
        }
        if (!RandomTpCancelHandler.isTpMethodEnabled("chorusFruit")) {
            return;
        }
        if (!Ref.entityIsInAbyssalRift((Entity)entity) && !Ref.entityIsInAbyssalGate((Entity)entity)) {
            return;
        }
        RandomTpCancelHandler.applyTpCooldownDebuffs((EntityPlayer)entity);
    }

    @SubscribeEvent
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        if (!Ref.entityIsInAbyssalRift((Entity)entity) && !Ref.entityIsInAbyssalGate((Entity)entity)) {
            return;
        }
        if (RandomTpCancelHandler.isTpPotion(event.getPotionEffect().func_188419_a())) {
            RandomTpCancelHandler.applyTpCooldownDebuffs((EntityPlayer)entity);
        }
    }

    public static boolean isTpPotion(Potion potion) {
        if (tpPotions == null) {
            tpPotions = new HashSet<Potion>();
            for (String potionString : ForgeConfigHandler.abyssal.randomTpPots) {
                ResourceLocation location;
                if (!potionString.contains(":") || !ForgeRegistries.POTIONS.containsKey(location = new ResourceLocation(potionString))) continue;
                tpPotions.add((Potion)ForgeRegistries.POTIONS.getValue(location));
            }
        }
        return tpPotions.contains(potion);
    }

    public static boolean isTpMethodEnabled(String method) {
        if (tpMethods == null) {
            tpMethods = Arrays.stream(ForgeConfigHandler.abyssal.randomTpPots).filter(s -> !s.contains(":")).collect(Collectors.toSet());
        }
        return tpMethods.contains(method);
    }

    public static void applyTpCooldownDebuffs(EntityPlayer player) {
        if (!player.getEntityData().func_74764_b(tpCooldownKey)) {
            player.getEntityData().func_74772_a(tpCooldownKey, player.field_70170_p.func_82737_E());
        } else {
            long last;
            long now = player.field_70170_p.func_82737_E();
            if (now < (last = player.getEntityData().func_74763_f(tpCooldownKey)) + 100L) {
                return;
            }
            player.getEntityData().func_74772_a(tpCooldownKey, now);
            if (tpCooldownPotions == null) {
                tpCooldownPotions = new ArrayList<Potion>();
                for (String potionString : tpCooldownPotionStrings) {
                    ResourceLocation location = new ResourceLocation(potionString);
                    if (ForgeRegistries.POTIONS.containsKey(location)) {
                        tpCooldownPotions.add((Potion)ForgeRegistries.POTIONS.getValue(location));
                        continue;
                    }
                    tpCooldownPotions.add(null);
                }
            }
            if (tpCooldownPotions.get(0) != null) {
                player.func_70690_d(new PotionEffect(tpCooldownPotions.get(0), 200, 1));
            }
            if (tpCooldownPotions.get(1) != null) {
                player.func_70690_d(new PotionEffect(tpCooldownPotions.get(1), 1, 0));
            }
        }
    }

    public static void refreshConfig() {
        tpPotions = null;
        tpMethods = null;
    }
}

