/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.config.ForgeConfigHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RandomTippedArrowHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        ResourceLocation entityId = EntityList.func_191301_a((Entity)entity);
        if (entityId == null || !ForgeConfigHandler.tippedarrows.getTippedArrowAllowedEntities().contains(entityId)) {
            return;
        }
        if (!(entity.func_184614_ca().func_77973_b() instanceof ItemBow)) {
            return;
        }
        NBTTagCompound tag = entity.getEntityData();
        if (tag.func_74764_b("ArrowCheck")) {
            return;
        }
        tag.func_74757_a("ArrowCheck", true);
        if (entity.func_184592_cb().func_77973_b() instanceof ItemTippedArrow) {
            tag.func_74757_a("NoArrowSwitch", true);
            return;
        }
        if (entity.func_70681_au().nextFloat() <= ForgeConfigHandler.tippedarrows.tippedArrowReplacementChance) {
            tag.func_74757_a("ArrowEntity", true);
            entity.func_184201_a(EntityEquipmentSlot.OFFHAND, ForgeConfigHandler.tippedarrows.getRandomArrowStack(entity.func_70681_au(), false));
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        boolean isJester;
        EntityLivingBase victim = event.getEntityLiving();
        if (victim == null || victim.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getSource() == null || event.getSource().func_76346_g() == null) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityLivingBase)) {
            return;
        }
        if (!(event.getSource().func_76364_f() instanceof EntityArrow)) {
            return;
        }
        EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
        if (attacker instanceof EntityPlayer) {
            return;
        }
        ItemStack mainhand = attacker.func_184614_ca();
        if (!(mainhand.func_77973_b() instanceof ItemBow)) {
            return;
        }
        ItemStack offhand = attacker.func_184592_cb();
        if (!(offhand.func_77973_b() instanceof ItemTippedArrow)) {
            return;
        }
        for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)offhand)) {
            float durationMulti = 0.8f + 0.4f * attacker.func_70681_au().nextFloat();
            victim.func_70690_d(new PotionEffect(effect.func_188419_a(), (int)Math.max((float)effect.func_76459_b() / 8.0f * durationMulti, 1.0f), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
        }
        if (attacker.getEntityData().func_74764_b("NoArrowSwitch")) {
            return;
        }
        if (!attacker.getEntityData().func_74764_b("ArrowEntity")) {
            return;
        }
        float rngRoll = attacker.func_70681_au().nextFloat();
        boolean doSwap = (double)rngRoll < 0.2;
        boolean newArrowIsLong = (double)rngRoll < 0.01;
        boolean bl = isJester = attacker.func_145818_k_() && attacker.func_70005_c_().contains("Jester");
        if (isJester && doSwap || doSwap && newArrowIsLong) {
            attacker.func_184201_a(EntityEquipmentSlot.OFFHAND, ForgeConfigHandler.tippedarrows.getRandomArrowStack(attacker.func_70681_au(), true));
        } else if (isJester || doSwap) {
            attacker.func_184201_a(EntityEquipmentSlot.OFFHAND, ForgeConfigHandler.tippedarrows.getRandomArrowStack(attacker.func_70681_au(), false));
        }
    }
}

