/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.util.Ref;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PotionEffectsByFluidsHandler {
    private static final List<String> effectStrings = Arrays.asList("potioncore:dispel", "potioncore:weight", "minecraft:slowness", "srparasites:corrosive", "elenaidodge:sluggish", "lycanitesmobs:aphagia", "potioncore:potion_sickness", "potioncore:explode", "potioncore:launch", "minecraft:weakness", "simpledifficulty:hyperthermia");
    private static final int[] durations = new int[]{100, 100, 100, 100, 100, 100, 200, 1, 1, 100, 100};
    private static final int[] amplifiers = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2};
    private static List<PotionEffect> effects = null;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        if (world.func_82737_E() % 20L != 0L) {
            return;
        }
        ArrayList<ResourceLocation> blockColumn = new ArrayList<ResourceLocation>();
        for (int i = -1; i < 2; ++i) {
            blockColumn.add(world.func_180495_p(player.func_180425_c().func_177982_a(0, i, 0)).func_177230_c().getRegistryName());
        }
        blockColumn.add(world.func_180495_p(player.func_180425_c().func_177963_a(0.0, 1.5, 0.0)).func_177230_c().getRegistryName());
        for (ResourceLocation location : blockColumn) {
            if (location == null) continue;
            if (Ref.deadBloodReg.equals((Object)location)) {
                for (int i = 0; i < 4; ++i) {
                    player.func_70690_d(PotionEffectsByFluidsHandler.getEffect(i));
                }
                return;
            }
            if (location.toString().equals("biomesoplenty:blood")) {
                for (int i = 4; i < 6; ++i) {
                    player.func_70690_d(PotionEffectsByFluidsHandler.getEffect(i));
                }
                return;
            }
            if (!location.toString().equals("biomesoplenty:hot_spring_water")) continue;
            for (int i = 6; i < 11; ++i) {
                player.func_70690_d(PotionEffectsByFluidsHandler.getEffect(i));
            }
            return;
        }
    }

    private static PotionEffect getEffect(int id) {
        if (effects == null) {
            effects = new ArrayList<PotionEffect>();
            for (int i = 0; i < effectStrings.size(); ++i) {
                String effectString = effectStrings.get(i);
                Potion potion = Potion.func_180142_b((String)effectString);
                if (potion != null) {
                    effects.add(new PotionEffect(potion, durations[i], amplifiers[i]));
                    continue;
                }
                effects.add(new PotionEffect(MobEffects.field_76433_i, 0, 0));
            }
        }
        if (id >= 0 && id < effects.size()) {
            return new PotionEffect(effects.get(id));
        }
        return new PotionEffect(effects.get(0));
    }
}

