/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.config.ForgeConfigHandler;
import java.util.UUID;
import nc.capability.radiation.entity.IEntityRads;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IrradiatedParasitesHandler {
    private static final UUID HP_UUID = UUID.fromString("88b143a9-2850-4415-9dfc-810159c5179f");
    private static final UUID DMG_UUID = UUID.fromString("e6c9d15c-7835-4eb0-ad7e-a41c90a5a483");
    private static final UUID ARMOR_UUID = UUID.fromString("0cdaa41f-92d6-4575-9acc-3527810a859e");

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        boolean isInWhitelist;
        EntityLivingBase entity = event.getEntityLiving();
        ResourceLocation loc = EntityList.func_191301_a((Entity)entity);
        if (loc == null) {
            return;
        }
        String entityId = loc.toString();
        String modId = loc.func_110624_b() + ":*";
        boolean bl = isInWhitelist = ForgeConfigHandler.irradiated.getIrradiatedEntityList().contains(entityId) || ForgeConfigHandler.irradiated.getIrradiatedEntityList().contains(modId);
        if (isInWhitelist == ForgeConfigHandler.irradiated.irradiatedEntitiesIsBlacklist) {
            return;
        }
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (entity.field_70173_aa % 100 != 57) {
            return;
        }
        IEntityRads entityRadiation = (IEntityRads)entity.getCapability(IEntityRads.CAPABILITY_ENTITY_RADS, null);
        if (entityRadiation == null) {
            return;
        }
        double radsPercent = entityRadiation.getRadsPercentage();
        IrradiatedParasitesHandler.applyModifier(entity, radsPercent, SharedMonsterAttributes.field_111267_a, HP_UUID, ForgeConfigHandler.irradiated.hpMultiplier, ForgeConfigHandler.irradiated.hpUpperLimit);
        IrradiatedParasitesHandler.applyModifier(entity, radsPercent, SharedMonsterAttributes.field_111264_e, DMG_UUID, ForgeConfigHandler.irradiated.dmgMultiplier, ForgeConfigHandler.irradiated.dmgUpperLimit);
        IrradiatedParasitesHandler.applyModifier(entity, radsPercent, SharedMonsterAttributes.field_188791_g, ARMOR_UUID, ForgeConfigHandler.irradiated.armorMultiplier, ForgeConfigHandler.irradiated.armorUpperLimit);
    }

    private static void applyModifier(EntityLivingBase entity, double radsPercent, IAttribute attribute, UUID uuid, double multi, double cap) {
        if (entity.func_110148_a(attribute) == null) {
            return;
        }
        entity.func_110148_a(attribute).func_188479_b(uuid);
        double modifierAmount = -Math.min(radsPercent * multi, cap);
        if (Math.abs(modifierAmount) > 0.001) {
            entity.func_110148_a(attribute).func_111121_a(new AttributeModifier(uuid, "irradiated", modifierAmount, 2));
        }
    }
}

