/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.util.RadiationDamageSource;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.api.event.FirstAidLivingDamageEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class FirstAidRadiationHandler {
    private static final boolean DEBUG = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFirstAidDamage(FirstAidLivingDamageEvent event) {
        float post;
        String type;
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        DamageSource src = event.getSource();
        String string = type = src == null ? "" : src.func_76355_l();
        if (src != RadiationDamageSource.RADIATION && !"radiation".equalsIgnoreCase(type)) {
            return;
        }
        AbstractPlayerDamageModel before = event.getBeforeDamage();
        AbstractPlayerDamageModel after = event.getAfterDamage();
        float pre = before.getCurrentHealth();
        float incoming = Math.max(0.0f, pre - (post = after.getCurrentHealth())) + event.getUndistributedDamage();
        if (incoming <= 0.0f) {
            return;
        }
        for (EnumPlayerPart part : EnumPlayerPart.values()) {
            AbstractDamageablePart b = before.getFromEnum(part);
            AbstractDamageablePart a = after.getFromEnum(part);
            NBTTagCompound snap = (NBTTagCompound)b.serializeNBT();
            a.deserializeNBT((NBTBase)snap);
        }
        boolean applyDebuffs = true;
        incoming = FirstAidRadiationHandler.damagePart(after, EnumPlayerPart.LEFT_ARM, player, incoming, true, 0.0f);
        incoming = FirstAidRadiationHandler.damagePart(after, EnumPlayerPart.RIGHT_ARM, player, incoming, true, 0.0f);
        incoming = FirstAidRadiationHandler.damagePart(after, EnumPlayerPart.LEFT_LEG, player, incoming, true, 0.0f);
        incoming = FirstAidRadiationHandler.damagePart(after, EnumPlayerPart.RIGHT_LEG, player, incoming, true, 0.0f);
        incoming = FirstAidRadiationHandler.damagePart(after, EnumPlayerPart.LEFT_FOOT, player, incoming, true, 0.0f);
        incoming = FirstAidRadiationHandler.damagePart(after, EnumPlayerPart.RIGHT_FOOT, player, incoming, true, 0.0f);
        incoming = FirstAidRadiationHandler.damagePart(after, EnumPlayerPart.BODY, player, incoming, true, 0.0f);
        incoming = FirstAidRadiationHandler.damagePart(after, EnumPlayerPart.HEAD, player, incoming, true, 1.0f);
    }

    private static float damagePart(AbstractPlayerDamageModel model, EnumPlayerPart part, EntityPlayer player, float amt, boolean debuffs, float minHealth) {
        if (amt <= 0.0f) {
            return 0.0f;
        }
        AbstractDamageablePart p = model.getFromEnum(part);
        return p.damage(amt, player, debuffs, minHealth);
    }
}

