/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class FallDamageHandler {
    private static final long GRACE_TICKS = 200L;
    private static final float MIN_HEALTH_AFTER = 1.0f;
    private static volatile long SERVER_TICK = 0L;
    private static final ConcurrentMap<UUID, Long> GRACE_UNTIL_TICK = new ConcurrentHashMap<UUID, Long>();

    private FallDamageHandler() {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            ++SERVER_TICK;
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        if (e.player.field_70170_p.field_72995_K) {
            return;
        }
        GRACE_UNTIL_TICK.put(e.player.func_110124_au(), SERVER_TICK + 200L);
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        GRACE_UNTIL_TICK.remove(e.player.func_110124_au());
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        GRACE_UNTIL_TICK.remove(e.player.func_110124_au());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        FallDamageHandler.clampNonLethal(event.getEntityLiving() instanceof EntityPlayer ? (EntityPlayer)event.getEntityLiving() : null, event.getSource(), () -> ((LivingHurtEvent)event).getAmount(), arg_0 -> ((LivingHurtEvent)event).setAmount(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDamage(LivingDamageEvent event) {
        FallDamageHandler.clampNonLethal(event.getEntityLiving() instanceof EntityPlayer ? (EntityPlayer)event.getEntityLiving() : null, event.getSource(), () -> ((LivingDamageEvent)event).getAmount(), arg_0 -> ((LivingDamageEvent)event).setAmount(arg_0));
    }

    private static void clampNonLethal(EntityPlayer player, DamageSource src, Supplier<Float> getter, Consumer<Float> setter) {
        float maxAllowed;
        if (player == null || player.field_70170_p.field_72995_K) {
            return;
        }
        Long until = (Long)GRACE_UNTIL_TICK.get(player.func_110124_au());
        if (until == null || SERVER_TICK > until) {
            return;
        }
        if (src != DamageSource.field_76379_h && src != DamageSource.field_188406_j) {
            return;
        }
        float health = player.func_110143_aJ();
        float amount = getter.get().floatValue();
        if (amount > (maxAllowed = Math.max(0.0f, health - 1.0f))) {
            setter.accept(Float.valueOf(maxAllowed));
        }
    }
}

