/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.EagleMixins;
import eaglemixins.teleport.TeleportData;
import eaglemixins.teleport.TeleportRegistry;
import eaglemixins.teleport.TeleportService;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import svenhjol.charm.world.feature.EndPortalRunes;

public class EntitySpawnListener
extends Entity {
    private int linkId = -1;
    private boolean isSender = false;
    private boolean isReceiver = false;

    public static void init() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("eaglemixins", "spawn_listener"), EntitySpawnListener.class, (String)"SpawnListener", (int)128, (Object)EagleMixins.INSTANCE, (int)64, (int)1, (boolean)false);
    }

    public EntitySpawnListener(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70145_X = true;
        this.func_82142_c(true);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound c) {
        this.linkId = c.func_74762_e("linkId");
        this.isSender = c.func_74767_n("isSender");
        this.isReceiver = c.func_74767_n("isReceiver");
    }

    protected void func_70014_b(NBTTagCompound c) {
        c.func_74768_a("linkId", this.linkId);
        c.func_74757_a("isSender", this.isSender);
        c.func_74757_a("isReceiver", this.isReceiver);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        TeleportRegistry.ensureInit();
        if (!this.getEntityData().func_74767_n("activated")) {
            this.getEntityData().func_74757_a("activated", true);
            BlockPos center = this.func_180425_c().func_177977_b();
            this.activateRunes(center);
            TeleportData data = TeleportRegistry.getOrCreate(this.linkId);
            if (this.isSender) {
                TeleportRegistry.updateSender(this.linkId, center);
                TeleportRegistry.markTempReceiverIfEmpty(this.linkId);
            } else if (this.isReceiver && data.receiver == null) {
                TeleportRegistry.updateReceiver(this.linkId, center);
                for (EntityPlayer nearbyPlayer : this.field_70170_p.field_73010_i) {
                    NBTTagCompound persistTag = nearbyPlayer.getEntityData().func_74775_l("PlayerPersisted");
                    if (!persistTag.func_74767_n("justTeleported") || persistTag.func_74762_e("linkId") != this.linkId) continue;
                    TeleportService.enqueue(nearbyPlayer);
                    break;
                }
            }
            TeleportRegistry.put(this.linkId, data);
            MinecraftServer server = this.field_70170_p.func_73046_m();
            if (server != null) {
                server.func_152344_a(() -> ((EntitySpawnListener)this).func_70106_y());
            }
        }
    }

    private void activateRunes(BlockPos center) {
        int radius = 2;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                if (Math.abs(dx) <= 1 && Math.abs(dz) <= 1 || Math.abs(dx) == 2 && Math.abs(dz) == 2) continue;
                EndPortalRunes.activate((World)this.field_70170_p, (BlockPos)center.func_177982_a(dx, 0, dz));
            }
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }
}

