/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import javax.annotation.Nullable;
import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.common.visual.VisualRegistry;

public class EnhancedVisualsHandler {
    public static RadiationHandler RADIATION;

    public static void init() {
        RADIATION = new RadiationHandler();
        VisualRegistry.registerHandler((ResourceLocation)new ResourceLocation("eaglemixins", "radiation"), (VisualHandler)RADIATION);
    }

    public static class RadiationHandler
    extends VisualHandler {
        @CreativeConfig
        public double renderThresholdLow = 0.001;
        @CreativeConfig
        public double renderThresholdMedium = 0.05;
        @CreativeConfig
        public double renderThresholdHigh = 0.25;
        @CreativeConfig
        public double maxOpacityLow = 0.6;
        @CreativeConfig
        public double maxOpacityMedium = 0.8;
        @CreativeConfig
        public double maxOpacityHigh = 1.0;
        @CreativeConfig
        public double maxOpacity = 0.8;
        @CreativeConfig
        public double fadeFactor = 0.05;
        @CreativeConfig
        public VisualType radiation_low = new VisualTypeOverlay("radiation_low", 30);
        @CreativeConfig
        public VisualType radiation_med = new VisualTypeOverlay("radiation_med", 20);
        @CreativeConfig
        public VisualType radiation_high = new VisualTypeOverlay("radiation_high", 10);
        public Visual radiationLowVisual;
        public Visual radiationMedVisual;
        public Visual radiationHighVisual;

        public void tick(@Nullable EntityPlayer player) {
            if (this.radiationLowVisual == null) {
                this.radiationLowVisual = new Visual(this.radiation_low, (VisualHandler)this, 0);
                this.radiationLowVisual.setOpacityInternal(0.0f);
                VisualManager.add((Visual)this.radiationLowVisual);
                this.radiationMedVisual = new Visual(this.radiation_med, (VisualHandler)this, 0);
                this.radiationMedVisual.setOpacityInternal(0.0f);
                VisualManager.add((Visual)this.radiationMedVisual);
                this.radiationHighVisual = new Visual(this.radiation_high, (VisualHandler)this, 0);
                this.radiationHighVisual.setOpacityInternal(0.0f);
                VisualManager.add((Visual)this.radiationHighVisual);
            }
            double lowOpac = 0.0;
            double medOpac = 0.0;
            double highOpac = 0.0;
            if (player != null) {
                IEntityRads playerRads;
                double radPerc = 0.0;
                if (NCConfig.radiation_enabled_public && (playerRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player)) != null && !playerRads.isImmune()) {
                    radPerc = playerRads.getRadiationLevel();
                }
                if (radPerc > this.renderThresholdHigh) {
                    lowOpac = this.maxOpacity;
                    medOpac = this.maxOpacity;
                    highOpac = this.maxOpacity * Math.min(1.0, (radPerc - this.renderThresholdHigh) / Math.max(0.01, 1.0 - this.renderThresholdHigh));
                } else if (radPerc > this.renderThresholdMedium) {
                    lowOpac = this.maxOpacity;
                    medOpac = this.maxOpacity * Math.min(1.0, (radPerc - this.renderThresholdMedium) / Math.max(0.01, this.renderThresholdHigh - this.renderThresholdMedium));
                } else if (radPerc > this.renderThresholdLow) {
                    lowOpac = this.maxOpacity * Math.min(1.0, (radPerc - this.renderThresholdLow) / Math.max(0.01, this.renderThresholdMedium - this.renderThresholdLow));
                }
            }
            lowOpac *= this.maxOpacityLow;
            medOpac *= this.maxOpacityMedium;
            highOpac *= this.maxOpacityHigh;
            if ((double)this.radiationLowVisual.getOpacityInternal() < lowOpac) {
                this.radiationLowVisual.setOpacityInternal((float)Math.min((double)this.radiationLowVisual.getOpacityInternal() + this.fadeFactor, lowOpac));
            } else if ((double)this.radiationLowVisual.getOpacityInternal() > lowOpac) {
                this.radiationLowVisual.setOpacityInternal((float)Math.max((double)this.radiationLowVisual.getOpacityInternal() - this.fadeFactor, lowOpac));
            }
            if ((double)this.radiationMedVisual.getOpacityInternal() < medOpac) {
                this.radiationMedVisual.setOpacityInternal((float)Math.min((double)this.radiationMedVisual.getOpacityInternal() + this.fadeFactor, medOpac));
            } else if ((double)this.radiationMedVisual.getOpacityInternal() > medOpac) {
                this.radiationMedVisual.setOpacityInternal((float)Math.max((double)this.radiationMedVisual.getOpacityInternal() - this.fadeFactor, medOpac));
            }
            if ((double)this.radiationHighVisual.getOpacityInternal() < highOpac) {
                this.radiationHighVisual.setOpacityInternal((float)Math.min((double)this.radiationHighVisual.getOpacityInternal() + this.fadeFactor, highOpac));
            } else if ((double)this.radiationHighVisual.getOpacityInternal() > highOpac) {
                this.radiationHighVisual.setOpacityInternal((float)Math.max((double)this.radiationHighVisual.getOpacityInternal() - this.fadeFactor, highOpac));
            }
        }
    }
}

