/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.config.ForgeConfigHandler;
import eaglemixins.util.Ref;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DismountHandler {
    private static final List<ResourceLocation> biomeNames = Arrays.asList(Ref.abyssalRiftReg, Ref.parasiteBiomeReg);
    private static final String dismountKey = "LastAbyssalDismountStrike";

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        EntityLivingBase attacker;
        boolean doDismount;
        EntityLivingBase victim = event.getEntityLiving();
        if (!victim.func_184218_aH()) {
            return;
        }
        if (event.getSource() == null) {
            return;
        }
        String damageType = event.getSource().func_76355_l();
        boolean bl = doDismount = damageType.equals(DamageSource.field_180137_b.field_76373_n) || event.getAmount() > 6.0f;
        if (event.getSource().func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_145818_k_() && (attacker.func_70005_c_().contains("Dismounter") || attacker.func_70005_c_().contains("Dismounting"))) {
            doDismount = true;
        }
        if (damageType.equals("dragon_ice") || damageType.equals("dragon_fire") || damageType.equals("dragon_lightning")) {
            for (ItemStack armor : victim.func_184193_aE()) {
                ResourceLocation itemId = armor.func_77973_b().getRegistryName();
                if (itemId == null || itemId.func_110624_b().equals("iceandfire") && !itemId.func_110623_a().contains("metal")) continue;
                doDismount = true;
            }
        }
        if (doDismount) {
            event.getEntityLiving().func_184210_p();
            event.getEntityLiving().func_184226_ay();
        }
    }

    @SubscribeEvent
    public void onPlayerDamaged(LivingAttackEvent event) {
        if (!ForgeConfigHandler.server.dismounterTarget) {
            return;
        }
        EntityLivingBase victim = event.getEntityLiving();
        if (!victim.func_184218_aH()) {
            return;
        }
        if (event.getSource() == null) {
            return;
        }
        if (!biomeNames.contains(victim.field_70170_p.func_180494_b(victim.func_180425_c()).getRegistryName()) && victim instanceof EntityPlayer && event.getSource().func_76346_g() instanceof EntityLivingBase && victim.func_184218_aH()) {
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            if (attacker.func_145818_k_() && (attacker.func_70005_c_().contains("Dismounter") || attacker.func_70005_c_().contains("Dismounting"))) {
                event.getEntityLiving().func_184210_p();
            }
            event.getEntityLiving().func_184226_ay();
        }
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        EntityPlayer player;
        if (!ForgeConfigHandler.abyssal.abyssalMounts) {
            return;
        }
        if (!event.isMounting()) {
            return;
        }
        if (!(event.getEntityMounting() instanceof EntityPlayer)) {
            return;
        }
        if (!(event.getEntityBeingMounted() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase mount = (EntityLivingBase)event.getEntityBeingMounted();
        ResourceLocation mountId = EntityList.func_191301_a((Entity)mount);
        if (mountId != null) {
            for (String allowedMount : ForgeConfigHandler.abyssal.allowedAbyssalMounts) {
                if (!allowedMount.equals(mountId.toString())) continue;
                return;
            }
        }
        if (biomeNames.contains(player.field_70170_p.func_180494_b((player = (EntityPlayer)event.getEntityMounting()).func_180425_c()).getRegistryName())) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("eaglemixins.messages.mountspooked", new Object[0]), true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        long worldTime = world.func_82737_E();
        if (worldTime % 40L != 0L) {
            return;
        }
        if (!player.func_184218_aH()) {
            return;
        }
        if (!(player.func_184187_bx() instanceof EntityLivingBase)) {
            return;
        }
        if (Ref.deadBloodReg.equals((Object)world.func_180495_p(player.func_180425_c()).func_177230_c().getRegistryName())) {
            event.player.func_184226_ay();
            event.player.func_184210_p();
            return;
        }
        if (!ForgeConfigHandler.abyssal.abyssalMounts) {
            return;
        }
        if (!biomeNames.contains(player.field_70170_p.func_180494_b(player.func_180425_c()).getRegistryName())) {
            player.getEntityData().func_74772_a(dismountKey, 0L);
            return;
        }
        ResourceLocation mountId = EntityList.func_191301_a((Entity)player.func_184187_bx());
        if (mountId != null) {
            for (String allowedMount : ForgeConfigHandler.abyssal.allowedAbyssalMounts) {
                if (!allowedMount.equals(mountId.toString())) continue;
                return;
            }
        }
        if (!player.getEntityData().func_74764_b(dismountKey) || player.getEntityData().func_74763_f(dismountKey) == 0L) {
            player.getEntityData().func_74772_a(dismountKey, worldTime);
            TextComponentTranslation msg = new TextComponentTranslation("eaglemixins.messages.ominousfeeling", new Object[0]);
            player.func_146105_b((ITextComponent)msg, true);
            player.func_146105_b((ITextComponent)msg, false);
        } else if (worldTime > player.getEntityData().func_74763_f(dismountKey) + 100L) {
            player.getEntityData().func_74772_a(dismountKey, 0L);
            event.player.func_184226_ay();
            event.player.func_184210_p();
            event.player.func_70690_d(new PotionEffect(Ref.getLightning()));
        }
    }
}

