/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public final class ContainerNBTRadHandler {
    private static final String BET = "BlockEntityTag";
    private static final String FD = "ForgeData";
    private static final String KEY = "RadShield";
    private static final int NBT_COMPOUND = 10;
    private static final int NBT_DOUBLE = 6;
    private static final ConcurrentMap<DimPos, Pending> STASH = new ConcurrentHashMap<DimPos, Pending>();
    private static final long STASH_TTL_MS = 5000L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickItemSmartCancel(PlayerInteractEvent.RightClickItem e) {
        if (e.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        ItemStack held = e.getItemStack();
        if (held.func_190926_b()) {
            return;
        }
        ResourceLocation id = held.func_77973_b().getRegistryName();
        if (id == null || !"nuclearcraft".equals(id.func_110624_b()) || !"rad_shielding".equals(id.func_110623_a())) {
            return;
        }
        if (!e.getEntityPlayer().func_70093_af()) {
            return;
        }
        if (!NCConfig.radiation_tile_shielding) {
            return;
        }
        if (NCConfig.radiation_hardcore_containers <= 0.0) {
            return;
        }
        RayTraceResult hit = e.getEntityPlayer().func_174822_a(5.0, 1.0f);
        if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        LegacyProbe p = ContainerNBTRadHandler.probeLegacy(e.getWorld(), hit.func_178782_a(), held);
        if (p.applicable && !p.modern) {
            e.setCanceled(true);
            e.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlockApply(PlayerInteractEvent.RightClickBlock e) {
        boolean wouldSucceed;
        if (e.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        World world = e.getWorld();
        EntityPlayer player = e.getEntityPlayer();
        ItemStack held = e.getItemStack();
        if (held.func_190926_b()) {
            return;
        }
        ResourceLocation id = held.func_77973_b().getRegistryName();
        if (id == null || !"nuclearcraft".equals(id.func_110624_b()) || !"rad_shielding".equals(id.func_110623_a())) {
            return;
        }
        if (!NCConfig.radiation_tile_shielding) {
            return;
        }
        if (!player.func_70093_af()) {
            return;
        }
        if (NCConfig.radiation_hardcore_containers <= 0.0) {
            return;
        }
        LegacyProbe p = ContainerNBTRadHandler.probeLegacy(world, e.getPos(), held);
        if (p.modern || !p.applicable) {
            return;
        }
        boolean bl = wouldSucceed = p.newVal > p.cur;
        if (world.field_72995_K) {
            if (wouldSucceed) {
                player.func_184185_a(SoundEvents.field_187692_g, 0.5f, 1.0f);
            }
            return;
        }
        if (!wouldSucceed) {
            player.func_145747_a(new TextComponentTranslation("item.nuclearcraft.rad_shielding.install_fail", new Object[0]).func_150258_a(" " + RadiationHelper.resistanceSigFigs((double)p.cur)));
            return;
        }
        if (p.rad == null) {
            return;
        }
        p.rad.setRadiationResistance(p.newVal);
        p.te.getTileData().func_74780_a(KEY, p.newVal);
        p.te.func_70296_d();
        held.func_190918_g(1);
        player.func_145747_a(new TextComponentTranslation("item.nuclearcraft.rad_shielding.install_success", new Object[0]).func_150258_a(" " + RadiationHelper.resistanceSigFigs((double)p.newVal)));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBreak(BlockEvent.BreakEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = e.getPos();
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return;
        }
        double val = 0.0;
        IRadiationResistance cap = (IRadiationResistance)te.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
        if (cap != null) {
            val = Math.max(val, cap.getRadiationResistance());
        }
        if (te.getTileData().func_150297_b(KEY, 6)) {
            val = Math.max(val, te.getTileData().func_74769_h(KEY));
        }
        if (val <= 0.0) {
            return;
        }
        Item blockItem = Item.func_150898_a((Block)e.getState().func_177230_c());
        STASH.put(new DimPos(world.field_73011_w.getDimension(), pos), new Pending(val, blockItem, System.currentTimeMillis()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        DimPos key = new DimPos(world.field_73011_w.getDimension(), e.getPos());
        Pending p = (Pending)STASH.get(key);
        if (p == null || p.isExpired()) {
            STASH.remove(key);
            return;
        }
        if (p.value <= 0.0) {
            STASH.remove(key);
            return;
        }
        Item blockItem = Item.func_150898_a((Block)e.getState().func_177230_c());
        if (blockItem == null) {
            return;
        }
        for (ItemStack drop : e.getDrops()) {
            if (drop.func_190926_b() || drop.func_77973_b() != blockItem) continue;
            ContainerNBTRadHandler.writeShieldToItem(drop, p.value);
            STASH.remove(key);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent e) {
        if (e.getWorld().field_72995_K) {
            return;
        }
        if (!(e.getEntity() instanceof EntityItem)) {
            return;
        }
        EntityItem entityItem = (EntityItem)e.getEntity();
        ItemStack stack = entityItem.func_92059_d();
        if (stack.func_190926_b()) {
            return;
        }
        int dim = e.getWorld().field_73011_w.getDimension();
        BlockPos spawnPos = new BlockPos(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v);
        long now = System.currentTimeMillis();
        STASH.entrySet().removeIf(en -> ((Pending)en.getValue()).isExpired(now));
        for (Map.Entry en2 : STASH.entrySet()) {
            DimPos dp = (DimPos)en2.getKey();
            Pending p = (Pending)en2.getValue();
            if (dp.dim != dim || spawnPos.func_177951_i((Vec3i)dp.pos) > 2.25 || p.expectedItem != null && stack.func_77973_b() != p.expectedItem) continue;
            ContainerNBTRadHandler.writeShieldToItem(stack, p.value);
            STASH.remove(dp);
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlace(BlockEvent.PlaceEvent e) {
        double cur;
        NBTTagCompound fd;
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        ItemStack stack = e.getItemInHand();
        if (stack == null || stack.func_190926_b() || !stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_150297_b(BET, 10)) {
            return;
        }
        NBTTagCompound bet = tag.func_74775_l(BET);
        Double val = null;
        if (bet.func_150297_b(KEY, 6)) {
            val = bet.func_74769_h(KEY);
        } else if (bet.func_150297_b(FD, 10) && (fd = bet.func_74775_l(FD)).func_150297_b(KEY, 6)) {
            val = fd.func_74769_h(KEY);
        }
        if (val == null || val <= 0.0) {
            return;
        }
        TileEntity te = world.func_175625_s(e.getPos());
        if (te == null) {
            return;
        }
        IRadiationResistance cap = (IRadiationResistance)te.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
        if (cap != null && val > cap.getRadiationResistance()) {
            cap.setRadiationResistance(val.doubleValue());
        }
        double d = cur = te.getTileData().func_150297_b(KEY, 6) ? te.getTileData().func_74769_h(KEY) : 0.0;
        if (val > cur) {
            te.getTileData().func_74780_a(KEY, val.doubleValue());
            te.func_70296_d();
        }
    }

    private static void writeShieldToItem(ItemStack drop, double val) {
        if (drop == null || drop.func_190926_b() || val <= 0.0) {
            return;
        }
        NBTTagCompound tag = drop.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        NBTTagCompound bet = tag.func_150297_b(BET, 10) ? tag.func_74775_l(BET) : new NBTTagCompound();
        bet.func_74780_a(KEY, val);
        NBTTagCompound fd = bet.func_150297_b(FD, 10) ? bet.func_74775_l(FD) : new NBTTagCompound();
        fd.func_74780_a(KEY, val);
        bet.func_74782_a(FD, (NBTBase)fd);
        tag.func_74782_a(BET, (NBTBase)bet);
        drop.func_77982_d(tag);
    }

    private static double valueFromShieldStack(ItemStack held) {
        double[] levels = NCConfig.radiation_shielding_level;
        int idx = Math.max(0, Math.min(held.func_77960_j(), levels.length - 1));
        return levels[idx];
    }

    private static boolean hasAnyModernCap(TileEntity te) {
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) || te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return true;
        }
        for (EnumFacing f : EnumFacing.values()) {
            if (!te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, f) && !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f)) continue;
            return true;
        }
        return false;
    }

    private static LegacyProbe probeLegacy(World world, BlockPos pos, ItemStack held) {
        boolean legacy;
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return new LegacyProbe(false, false, 0.0, 0.0, null, null);
        }
        boolean modern = ContainerNBTRadHandler.hasAnyModernCap(te);
        boolean bl = legacy = te instanceof IInventory || te instanceof ISidedInventory;
        if (!legacy) {
            return new LegacyProbe(modern, false, 0.0, 0.0, te, null);
        }
        IRadiationResistance rad = (IRadiationResistance)te.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
        if (rad == null) {
            return new LegacyProbe(modern, false, 0.0, 0.0, te, null);
        }
        double cur = rad.getRadiationResistance();
        if (te.getTileData().func_150297_b(KEY, 6)) {
            cur = Math.max(cur, te.getTileData().func_74769_h(KEY));
        }
        double newVal = ContainerNBTRadHandler.valueFromShieldStack(held);
        return new LegacyProbe(modern, true, cur, newVal, te, rad);
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload e) {
        int dim = e.getWorld().field_73011_w.getDimension();
        STASH.keySet().removeIf(k -> k.dim == dim);
    }

    private static final class Pending {
        final double value;
        final Item expectedItem;
        final long ts;

        Pending(double v, Item i, long t) {
            this.value = v;
            this.expectedItem = i;
            this.ts = t;
        }

        boolean isExpired() {
            return this.isExpired(System.currentTimeMillis());
        }

        boolean isExpired(long now) {
            return now - this.ts > 5000L;
        }
    }

    private static final class DimPos {
        final int dim;
        final BlockPos pos;

        DimPos(int d, BlockPos p) {
            this.dim = d;
            this.pos = p.func_185334_h();
        }

        public boolean equals(Object o) {
            return o instanceof DimPos && this.dim == ((DimPos)o).dim && this.pos.equals((Object)((DimPos)o).pos);
        }

        public int hashCode() {
            return Objects.hash(this.dim, this.pos);
        }
    }

    private static final class LegacyProbe {
        final boolean modern;
        final boolean applicable;
        final double cur;
        final double newVal;
        final TileEntity te;
        final IRadiationResistance rad;

        LegacyProbe(boolean modern, boolean applicable, double cur, double newVal, TileEntity te, IRadiationResistance rad) {
            this.modern = modern;
            this.applicable = applicable;
            this.cur = cur;
            this.newVal = newVal;
            this.te = te;
            this.rad = rad;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final class Tooltip {
        @SubscribeEvent
        public static void onTooltip(ItemTooltipEvent e) {
            NBTTagCompound fd;
            ItemStack stack = e.getItemStack();
            if (stack.func_190926_b() || !stack.func_77942_o()) {
                return;
            }
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null || !tag.func_150297_b(ContainerNBTRadHandler.BET, 10)) {
                return;
            }
            NBTTagCompound bet = tag.func_74775_l(ContainerNBTRadHandler.BET);
            Double v = null;
            if (bet.func_150297_b(ContainerNBTRadHandler.KEY, 6)) {
                v = bet.func_74769_h(ContainerNBTRadHandler.KEY);
            } else if (bet.func_150297_b(ContainerNBTRadHandler.FD, 10) && (fd = bet.func_74775_l(ContainerNBTRadHandler.FD)).func_150297_b(ContainerNBTRadHandler.KEY, 6)) {
                v = fd.func_74769_h(ContainerNBTRadHandler.KEY);
            }
            if (v == null || v <= 0.0) {
                return;
            }
            e.getToolTip().add(TextFormatting.AQUA + "Rad Resistance: " + RadiationHelper.resistanceSigFigs((double)v));
        }
    }
}

