/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.config.ForgeConfigHandler;
import eaglemixins.util.Ref;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConductivityHandler {
    private static final String savedTimeKey = "LightningLastSavedTime";
    private static final String hasWarnedKey = "LightningHasWarned";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean hasWarned;
        boolean doShock;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        long worldTime = world.func_82737_E();
        if (worldTime % 100L != 0L) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        boolean isThundering = world.func_72911_I();
        if (!world.func_72896_J() || world.func_175699_k(player.func_180425_c()) != 15) {
            ConductivityHandler.resetLightningNBT(player, worldTime);
            return;
        }
        boolean bl = doShock = isThundering || player.func_184187_bx() != null || world.func_175623_d(player.func_180425_c().func_177982_a(0, -1, 0));
        if (!doShock) {
            ConductivityHandler.resetLightningNBT(player, worldTime);
            return;
        }
        int conductivityOnEquipment = 0;
        for (ItemStack stack : player.func_184209_aF()) {
            if (stack.equals(ItemStack.field_190927_a)) continue;
            conductivityOnEquipment += ForgeConfigHandler.conductivity.getItemConductivity(stack);
        }
        if (!isThundering) {
            conductivityOnEquipment /= 2;
        }
        if (conductivityOnEquipment == 0) {
            ConductivityHandler.resetLightningNBT(player, worldTime);
            return;
        }
        if (!player.getEntityData().func_74764_b(savedTimeKey)) {
            player.getEntityData().func_74772_a(savedTimeKey, worldTime);
        }
        long lastSavedTime = player.getEntityData().func_74763_f(savedTimeKey);
        if (!player.getEntityData().func_74764_b(hasWarnedKey)) {
            player.getEntityData().func_74757_a(hasWarnedKey, false);
        }
        if (!(hasWarned = player.getEntityData().func_74767_n(hasWarnedKey))) {
            if (worldTime > lastSavedTime + (long)(isThundering ? 400 : 1200) && player.func_70681_au().nextInt(100) < conductivityOnEquipment) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("eaglemixins.conductivity." + player.func_70681_au().nextInt(8), new Object[0]), true);
                player.getEntityData().func_74772_a(savedTimeKey, worldTime);
                player.getEntityData().func_74757_a(hasWarnedKey, true);
            }
        } else if (worldTime > lastSavedTime + 60L) {
            if (Ref.getLightning() != null) {
                player.func_70690_d(new PotionEffect(Ref.getLightning()));
            }
            player.getEntityData().func_74772_a(savedTimeKey, worldTime);
            player.getEntityData().func_74757_a(hasWarnedKey, false);
        }
    }

    private static void resetLightningNBT(EntityPlayer player, long worldTime) {
        player.getEntityData().func_74772_a(savedTimeKey, worldTime);
        player.getEntityData().func_74757_a(hasWarnedKey, false);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onTooltip(ItemTooltipEvent event) {
        int conductivity = ForgeConfigHandler.conductivity.getItemConductivity(event.getItemStack());
        if (conductivity > 0) {
            event.getToolTip().add("" + TextFormatting.YELLOW + TextFormatting.ITALIC + I18n.func_135052_a((String)"eaglemixins.conductivity.tooltip", (Object[])new Object[]{conductivity}));
        }
    }
}

