/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockNoclipHandler {
    private static final List<String> MATCH_PATTERNS = Arrays.asList("comforts:sleeping_bag", "comforts:hammock", "variedcommodities:chair", "variedcommodities:couch_wool", "variedcommodities:couch_wood", "variedcommodities:stool", "minecraft:bed");
    private static final Predicate<String> matchWildcard = registryName -> MATCH_PATTERNS.stream().anyMatch(registryName::startsWith);

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        ResourceLocation rl = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        if (rl == null) {
            return;
        }
        String fullName = rl.toString();
        if (!matchWildcard.test(fullName)) {
            return;
        }
        BlockPos posAbove = pos.func_177984_a();
        Material matAbove = world.func_180495_p(posAbove).func_185904_a();
        if (!matAbove.func_76222_j() && !matAbove.func_76224_d() && matAbove != Material.field_151579_a) {
            event.setCanceled(true);
            if (!event.getWorld().field_72995_K) {
                String blockName = state.func_177230_c().func_149732_F();
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentString("\u00a7cThe " + blockName + " is obstructed."), true);
            }
        }
    }
}

