/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.item.BOPItems;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockDropsHandler {
    private static final Map<String, BlockSpec> DEEPSLATE_MAP = new HashMap<String, BlockSpec>();
    private static final Map<String, ItemStack> itemMap;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getHarvester() == null) {
            return;
        }
        Random harvesterRNG = event.getHarvester().func_70681_au();
        IBlockState state = event.getState();
        Block harvestedBlock = state.func_177230_c();
        if (harvestedBlock.getRegistryName() == null) {
            return;
        }
        String blockId = harvestedBlock.getRegistryName().toString();
        if (harvestedBlock.equals(BOPBlocks.seaweed)) {
            if (event.isSilkTouching()) {
                return;
            }
            Item item = Item.func_111206_d((String)"aquaculture:food");
            if (item != null) {
                event.getDrops().clear();
                event.getDrops().add(new ItemStack(item, 1, 0));
            }
            return;
        }
        if (blockId.equals("eaglemixins:deepslate")) {
            if (event.isSilkTouching()) {
                return;
            }
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contenttweaker:cobbled_deepslate", 1.0f);
            return;
        }
        if (blockId.equals("biomesoplenty:gem_ore:0")) {
            if (event.isSilkTouching()) {
                return;
            }
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "iceandfire:amethyst_gem", 1.0f);
            return;
        }
        if (blockId.equals("contentcreator:iron_slab_reinforced")) {
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:iron_slab_reinforced", 1.0f);
            return;
        }
        if (blockId.equals("contentcreator:concrete_slab_reinforced")) {
            if (event.isSilkTouching()) {
                event.getDrops().clear();
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:concrete_slab_reinforced", 1.0f);
                return;
            }
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "minecraft:concrete_powder:8", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "minecraft:iron_nugget", 1.0f, 1, 3);
            return;
        }
        if (blockId.equals("contentcreator:concrete_slab_reinforced_double")) {
            if (event.isSilkTouching()) {
                event.getDrops().clear();
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:reinforced_concrete", 1.0f);
                return;
            }
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "minecraft:concrete_powder:8", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "minecraft:iron_nugget", 1.0f, 1, 6);
            return;
        }
        if (blockId.equals("contentcreator:concrete_stairs_reinforced")) {
            if (event.isSilkTouching()) {
                event.getDrops().clear();
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:concrete_stairs_reinforced", 1.0f);
                return;
            }
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "minecraft:concrete_powder:8", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "minecraft:iron_nugget", 1.0f, 1, 5);
            return;
        }
        if (blockId.equals("contentcreator:iron_plate_slab_reinforced_double")) {
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:iron_plate_slab_reinforced", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:iron_plate_slab_reinforced", 1.0f);
            return;
        }
        if (blockId.equals("contentcreator:deepslate_tile_slab_double")) {
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:deepslate_tile_slab", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:deepslate_tile_slab", 1.0f);
            return;
        }
        if (blockId.equals("contentcreator:polished_deepslate_slab_double")) {
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:polished_deepslate_slab", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:polished_deepslate_slab", 1.0f);
            return;
        }
        if (blockId.equals("contentcreator:deepslate_brick_slab_double")) {
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:deepslate_brick_slab", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:deepslate_brick_slab", 1.0f);
            return;
        }
        if (blockId.equals("contentcreator:deepslate_slab_double")) {
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:deepslate_slab", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:deepslate_slab", 1.0f);
            return;
        }
        if (blockId.equals("contentcreator:cobbled_deepslate_slab_double")) {
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:cobbled_deepslate_slab", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contentcreator:cobbled_deepslate_slab", 1.0f);
            return;
        }
        if (harvestedBlock == Blocks.field_150432_aD || harvestedBlock == Blocks.field_150403_cj || blockId.equals("iceandfire:dragon_ice") || harvestedBlock.equals(BOPBlocks.hard_ice)) {
            if (event.isSilkTouching()) {
                return;
            }
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "simpledifficulty:ice_chunk", 1.0f);
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "simpledifficulty:ice_chunk", 0.5f);
            return;
        }
        if (blockId.equals("dimstack:bedrock")) {
            event.getDrops().clear();
            int blockState = harvestedBlock.func_176201_c(state);
            if (blockState == 7) {
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/stone", 1.0f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/stone", 0.5f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/stone", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/basalt", 0.5f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/basalt", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:flint_shard", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:flint_shard", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "simpledifficulty:magma_chunk", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "simpledifficulty:magma_chunk", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "rustic:dust_tiny_iron", 0.1f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "rustic:dust_tiny_iron", 0.1f);
            }
            if (blockState == 6) {
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/stone", 1.0f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/stone", 0.5f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/stone", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/basalt", 0.5f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "notreepunching:rock/basalt", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, new ItemStack(BOPItems.crystal_shard), 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, new ItemStack(BOPItems.crystal_shard), 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "defiledlands:defilement_powder", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "defiledlands:defilement_powder", 0.3f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contenttweaker:steel_nugget", 0.1f);
                BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, "contenttweaker:steel_nugget", 0.1f);
            }
            return;
        }
        if (blockId.equals("contenttweaker:resource_crate")) {
            event.getDrops().clear();
            World world = event.getWorld();
            LootTableManager lootManager = world.func_184146_ak();
            ResourceLocation lootTable = new ResourceLocation("eaglemixins", "blocks/resource_crate");
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world).func_186469_a((float)event.getFortuneLevel());
            List loot = lootManager.func_186521_a(lootTable).func_186462_a(world.field_73012_v, builder.func_186471_a());
            event.getDrops().addAll(loot);
            return;
        }
        if (harvestedBlock.equals(BOPBlocks.biome_block)) {
            if (event.isSilkTouching()) {
                return;
            }
            event.getDrops().clear();
            BlockDropsHandler.addDrop((List<ItemStack>)event.getDrops(), harvesterRNG, new ItemStack(BOPItems.biome_essence), 1.0f);
        }
        if (DEEPSLATE_MAP.containsKey(blockId)) {
            BlockSpec src = DEEPSLATE_MAP.get(blockId);
            Block srcBlock = (Block)ForgeRegistries.BLOCKS.getValue(src.id);
            if (srcBlock == null) {
                return;
            }
            IBlockState srcState = src.meta >= 0 ? srcBlock.func_176203_a(src.meta) : srcBlock.func_176223_P();
            event.getDrops().clear();
            if (event.isSilkTouching()) {
                Item item = Item.func_150898_a((Block)srcBlock);
                if (item != null) {
                    event.getDrops().add(new ItemStack(item, 1, Math.max(0, src.meta)));
                }
                return;
            }
            List newDrops = srcBlock.getDrops((IBlockAccess)event.getWorld(), event.getPos(), srcState, event.getFortuneLevel());
            event.getDrops().addAll(newDrops);
        }
    }

    private static BlockSpec parseBlockSpec(String spec) {
        String[] parts = spec.split(":");
        String mod = parts[0];
        String path = parts[1];
        int meta = -1;
        if (parts.length >= 3) {
            try {
                meta = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new BlockSpec(new ResourceLocation(mod, path), meta);
    }

    private static void addDrop(List<ItemStack> drops, Random rng, String location, float chance) {
        BlockDropsHandler.addDrop(drops, rng, location, chance, 1, 1);
    }

    private static void addDrop(List<ItemStack> drops, Random rng, String location, float chance, int min, int max) {
        if (!itemMap.containsKey(location)) {
            Item item;
            String[] parts = location.split(":");
            if (parts.length < 2) {
                return;
            }
            String modid = parts[0];
            String name = parts[1];
            int meta = 0;
            if (parts.length >= 3) {
                try {
                    meta = Integer.parseInt(parts[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((item = Item.func_111206_d((String)(modid + ":" + name))) != null) {
                itemMap.put(location, new ItemStack(item, 1, meta));
            }
        }
        BlockDropsHandler.addDrop(drops, rng, itemMap.get(location), chance, min, max);
    }

    private static void addDrop(List<ItemStack> drops, Random rng, ItemStack newDrop, float chance) {
        BlockDropsHandler.addDrop(drops, rng, newDrop, chance, 1, 1);
    }

    private static void addDrop(List<ItemStack> drops, Random rng, ItemStack newDrop, float chance, int min, int max) {
        if ((chance >= 1.0f || rng.nextFloat() < chance) && newDrop != null) {
            int amount = MathHelper.func_76136_a((Random)rng, (int)min, (int)max);
            ItemStack stack = newDrop.func_77946_l();
            stack.func_190920_e(amount);
            drops.add(stack);
        }
    }

    static {
        DEEPSLATE_MAP.put("contenttweaker:deepslate_copper_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_copper_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_silver_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_silver_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_diamond_ore", BlockDropsHandler.parseBlockSpec("minecraft:diamond_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_emerald_ore", BlockDropsHandler.parseBlockSpec("minecraft:emerald_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_lapis_ore", BlockDropsHandler.parseBlockSpec("minecraft:lapis_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_redstone_ore", BlockDropsHandler.parseBlockSpec("minecraft:redstone_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_gold_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_gold_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_iron_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_iron_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_coal_ore", BlockDropsHandler.parseBlockSpec("minecraft:coal_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_lead_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_lead_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_thorium_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_thorium_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_uranium_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_uranium_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_boron_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_boron_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_lithium_ore", BlockDropsHandler.parseBlockSpec("contenttweaker:deepslate_lithium_ore"));
        DEEPSLATE_MAP.put("contenttweaker:deepslate_crystal_ore", BlockDropsHandler.parseBlockSpec("scalinghealth:crystalore"));
        itemMap = new HashMap<String, ItemStack>();
    }

    private static final class BlockSpec {
        final ResourceLocation id;
        final int meta;

        BlockSpec(ResourceLocation id, int meta) {
            this.id = id;
            this.meta = meta;
        }
    }
}

