/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.rank.Rank;
import c4.champions.common.rank.RankManager;
import c4.champions.common.util.ChampionHelper;
import com.lothrazar.playerbosses.EntityPlayerBoss;
import eaglemixins.config.ForgeConfigHandler;
import eaglemixins.handlers.util.AbyssalRiftSpawn;
import eaglemixins.util.Ref;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlightedShivaxiHandler {
    private static final String symbol = "\u2622";
    private static final String blightedShivaxiName = TextFormatting.DARK_RED + "\u2622" + " " + TextFormatting.DARK_GREEN + TextFormatting.BOLD + "Blighted Shivaxi" + TextFormatting.RESET + TextFormatting.DARK_RED + " " + "\u2622";
    private static final List<String> phase2Spawns = Arrays.asList("srparasites:buglin", "srparasites:sim_adventurerhead", "srparasites:rupter", "srparasites:incompleteform_medium", "srparasites:pri_yelloweye");
    private static final int[] phase2Weights = new int[]{6, 3, 3, 2, 1};
    private static final int phase2TotalWeights = 15;
    private static final List<String> phase3Spawns = Arrays.asList("srparasites:sim_villager", "srparasites:sim_human", "srparasites:sim_bigspider", "srparasites:pri_arachnida", "srparasites:ada_arachnida");
    private static final int[] phase3Weights = new int[]{5, 4, 3, 2, 1};
    private static final int phase3TotalWeights = 15;
    private static final String spawnCountKey = "MinionsSpawned";

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        IChampionship chp;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || entity.field_70170_p.field_72995_K || entity.field_71093_bK != 0) {
            return;
        }
        if (!(entity instanceof EntityPlayerBoss)) {
            return;
        }
        if (!entity.func_70005_c_().equals("Shivaxi")) {
            return;
        }
        if (!AbyssalRiftSpawn.isAbyssalRiftSpawn((Entity)entity)) {
            return;
        }
        entity.field_70170_p.func_72876_a((Entity)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 4.0f, false);
        Entity regEnt = EntityList.func_188429_b((ResourceLocation)Ref.dragonBossReg, (World)entity.field_70170_p);
        if (!(regEnt instanceof EntityLiving)) {
            return;
        }
        EntityLiving toSpawn = (EntityLiving)regEnt;
        NBTTagCompound comp = toSpawn.func_189511_e(new NBTTagCompound());
        comp.func_74778_a("DeathLootTable", "dregora:entities/playerbosses/abyssal_tower_shivaxi");
        comp.func_74757_a("parasitedespawn", false);
        toSpawn.func_70037_a(comp);
        toSpawn.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (ChampionHelper.isValidChampion((Entity)toSpawn) && (chp = CapabilityChampionship.getChampionship((EntityLiving)toSpawn)) != null && chp.getRank() == null) {
            Rank rank = RankManager.getRankForTier((int)1);
            chp.setRank(rank);
            Set affixes = ChampionHelper.generateAffixes((Rank)rank, (EntityLiving)toSpawn, (String[])new String[0]);
            chp.setAffixes(affixes);
            chp.setName(blightedShivaxiName);
            chp.getRank().applyGrowth((EntityLivingBase)toSpawn);
            for (String s : chp.getAffixes()) {
                AffixBase affix = AffixRegistry.getAffix((String)s);
                if (affix == null) continue;
                affix.onInitialSpawn(toSpawn, chp);
            }
        }
        toSpawn.func_96094_a(blightedShivaxiName);
        toSpawn.func_110163_bv();
        toSpawn.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("LoweredHealth", (double)ForgeConfigHandler.server.blightedShivaxiHealthModifier, 1));
        toSpawn.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier("RaisedArmor", (double)ForgeConfigHandler.server.blightedShivaxiArmorModifier, 1));
        toSpawn.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier("RaisedAttackDamage", (double)ForgeConfigHandler.server.blightedShivaxiDamageModifier, 1));
        entity.field_70170_p.func_72838_d((Entity)toSpawn);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!Ref.entityIsInAbyssalRift((Entity)entity)) {
            return;
        }
        if (event.getAmount() > 100.0f && !entity.func_184222_aU()) {
            event.setAmount(100.0f);
        }
        if (entity instanceof EntityPlayerBoss) {
            boolean isPhase3;
            float maxHealth = entity.func_110138_aP();
            float phase2 = maxHealth / 2.0f;
            float phase3 = maxHealth / 4.0f;
            float currHealth = entity.func_110143_aJ();
            if (!entity.getEntityData().func_74764_b(spawnCountKey)) {
                entity.getEntityData().func_74768_a(spawnCountKey, 0);
            }
            int spawnedCounter = entity.getEntityData().func_74762_e(spawnCountKey);
            boolean isPhase2 = currHealth < phase2;
            boolean bl = isPhase3 = currHealth < phase3;
            if (isPhase2 || isPhase3) {
                if (isPhase3) {
                    event.setAmount(event.getAmount() * 0.25f);
                } else {
                    event.setAmount(event.getAmount() * 0.75f);
                }
                if (spawnedCounter < 50) {
                    int spawnCount = entity.func_70681_au().nextInt(6);
                    block0: for (int i = 0; i < spawnCount; ++i) {
                        Entity entityToSpawn = null;
                        String entityToSpawnId = isPhase3 ? BlightedShivaxiHandler.getRandomEntity(entity.func_70681_au(), phase3Spawns, phase3Weights, 15) : BlightedShivaxiHandler.getRandomEntity(entity.func_70681_au(), phase2Spawns, phase2Weights, 15);
                        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityToSpawnId));
                        if (entry != null) {
                            entityToSpawn = entry.newInstance(entity.field_70170_p);
                        }
                        if (entityToSpawn == null) continue;
                        int spawnDist = MathHelper.func_76136_a((Random)entity.func_70681_au(), (int)5, (int)10);
                        for (int j = 0; j < 10; ++j) {
                            float angle = entity.func_70681_au().nextFloat() * 6.14f;
                            BlockPos pos = entity.func_180425_c().func_177963_a((double)spawnDist * Math.cos(angle), 3.0, (double)spawnDist * Math.sin(angle));
                            if (!entity.field_70170_p.func_175623_d(pos)) continue;
                            entityToSpawn.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                            entity.field_70170_p.func_72838_d(entityToSpawn);
                            ++spawnedCounter;
                            continue block0;
                        }
                    }
                    entity.getEntityData().func_74768_a(spawnCountKey, spawnedCounter);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        Entity entity = event.getEntity();
        if (entity instanceof AbyssalRiftSpawn) {
            ((AbyssalRiftSpawn)entity).updateSpawnPosition(event.getWorld(), event.getX(), event.getY(), event.getZ());
        }
    }

    private static String getRandomEntity(Random rand, List<String> phaseSpawns, int[] phaseWeights, int phaseTotalWeights) {
        int randWeight = rand.nextInt(phaseTotalWeights);
        String selectedEntityName = phaseSpawns.get(0);
        for (int i = 0; i < phaseSpawns.size(); ++i) {
            if ((randWeight -= phaseWeights[i]) >= 0) continue;
            selectedEntityName = phaseSpawns.get(i);
            break;
        }
        return selectedEntityName;
    }
}

