/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import biomesoplenty.api.item.BOPItems;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BerryDebuffHandler {
    private static ArrayList<Potion> berryPotions = null;
    private static final ArrayList<String> berryPotionStrings = new ArrayList<String>(Arrays.asList("minecraft:nausea", "lycanitesmobs:aphagia", "simpledifficulty:parasites", "mod_lavacow:soiled", "potioncore:vulnerable"));

    @Nullable
    private static Potion getBerryPotion(int index) {
        if (berryPotions == null) {
            berryPotions = new ArrayList();
            for (String potionString : berryPotionStrings) {
                ResourceLocation location = new ResourceLocation(potionString);
                if (ForgeRegistries.POTIONS.containsKey(location)) {
                    berryPotions.add((Potion)ForgeRegistries.POTIONS.getValue(location));
                    continue;
                }
                berryPotions.add(null);
            }
        }
        return berryPotions.get(index);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        Potion potion;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        Item itemUsed = event.getItem().func_77973_b();
        if (itemUsed.getRegistryName() == null) {
            return;
        }
        if (!itemUsed.equals(BOPItems.berries)) {
            return;
        }
        int duration = 60 + player.func_70681_au().nextInt(140);
        int amplifier = player.func_70681_au().nextInt(3);
        int potionRoll = player.func_70681_au().nextInt(100);
        if (potionRoll < 10 && (potion = BerryDebuffHandler.getBerryPotion(0)) != null) {
            player.func_70690_d(new PotionEffect(potion, duration, amplifier));
        }
        if (potionRoll < 7 && (potion = BerryDebuffHandler.getBerryPotion(1)) != null) {
            player.func_70690_d(new PotionEffect(potion, duration, amplifier));
        }
        if (potionRoll < 5 && (potion = BerryDebuffHandler.getBerryPotion(2)) != null) {
            player.func_70690_d(new PotionEffect(potion, duration, amplifier));
        }
        if (potionRoll < 3 && (potion = BerryDebuffHandler.getBerryPotion(3)) != null) {
            player.func_70690_d(new PotionEffect(potion, duration, amplifier));
        }
        if (potionRoll < 1 && (potion = BerryDebuffHandler.getBerryPotion(4)) != null) {
            player.func_70690_d(new PotionEffect(potion, duration, amplifier));
        }
    }
}

