/*
 * Decompiled with CFR 0.152.
 */
package eaglemixins.handlers;

import eaglemixins.config.ForgeConfigHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class BerianHandler {
    private static final ResourceLocation LIBRARIAN = new ResourceLocation("minecraft:librarian");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        BerianHandler.updateBerian(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        BerianHandler.updateBerian(event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70173_aa == 1) {
            BerianHandler.updateBerian(event.getEntity());
        }
    }

    private static void updateBerian(Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityVillager)) {
            return;
        }
        if (ForgeConfigHandler.berian.sussyberianChance <= 0.0 && ForgeConfigHandler.berian.mentalberianChance <= 0.0) {
            return;
        }
        EntityVillager villager = (EntityVillager)entity;
        VillagerRegistry.VillagerProfession profession = villager.getProfessionForge();
        if (!LIBRARIAN.equals((Object)profession.getRegistryName())) {
            return;
        }
        if (villager.func_145818_k_()) {
            return;
        }
        if (villager.getEntityData().func_74764_b("SussyBerianNaming")) {
            return;
        }
        if (villager.getEntityData().func_74764_b("BerianCheck")) {
            return;
        }
        villager.getEntityData().func_74757_a("BerianCheck", true);
        double combinedChance = ForgeConfigHandler.berian.sussyberianChance + ForgeConfigHandler.berian.mentalberianChance;
        if ((double)villager.func_70681_au().nextFloat() > combinedChance) {
            return;
        }
        if ((double)villager.func_70681_au().nextFloat() * combinedChance < ForgeConfigHandler.berian.sussyberianChance) {
            villager.func_96094_a("Sussyberian");
            villager.getEntityData().func_74757_a("Sussyberian", true);
        } else {
            villager.func_96094_a("Mentalberian");
            villager.getEntityData().func_74757_a("Mentalberian", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerInteractEntity(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getTarget() instanceof EntityVillager)) {
            return;
        }
        EntityVillager villager = (EntityVillager)event.getTarget();
        boolean isMental = villager.getEntityData().func_74767_n("Mentalberian");
        boolean isSussy = villager.getEntityData().func_74767_n("Sussyberian");
        if (isMental || isSussy) {
            BerianHandler.applyBerianEffects(event.getEntityPlayer(), villager, isSussy);
            event.setCanceled(true);
        }
    }

    private static void applyBerianEffects(EntityPlayer player, EntityVillager berian, boolean isSussy) {
        Potion potion;
        List<Potion> potions;
        List<Potion> list = potions = isSussy ? ForgeConfigHandler.berian.getSussyberianEffects() : ForgeConfigHandler.berian.getMentalberianEffects();
        if (!potions.isEmpty()) {
            potion = potions.get(player.func_70681_au().nextInt(potions.size()));
            if (potion.func_76403_b()) {
                potion.func_180793_a((Entity)berian, (Entity)berian, (EntityLivingBase)player, 2, 1.0);
            } else {
                player.func_70690_d(new PotionEffect(potion, 200, 2));
            }
        }
        if ((potion = ForgeConfigHandler.berian.getBerianConstantEffect()).func_76403_b()) {
            potion.func_180793_a((Entity)berian, (Entity)berian, (EntityLivingBase)player, 1, 1.0);
        } else {
            player.func_70690_d(new PotionEffect(potion, 200, 1));
        }
    }

    public static void copyBerianTags(Entity from, Entity to) {
        NBTTagCompound oldData = from.getEntityData();
        if (oldData.func_82582_d() || !oldData.func_74764_b("BerianCheck")) {
            return;
        }
        NBTTagCompound newData = to.getEntityData();
        newData.func_74757_a("BerianCheck", oldData.func_74767_n("BerianCheck"));
        if (oldData.func_74764_b("Sussyberian")) {
            newData.func_74757_a("Sussyberian", oldData.func_74767_n("Sussyberian"));
        } else if (oldData.func_74764_b("Mentalberian")) {
            newData.func_74757_a("Mentalberian", oldData.func_74767_n("Mentalberian"));
        }
    }
}

